/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.search.syntax.function;

import eu.europeana.api.search.syntax.converter.ConverterContext;
import eu.europeana.api.search.syntax.field.FieldMode;
import eu.europeana.api.search.syntax.field.FieldType;
import eu.europeana.api.search.syntax.function.FunctionClass;
import eu.europeana.api.search.syntax.model.ArgumentExpression;
import eu.europeana.api.search.syntax.model.FunctionExpression;
import eu.europeana.api.search.syntax.model.ValueExpression;
import eu.europeana.api.search.syntax.utils.ParserUtils;
import eu.europeana.api.search.syntax.validation.SyntaxErrorUtils;
import java.util.List;

public class DistanceFunction
implements FunctionClass {
    public static final String SOLR_GEODISTANCE_QUERY = "{!geofilt}";

    @Override
    public String getName() {
        return "distance";
    }

    @Override
    public int getArgumentNr() {
        return 4;
    }

    @Override
    public boolean isValid(FunctionExpression expr) {
        return true;
    }

    @Override
    public String toSolr(FunctionExpression expr, ConverterContext context) {
        List<ArgumentExpression> params = expr.getParameters();
        expr.validateArgs();
        this.updateGeoFieldName(context, params);
        this.updateLatitudeAndLongitude(context, params);
        this.updateDistance(context, params);
        return SOLR_GEODISTANCE_QUERY;
    }

    private void updateGeoFieldName(ConverterContext context, List<ArgumentExpression> params) {
        String fieldName = this.getGeoField(params.get(0), context);
        context.setParameter("sfield", List.of(fieldName + "_wgs"));
    }

    private void updateDistance(ConverterContext context, List<ArgumentExpression> params) {
        Float distance = this.getFloatValue(params.get(3));
        if (distance.floatValue() < 0.0f || (double)distance.floatValue() > 24000.0) {
            SyntaxErrorUtils.newWrongFunctionArg(this.getName(), "4th", "positive decimal number which is less than possible distance between two points on Earth (20.004 km)");
        }
        context.setParameter("d", List.of(String.valueOf(distance)));
    }

    private void updateLatitudeAndLongitude(ConverterContext context, List<ArgumentExpression> params) {
        Float longitude;
        Float latitude = this.getFloatValue(params.get(1));
        if ((double)Math.abs(latitude.floatValue()) > 90.0) {
            SyntaxErrorUtils.newWrongFunctionArg(this.getName(), "2nd", " value for latitude must be between -90.0 and 90.0");
        }
        if ((double)Math.abs((longitude = this.getFloatValue(params.get(2))).floatValue()) > 180.0) {
            SyntaxErrorUtils.newWrongFunctionArg(this.getName(), "3rd", " value for longitude must be between -180.0 and 180.0");
        }
        context.setParameter("pt", List.of(latitude + "," + longitude));
    }

    private Float getFloatValue(ArgumentExpression argument) {
        if (!(argument instanceof ValueExpression)) {
            SyntaxErrorUtils.newException(String.format("Unable to get float value ! Expected Type: %s", "ValueExpression"));
        }
        String value = ((ValueExpression)argument).getValue();
        return Float.valueOf(Float.parseFloat(value));
    }

    private String getGeoField(ArgumentExpression arg, ConverterContext context) {
        if (!(arg instanceof ValueExpression)) {
            SyntaxErrorUtils.newWrongFunctionArg(this.getName(), "1st", "valid field name");
        }
        return ParserUtils.getValidFieldFromRegistry((ValueExpression)arg, context, FieldType.GEO, FieldMode.SEARCH);
    }
}

