/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.search.syntax.function;

import eu.europeana.api.search.syntax.converter.ConverterContext;
import eu.europeana.api.search.syntax.field.FieldMode;
import eu.europeana.api.search.syntax.field.FieldType;
import eu.europeana.api.search.syntax.function.FunctionClass;
import eu.europeana.api.search.syntax.function.IntervalFunction;
import eu.europeana.api.search.syntax.model.ArgumentExpression;
import eu.europeana.api.search.syntax.model.FieldQueryExpression;
import eu.europeana.api.search.syntax.model.FunctionExpression;
import eu.europeana.api.search.syntax.model.ValueExpression;
import eu.europeana.api.search.syntax.utils.ParserUtils;
import eu.europeana.api.search.syntax.validation.SyntaxErrorUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DateFunction
implements FunctionClass {
    public static final String NAME = "date";
    private static final String SOLR_DATE_QUERY = "_query_:\"{!field f=%s op=%s}%s\"";
    private static final String DATE_WILDCARD = "*";
    private static final String DATE_NOW = "now";
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final Pattern datePattern = Pattern.compile("[0-9]{4}(-[0-9]{2}(-[0-9]{2})?)?");

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getArgumentNr() {
        return 2;
    }

    @Override
    public boolean isValid(FunctionExpression expr) {
        return true;
    }

    public String toString() {
        return "DateFunction{} " + this.getName();
    }

    @Override
    public String toSolr(FunctionExpression expr, ConverterContext context) {
        if (context.contains(FieldQueryExpression.class)) {
            SyntaxErrorUtils.newWrongQueryExpression(this.getName());
        }
        expr.validateArgs();
        List<ArgumentExpression> params = expr.getParameters();
        String field = this.getDateField(context, params);
        String date = this.getDate("2nd", params.get(1), context);
        String operation = this.getOperation().getValue();
        if (context.getIsToSurroundWithFilterFunction()) {
            return String.format("filter(_query_:\"{!field f=%s op=%s}%s\")", field, operation, date);
        }
        return String.format(SOLR_DATE_QUERY, field, operation, date);
    }

    private String getDateField(ConverterContext context, List<ArgumentExpression> params) {
        if (!(params.get(0) instanceof ValueExpression)) {
            SyntaxErrorUtils.newWrongFunctionArg(this.getName(), "1st", "valid field name");
        }
        return ParserUtils.getValidFieldFromRegistry((ValueExpression)params.get(0), context, FieldType.DATE, FieldMode.SEARCH);
    }

    protected Operation getOperation() {
        return Operation.CONTAINS;
    }

    protected String getDate(String argNr, ArgumentExpression arg, ConverterContext context) {
        FunctionExpression functionExpr;
        if (arg instanceof ValueExpression) {
            ValueExpression expr = (ValueExpression)arg;
            String value = expr.getValue();
            if (StringUtils.isNotBlank((CharSequence)value)) {
                if (value.equals(DATE_WILDCARD) || datePattern.matcher(value).matches()) {
                    return value;
                }
                if (value.equalsIgnoreCase(DATE_NOW)) {
                    return this.dateFormat.format(new Date());
                }
            }
        } else if (arg instanceof FunctionExpression && (functionExpr = (FunctionExpression)arg).getFunction() instanceof IntervalFunction) {
            return arg.toSolr(context);
        }
        SyntaxErrorUtils.newWrongFunctionArg(this.getName(), argNr, "date expression or interval function");
        return null;
    }

    public static enum Operation {
        INTERSECTS("Intersects"),
        CONTAINS("Contains"),
        WITHIN("Within");

        private String value;

        private Operation(String val) {
            this.value = val;
        }

        public String getValue() {
            return this.value;
        }
    }
}

