/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.search.syntax.converter;

import eu.europeana.api.search.syntax.field.FieldDeclaration;
import eu.europeana.api.search.syntax.field.FieldRegistry;
import eu.europeana.api.search.syntax.function.FunctionRegistry;
import eu.europeana.api.search.syntax.model.SyntaxExpression;
import eu.europeana.api.search.syntax.validation.SyntaxErrorUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class ConverterContext
extends Stack<SyntaxExpression> {
    private FieldRegistry fieldRegistry;
    private FunctionRegistry functionRegistry;
    private Map<String, List<String>> paramMap = new LinkedHashMap<String, List<String>>();
    private boolean isToSurroundWithFilterFunction = false;

    public ConverterContext() {
        this.fieldRegistry = FieldRegistry.INSTANCE;
        this.functionRegistry = FunctionRegistry.INSTANCE;
    }

    public Set<Map.Entry<String, List<String>>> getParameters() {
        return this.paramMap.entrySet();
    }

    public void setParameter(String key, List<String> value) {
        this.paramMap.put(key, value);
    }

    public boolean contains(Class<?> clazz) {
        for (SyntaxExpression expr : this) {
            if (!clazz.isAssignableFrom(expr.getClass())) continue;
            return true;
        }
        return false;
    }

    public FieldDeclaration getField(String name) {
        FieldDeclaration field = this.fieldRegistry.getField(name);
        if (field == null) {
            SyntaxErrorUtils.newUnknownField(name);
        }
        return field;
    }

    public boolean getIsToSurroundWithFilterFunction() {
        return this.isToSurroundWithFilterFunction;
    }

    public void setIsToSurroundWithFilterFunction(boolean value) {
        this.isToSurroundWithFilterFunction = value;
    }
}

