/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.zoho.utils;

import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class WikidataUtils {
    public static boolean isWikidataOrganization(String id, String entityType) {
        return EntityTypes.Organization.getEntityType().equals(entityType) && WikidataUtils.isWikidataEntity(id);
    }

    public static boolean isWikidataEntity(String id) {
        return id.contains("www.wikidata.org");
    }

    public static Optional<String> getWikidataId(List<String> uriList) {
        if (uriList != null) {
            return uriList.stream().filter(WikidataUtils::isWikidataEntity).findFirst();
        }
        return Optional.empty();
    }

    public static List<String> getAllWikidataIds(List<String> uriList) {
        if (uriList == null || uriList.isEmpty()) {
            return Collections.emptyList();
        }
        return uriList.stream().filter(WikidataUtils::isWikidataEntity).collect(Collectors.toList());
    }
}

