/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.zoho.organization;

import eu.europeana.entitymanagement.zoho.ZohoAccessClient;
import eu.europeana.entitymanagement.zoho.utils.ZohoException;
import eu.europeana.entitymanagement.zoho.utils.ZohoInMemoryTokenStore;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration(value="zohoConfiguration")
@PropertySource(value={"classpath:zoho_import.properties"}, ignoreResourceNotFound=true)
public class ZohoConfiguration {
    @Value(value="${zoho.email:#{null}}")
    private String zohoEmail;
    @Value(value="${zoho.client.id:#{null}}")
    private String zohoClientId;
    @Value(value="${zoho.client.secret:#{null}}")
    private String zohoClientSecret;
    @Value(value="${zoho.refresh.token:#{null}}")
    private String zohoRefreshToken;
    @Value(value="${zoho.redirect.url:#{null}}")
    private String zohoRedirectUrl;
    @Value(value="${zoho.base.url:#{null}}")
    private String zohoBaseUrl;
    private ZohoAccessClient zohoAccessClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZohoAccessClient getZohoAccessClient() throws ZohoException {
        if (this.zohoAccessClient == null) {
            ZohoConfiguration zohoConfiguration = this;
            synchronized (zohoConfiguration) {
                if (this.zohoAccessClient == null) {
                    this.zohoAccessClient = new ZohoAccessClient(new ZohoInMemoryTokenStore(), this.zohoEmail, this.zohoClientId, this.zohoClientSecret, this.zohoRefreshToken, this.zohoRedirectUrl);
                }
            }
        }
        return this.zohoAccessClient;
    }

    public String getZohoBaseUrl() {
        return this.zohoBaseUrl;
    }

    public void setZohoBaseUrl(String zohoBaseUrl) {
        this.zohoBaseUrl = zohoBaseUrl;
    }
}

