/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.zoho;

import com.zoho.api.authenticator.OAuthToken;
import com.zoho.api.authenticator.Token;
import com.zoho.api.authenticator.store.TokenStore;
import com.zoho.crm.api.HeaderMap;
import com.zoho.crm.api.Initializer;
import com.zoho.crm.api.Param;
import com.zoho.crm.api.ParameterMap;
import com.zoho.crm.api.SDKConfig;
import com.zoho.crm.api.UserSignature;
import com.zoho.crm.api.dc.DataCenter;
import com.zoho.crm.api.dc.EUDataCenter;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.record.APIException;
import com.zoho.crm.api.record.ActionHandler;
import com.zoho.crm.api.record.ActionResponse;
import com.zoho.crm.api.record.ActionWrapper;
import com.zoho.crm.api.record.BodyWrapper;
import com.zoho.crm.api.record.DeletedRecord;
import com.zoho.crm.api.record.DeletedRecordsHandler;
import com.zoho.crm.api.record.DeletedRecordsWrapper;
import com.zoho.crm.api.record.Record;
import com.zoho.crm.api.record.RecordOperations;
import com.zoho.crm.api.record.ResponseHandler;
import com.zoho.crm.api.record.ResponseWrapper;
import com.zoho.crm.api.record.SuccessResponse;
import com.zoho.crm.api.util.APIResponse;
import eu.europeana.entitymanagement.utils.EntityRecordUtils;
import eu.europeana.entitymanagement.zoho.utils.ZohoException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZohoAccessClient {
    private static final Logger LOGGER = LogManager.getLogger(ZohoAccessClient.class);

    public ZohoAccessClient(TokenStore tokenStore, String zohoEmail, String clientId, String clientSecret, String refreshToken, String redirectUrl) throws ZohoException {
        try {
            UserSignature userSignature = new UserSignature(zohoEmail);
            OAuthToken token = new OAuthToken(clientId, clientSecret, refreshToken, OAuthToken.TokenType.REFRESH, redirectUrl);
            SDKConfig sdkConfig = new SDKConfig.Builder().setAutoRefreshFields(false).setPickListValidation(true).build();
            DataCenter.Environment environment = EUDataCenter.PRODUCTION;
            String resourcePath = SystemUtils.getUserHome().getAbsolutePath();
            Initializer.initialize((UserSignature)userSignature, (DataCenter.Environment)environment, (Token)token, (TokenStore)tokenStore, (SDKConfig)sdkConfig, (String)resourcePath);
        }
        catch (SDKException e) {
            throw new ZohoException("Error initializing ZohoAccessClient", e);
        }
    }

    public Optional<Record> getZohoRecordOrganizationById(String zohoUrl) throws ZohoException {
        String zohoId = EntityRecordUtils.getIdentifierFromUrl((String)zohoUrl);
        try {
            RecordOperations recordOperations = new RecordOperations();
            ParameterMap paramInstance = new ParameterMap();
            paramInstance.add(RecordOperations.SearchRecordsParam.CRITERIA, (Object)String.format("(%s:%s:%s)", "id", "equals", zohoId));
            APIResponse response = recordOperations.searchRecords("Accounts", paramInstance);
            return ZohoAccessClient.getZohoRecords((APIResponse<ResponseHandler>)response).stream().findFirst();
        }
        catch (SDKException e) {
            throw new ZohoException("Zoho search organization by organization id threw an exception", e);
        }
    }

    public void updateZohoRecordOrganizationStringField(String zohoUrl, String fieldName, String fieldValue) throws ZohoException {
        String zohoId = EntityRecordUtils.getIdentifierFromUrl((String)zohoUrl);
        try {
            RecordOperations recordOperations = new RecordOperations();
            BodyWrapper request = this.buildUpdateRequest(fieldName, fieldValue);
            APIResponse response = recordOperations.updateRecord(Long.valueOf(zohoId), "Accounts", request);
            this.validateZohoUpdateResponse((APIResponse<ActionHandler>)response);
        }
        catch (SDKException e) {
            throw new ZohoException("Zoho update the organization field threw an exception.", e);
        }
    }

    BodyWrapper buildUpdateRequest(String fieldName, String fieldValue) {
        BodyWrapper request = new BodyWrapper();
        ArrayList<Record> records = new ArrayList<Record>();
        Record record1 = new Record();
        record1.addKeyValue(fieldName, (Object)fieldValue);
        records.add(record1);
        request.setData(records);
        return request;
    }

    private void validateZohoUpdateResponse(APIResponse<ActionHandler> response) throws ZohoException {
        if (response == null || !response.isExpected()) {
            throw new ZohoException("Unexpected response during updating a field in Zoho." + response.getStatusCode() + response.getObject());
        }
        ActionHandler actionHandler = (ActionHandler)response.getObject();
        if (actionHandler instanceof APIException) {
            throw new ZohoException(this.extractErrorMessage((APIException)actionHandler));
        }
        if (actionHandler instanceof ActionWrapper) {
            this.verifyZohoConfirmationResponse(actionHandler);
        }
    }

    void verifyZohoConfirmationResponse(ActionHandler actionHandler) throws ZohoException {
        ActionWrapper actionWrapper = (ActionWrapper)actionHandler;
        List actionResponses = actionWrapper.getData();
        for (ActionResponse actionResponse : actionResponses) {
            if (actionResponse instanceof SuccessResponse) continue;
            if (actionResponse instanceof APIException) {
                String message = this.extractErrorMessage((APIException)actionResponse);
                throw new ZohoException(message);
            }
            throw new ZohoException("Cannot process Zoho API Response, unknown response type: " + actionResponse);
        }
    }

    String extractErrorMessage(APIException errorResponse) {
        String message = "Exeption during updating a field in Zoho. Status: " + (String)errorResponse.getStatus().getValue() + ", code: " + (String)errorResponse.getCode().getValue() + ", message: " + (String)errorResponse.getMessage().getValue();
        return message;
    }

    public List<Record> getZcrmRecordOrganizations(int page, int pageSize, OffsetDateTime modifiedDate) throws ZohoException {
        if (page < 1 || pageSize < 1) {
            throw new ZohoException("Invalid page or pageSize index. Index must be >= 1", new IllegalArgumentException(String.format("Provided page: %s, and pageSize: %s", page, pageSize)));
        }
        try {
            RecordOperations recordOperations = new RecordOperations();
            ParameterMap paramInstance = new ParameterMap();
            paramInstance.add(RecordOperations.GetRecordsParam.PAGE, (Object)page);
            paramInstance.add(RecordOperations.GetRecordsParam.PER_PAGE, (Object)pageSize);
            HeaderMap headerInstance = new HeaderMap();
            headerInstance.add(RecordOperations.GetRecordsHeader.IF_MODIFIED_SINCE, (Object)modifiedDate);
            APIResponse response = recordOperations.getRecords("Accounts", paramInstance, headerInstance);
            return ZohoAccessClient.getZohoRecords((APIResponse<ResponseHandler>)response);
        }
        catch (SDKException e) {
            throw new ZohoException("Cannot get organization list page: " + page + " pageSize :" + pageSize, e);
        }
    }

    String createZohoCriteriaString(Map<String, String> searchCriteria, String criteriaOperator) {
        if (ZohoAccessClient.isNullOrEmpty(searchCriteria)) {
            searchCriteria = new HashMap<String, String>();
        }
        if (Objects.isNull(criteriaOperator) || !"equals".equals(criteriaOperator) && !"starts_with".equals(criteriaOperator)) {
            criteriaOperator = "equals";
        }
        String finalCriteriaOperator = criteriaOperator;
        return searchCriteria.entrySet().stream().map(entry -> Arrays.stream(((String)entry.getValue()).split(",")).map(value -> String.format("(%s:%s:%s)", entry.getKey(), finalCriteriaOperator, value.trim())).collect(Collectors.joining("OR"))).collect(Collectors.joining("OR"));
    }

    public List<DeletedRecord> getZohoDeletedRecordOrganizations(OffsetDateTime modifiedSince, int startPage, int pageSize) throws ZohoException {
        if (startPage < 1) {
            throw new ZohoException("Invalid start page index. Index must be >= 1", new IllegalArgumentException("start page: " + startPage));
        }
        try {
            RecordOperations recordOperations = new RecordOperations();
            ParameterMap paramInstance = new ParameterMap();
            paramInstance.add(RecordOperations.GetDeletedRecordsParam.TYPE, (Object)"all");
            paramInstance.add(RecordOperations.GetDeletedRecordsParam.PAGE, (Object)1);
            paramInstance.add(RecordOperations.GetDeletedRecordsParam.PER_PAGE, (Object)pageSize);
            Param scopeParam = new Param("scope", "com.zoho.crm.api.Record.GetDeletedRecordsParam");
            paramInstance.add(scopeParam, (Object)"ZohoCRM.modules.ALL");
            HeaderMap headersMap = new HeaderMap();
            if (modifiedSince != null) {
                headersMap.add(RecordOperations.GetRecordsHeader.IF_MODIFIED_SINCE, (Object)modifiedSince);
            }
            APIResponse response = recordOperations.getDeletedRecords("Accounts", paramInstance, headersMap);
            return this.getZohoDeletedRecords((APIResponse<DeletedRecordsHandler>)response);
        }
        catch (SDKException e) {
            throw new ZohoException("Cannot get deleted organization list from: " + startPage, e);
        }
    }

    private List<DeletedRecord> getZohoDeletedRecords(APIResponse<DeletedRecordsHandler> response) {
        DeletedRecordsHandler deletedRecordsHandler;
        if (response != null && response.isExpected() && (deletedRecordsHandler = (DeletedRecordsHandler)response.getObject()) instanceof DeletedRecordsWrapper) {
            DeletedRecordsWrapper deletedRecordsWrapper = (DeletedRecordsWrapper)deletedRecordsHandler;
            return deletedRecordsWrapper.getData();
        }
        return Collections.emptyList();
    }

    private static boolean isNullOrEmpty(Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    public static List<Record> getZohoRecords(APIResponse<ResponseHandler> response) throws ZohoException {
        ResponseHandler responseHandler;
        if (response == null) {
            return Collections.emptyList();
        }
        int FIRST_ERROR_CODE = 400;
        if (response.getStatusCode() >= 400) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Zoho Error. Response Status: {}, response Headers:{}", (Object)response.getStatusCode(), (Object)response.getHeaders());
            }
            throw new ZohoException("Zoho access error. Response code: " + response.getStatusCode());
        }
        if (response.isExpected() && (responseHandler = (ResponseHandler)response.getObject()) instanceof ResponseWrapper) {
            ResponseWrapper responseWrapper = (ResponseWrapper)responseHandler;
            return responseWrapper.getData();
        }
        return Collections.emptyList();
    }
}

