/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.zoho.organization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zoho.crm.api.record.Record;
import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.dereference.Dereferencer;
import eu.europeana.entitymanagement.zoho.organization.ZohoConfiguration;
import eu.europeana.entitymanagement.zoho.organization.ZohoOrganizationConverter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class ZohoDereferenceService
implements Dereferencer {
    private final ZohoConfiguration zohoConfiguration;
    private final EntityManagementConfiguration emConfig;

    @Autowired
    public ZohoDereferenceService(ZohoConfiguration zohoConfiguration, EntityManagementConfiguration emConfig) {
        this.zohoConfiguration = zohoConfiguration;
        this.emConfig = emConfig;
    }

    public Optional<Entity> dereferenceEntityById(@NonNull String id) throws Exception {
        Optional<Record> zohoOrganization = this.zohoConfiguration.getZohoAccessClient().getZohoRecordOrganizationById(id);
        if (zohoOrganization.isPresent()) {
            return Optional.of(ZohoOrganizationConverter.convertToOrganizationEntity(zohoOrganization.get(), this.zohoConfiguration.getZohoBaseUrl(), this.emConfig.getCountryMappings(), this.emConfig.getRoleMappings()));
        }
        return Optional.empty();
    }

    public String serialize(Record zohoRecord) throws JsonProcessingException {
        ObjectMapper mapper = new Jackson2ObjectMapperBuilder().defaultUseWrapper(false).dateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXX")).featuresToEnable(new Object[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY}).serializationInclusion(JsonInclude.Include.NON_NULL).build();
        mapper.findAndRegisterModules();
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)zohoRecord.getKeyValues());
    }
}

