/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.zoho.organization;

import com.zoho.crm.api.record.Record;
import com.zoho.crm.api.users.User;
import eu.europeana.entitymanagement.definitions.model.Address;
import eu.europeana.entitymanagement.definitions.model.Organization;
import eu.europeana.entitymanagement.definitions.model.WebResource;
import eu.europeana.entitymanagement.definitions.model.ZohoLabelUriMapping;
import eu.europeana.entitymanagement.utils.EntityUtils;
import eu.europeana.entitymanagement.zoho.utils.ZohoUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.NonNull;

public class ZohoOrganizationConverter {
    static final Logger logger = LogManager.getLogger(ZohoOrganizationConverter.class);
    private static final String POSITION_SEPARATOR = "_";

    public static Organization convertToOrganizationEntity(Record zohoRecord, String zohoBaseUrl, @NonNull Map<String, ZohoLabelUriMapping> countryMappings, @NonNull Map<String, String> roleMappings) {
        String edmLanguage;
        Organization org = new Organization();
        Long zohoId = zohoRecord.getId();
        org.setAbout(ZohoUtils.buildZohoOrganizationId(zohoBaseUrl, zohoRecord.getId()));
        org.setIdentifier(List.of(Long.toString(zohoId)));
        Map<String, List<String>> allLabels = ZohoOrganizationConverter.getAllRecordLabels(zohoRecord);
        Map<String, String> prefLabel = ZohoOrganizationConverter.getPrefLabel(allLabels);
        Map<String, List<String>> altLabel = ZohoOrganizationConverter.getAltLabel(allLabels);
        org.setPrefLabel(prefLabel);
        if (!altLabel.isEmpty()) {
            org.setAltLabel(altLabel);
        }
        String acronym = ZohoOrganizationConverter.getStringFieldValue(zohoRecord, "Acronym");
        String langAcronym = ZohoOrganizationConverter.getStringFieldValue(zohoRecord, "Lang_Acronym");
        org.setAcronym(ZohoUtils.createLanguageMapOfStringList(langAcronym, acronym));
        String logoFieldName = "Logo";
        org.setLogo(ZohoOrganizationConverter.buildWebResource(zohoRecord, logoFieldName));
        org.setHomepage(ZohoOrganizationConverter.getStringFieldValue(zohoRecord, "Website"));
        List<String> orgRoleLabels = ZohoUtils.stringListSupplier(zohoRecord.getKeyValue("Organisation_Role"));
        if (!orgRoleLabels.isEmpty()) {
            ArrayList<String> orgRoleIds = new ArrayList<String>();
            for (String roleLabel : orgRoleLabels) {
                if (!roleMappings.containsKey(roleLabel.toLowerCase())) continue;
                orgRoleIds.add(roleMappings.get(roleLabel.toLowerCase()));
            }
            if (!orgRoleIds.isEmpty()) {
                org.setEuropeanaRoleIds(orgRoleIds);
            }
        }
        Address address = new Address();
        address.setVcardStreetAddress(ZohoUtils.stringFieldSupplier(zohoRecord.getKeyValue("Street")));
        address.setVcardLocality(ZohoUtils.stringFieldSupplier(zohoRecord.getKeyValue("City")));
        address.setVcardPostalCode(ZohoUtils.stringFieldSupplier(zohoRecord.getKeyValue("Zip_code")));
        String zohoCountryLabel = ZohoUtils.stringFieldSupplier(zohoRecord.getKeyValue("Organisation_Country"));
        if (zohoCountryLabel != null) {
            address.setVcardCountryName(ZohoOrganizationConverter.extractCountryName(zohoCountryLabel));
            if (countryMappings.containsKey(zohoCountryLabel)) {
                ZohoLabelUriMapping zohoLabelUriMapping = countryMappings.get(zohoCountryLabel);
                org.setCountryId(zohoLabelUriMapping.getEntityUri());
                org.setCountryISO(zohoLabelUriMapping.getCountryISOCode());
            } else if (logger.isInfoEnabled()) {
                logger.info("The mapping for the zoho country label: {}, to the europeana uri does not exist.", (Object)zohoCountryLabel);
            }
        }
        org.setSameReferenceLinks(ZohoOrganizationConverter.getAllSameAs(zohoRecord));
        if (address.hasMetadataProperties()) {
            address.setAbout(org.getAbout() + "#address");
            org.setAddress(address);
        }
        if ((edmLanguage = ZohoUtils.stringFieldSupplier(zohoRecord.getKeyValue("Official_language"))) != null) {
            List<String> edmISOLanguage = Arrays.asList(ZohoUtils.toIsoLanguage(edmLanguage));
            org.setLanguage(edmISOLanguage);
        }
        ArrayList<String> hiddenLabels = new ArrayList<String>();
        String hiddenLabel1 = ZohoOrganizationConverter.getStringFieldValue(zohoRecord, "Hidden_1");
        ZohoOrganizationConverter.addValueToList(hiddenLabel1, hiddenLabels);
        String hiddenLabel2 = ZohoOrganizationConverter.getStringFieldValue(zohoRecord, "Hidden_2");
        ZohoOrganizationConverter.addValueToList(hiddenLabel2, hiddenLabels);
        String hiddenLabel3 = ZohoOrganizationConverter.getStringFieldValue(zohoRecord, "Hidden_3");
        ZohoOrganizationConverter.addValueToList(hiddenLabel3, hiddenLabels);
        String hiddenLabel4 = ZohoOrganizationConverter.getStringFieldValue(zohoRecord, "Hidden_4");
        ZohoOrganizationConverter.addValueToList(hiddenLabel4, hiddenLabels);
        hiddenLabels.addAll(ZohoOrganizationConverter.getTextAreaFieldValues(zohoRecord, "Hidden_names"));
        if (hiddenLabels.size() > 0) {
            org.setHiddenLabel(hiddenLabels);
        }
        return org;
    }

    private static String extractCountryName(String zohoCountryLabel) {
        return StringUtils.substringBeforeLast((String)zohoCountryLabel, (String)",").trim();
    }

    private static WebResource buildWebResource(Record zohoRecord, String logoFieldName) {
        String id = ZohoOrganizationConverter.getStringFieldValue(zohoRecord, logoFieldName);
        if (id == null) {
            return null;
        }
        WebResource resource = new WebResource();
        resource.setId(id);
        resource.setSource(EntityUtils.createWikimediaResourceString((String)id));
        return resource;
    }

    private static Map<String, String> getPrefLabel(Map<String, List<String>> allLabels) {
        LinkedHashMap<String, String> prefLabel = new LinkedHashMap<String, String>(allLabels.size());
        allLabels.forEach((key, value) -> prefLabel.put((String)key, (String)value.get(0)));
        return prefLabel;
    }

    private static Map<String, List<String>> getAltLabel(Map<String, List<String>> allLabels) {
        LinkedHashMap<String, List<String>> altLabel = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : allLabels.entrySet()) {
            int size = entry.getValue().size();
            if (size <= 1) continue;
            altLabel.put(entry.getKey(), entry.getValue().subList(1, size));
        }
        return altLabel;
    }

    private static Map<String, List<String>> getAllRecordLabels(Record zohoRecord) {
        LinkedHashMap<String, List<String>> allLabels = new LinkedHashMap<String, List<String>>();
        ZohoOrganizationConverter.addLabel(zohoRecord, allLabels, "Lang_Organisation_Name", "Account_Name");
        for (int i = 1; i <= 5; ++i) {
            ZohoOrganizationConverter.addLabel(zohoRecord, allLabels, "Lang_Alternative_" + i, "Alternative_" + i);
        }
        return allLabels;
    }

    static void addLabel(Record zohoRecord, Map<String, List<String>> allLabels, String langFieldName, String labelFiedName) {
        String isoLanguage = ZohoOrganizationConverter.getIsoLanguage(zohoRecord, langFieldName);
        String label = ZohoOrganizationConverter.getStringFieldValue(zohoRecord, labelFiedName);
        if (label != null) {
            ZohoOrganizationConverter.addLabel(allLabels, isoLanguage, label);
        }
    }

    public static String getStringFieldValue(Record zohoRecord, String zohoFieldName) {
        return ZohoUtils.stringFieldSupplier(zohoRecord.getKeyValue(zohoFieldName));
    }

    public static String getEuropeanaIdFieldValue(Record zohoRecord) {
        return ZohoOrganizationConverter.getStringFieldValue(zohoRecord, "Europeana_org_ID");
    }

    static List<String> getTextAreaFieldValues(Record zohoRecord, String zohoFieldName) {
        String textArea = ZohoUtils.stringFieldSupplier(zohoRecord.getKeyValue(zohoFieldName));
        if (StringUtils.isBlank((CharSequence)textArea)) {
            return Collections.emptyList();
        }
        return List.of(textArea.split("\\r?\\n|\\r"));
    }

    static String getIsoLanguage(Record zohoRecord, String zohoLangFieldName) {
        return ZohoUtils.toIsoLanguage(ZohoOrganizationConverter.getStringFieldValue(zohoRecord, zohoLangFieldName));
    }

    static void addValueToList(String value, List<String> list) {
        if (value != null) {
            list.add(value);
        }
    }

    static void addLabel(Map<String, List<String>> allLabels, String isoLanguage, String label) {
        allLabels.computeIfAbsent(isoLanguage, k -> new ArrayList());
        allLabels.get(isoLanguage).add(label);
    }

    private static List<String> getAllSameAs(Record zohoRecord) {
        ArrayList<String> sameAsList = new ArrayList<String>();
        for (int i = 1; i <= 5; ++i) {
            String sameAs = ZohoOrganizationConverter.getStringFieldValue(zohoRecord, "SameAs_" + i);
            if (sameAs == null) continue;
            sameAsList.add(sameAs);
        }
        return sameAsList;
    }

    public static String getOwnerName(Record recordOrganization) {
        return ((User)recordOrganization.getKeyValue("Owner")).getName();
    }

    public static String getModifiedByName(Record recordOrganization) {
        return ((User)recordOrganization.getKeyValue("Modified_By")).getName();
    }

    public static boolean isMarkedForDeletion(Record recordOrganization) {
        Object scheduledDeletion = recordOrganization.getKeyValue("Scheduled_for_deletion");
        if (scheduledDeletion == null) {
            return false;
        }
        return (Boolean)scheduledDeletion;
    }
}

