/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.zoho.utils;

import com.zoho.crm.api.util.Choice;
import eu.europeana.entitymanagement.definitions.model.WebResource;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public final class ZohoUtils {
    public static String stringFieldSupplier(Object object) {
        if (!JSONObject.NULL.equals(object)) {
            if (object instanceof Choice) {
                return ((Choice)object).getValue().toString();
            }
            return object.toString();
        }
        return null;
    }

    public static String buildZohoOrganizationId(Long zohoId) {
        return "https://crm.zoho.com/crm/org51823723/tab/Accounts/" + zohoId;
    }

    public static List<String> stringListSupplier(Object object) {
        if (!JSONObject.NULL.equals(object) && object instanceof List && CollectionUtils.isNotEmpty((Collection)((List)object)) && ((List)object).get(0) instanceof Choice) {
            return ((List)object).stream().map(Choice::getValue).map(String.class::cast).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static Map<String, List<String>> createMapWithLists(String key, String value) {
        return value == null ? null : Collections.singletonMap(key, Collections.singletonList(value));
    }

    public static Map<String, String> createMap(String key, String value) {
        return value == null ? null : Collections.singletonMap(key, value);
    }

    public static List<String> createList(String value) {
        return value == null ? null : Collections.singletonList(value);
    }

    public static String[] createStringArrayFromPartList(List<? extends WebResource> resources) {
        return resources == null ? null : (String[])resources.stream().map(WebResource::getId).toArray(String[]::new);
    }

    public static Map<String, List<String>> createLanguageMapOfStringList(String language, String value) {
        return value == null ? null : Collections.singletonMap(ZohoUtils.toIsoLanguage(language), ZohoUtils.createList(value));
    }

    public static Map<String, List<String>> createLanguageMapOfStringList(String language, List<String> value) {
        return value == null ? null : Collections.singletonMap(ZohoUtils.toIsoLanguage(language), value);
    }

    public static String toIsoLanguage(String language) {
        return StringUtils.isBlank((CharSequence)language) ? "def" : language.substring(0, 2).toLowerCase(Locale.US);
    }

    public static Map<String, List<String>> mergeMapsWithLists(Map<String, List<String>> baseMap, Map<String, List<String>> addMap) {
        if (baseMap == null && addMap == null) {
            return null;
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (baseMap != null) {
            result.putAll(baseMap);
        }
        if (addMap != null) {
            for (Map.Entry<String, List<String>> entry : addMap.entrySet()) {
                result.merge(entry.getKey(), new ArrayList(entry.getValue()), ZohoUtils::mergeStringLists);
            }
        }
        return result.isEmpty() ? null : result;
    }

    public static Map<String, List<String>> mergeMapsWithSingletonLists(Map<String, List<String>> baseMap, Map<String, List<String>> addMap, Map<String, List<String>> notMergedMap) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(baseMap);
        for (Map.Entry<String, List<String>> entry : addMap.entrySet()) {
            String key = entry.getKey();
            if (result.containsKey(key)) {
                List unmergedValues = entry.getValue().stream().distinct().filter(value -> !((List)result.get(key)).contains(value)).collect(Collectors.toList());
                if (unmergedValues.isEmpty()) continue;
                notMergedMap.merge(key, unmergedValues, ZohoUtils::mergeStringLists);
                continue;
            }
            result.put(key, new ArrayList(entry.getValue()));
        }
        return result;
    }

    public static List<String> mergeStringLists(List<String> baseList, List<String> addList) {
        HashSet<String> result = new HashSet<String>();
        if (baseList != null) {
            result.addAll(baseList);
        }
        if (addList != null) {
            result.addAll(addList);
        }
        return result.isEmpty() ? null : new ArrayList(result);
    }

    public static Map<String, List<String>> createMapWithLists(List<String> keys, List<String> values) {
        if (keys != null && !keys.isEmpty()) {
            HashMap<String, List<String>> resMap = new HashMap<String, List<String>>(keys.size());
            for (int i = 0; i < keys.size(); ++i) {
                resMap.put(ZohoUtils.toIsoLanguage(keys.get(i)), ZohoUtils.createList(values.get(i)));
            }
            return resMap;
        }
        return null;
    }

    public static String[] mergeStringArrays(String[] base, String[] add) {
        List<String> baseList = base == null ? Collections.emptyList() : Arrays.asList(base);
        List<String> addList = add == null ? Collections.emptyList() : Arrays.asList(add);
        List<String> mergedList = ZohoUtils.mergeStringLists(baseList, addList);
        return mergedList == null ? null : mergedList.toArray(new String[0]);
    }

    public static String getZohoId(String id) {
        if (!id.contains("/")) {
            return id;
        }
        String[] uriParts = id.split("/");
        return uriParts[uriParts.length - 1];
    }

    public static boolean isZohoOrganization(String id, String entityType) {
        return EntityTypes.Organization.getEntityType().equals(entityType) && id.contains("crm.zoho.com");
    }
}

