/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.zoho.organization;

import com.zoho.crm.api.record.Record;
import com.zoho.crm.api.users.User;
import eu.europeana.entitymanagement.definitions.model.Address;
import eu.europeana.entitymanagement.definitions.model.Organization;
import eu.europeana.entitymanagement.definitions.model.WebResource;
import eu.europeana.entitymanagement.utils.EntityUtils;
import eu.europeana.entitymanagement.zoho.utils.ZohoUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ZohoOrganizationConverter {
    private static final String POSITION_SEPARATOR = "_";

    private ZohoOrganizationConverter() {
    }

    public static Organization convertToOrganizationEntity(Record zohoRecord) {
        List<String> industry;
        List<String> edmLanguage;
        Organization org = new Organization();
        Long zohoId = zohoRecord.getId();
        org.setAbout(ZohoUtils.buildZohoOrganizationId(zohoRecord.getId()));
        org.setIdentifier(List.of(Long.toString(zohoId)));
        Map<String, List<String>> allLabels = ZohoOrganizationConverter.getAllRecordLabels(zohoRecord);
        Map<String, String> prefLabel = ZohoOrganizationConverter.getPrefLabel(allLabels);
        Map<String, List<String>> altLabel = ZohoOrganizationConverter.getAltLabel(allLabels);
        org.setPrefLabel(prefLabel);
        if (!altLabel.isEmpty()) {
            org.setAltLabel(altLabel);
        }
        String acronym = ZohoOrganizationConverter.getStringFieldValue(zohoRecord, "Acronym");
        String langAcronym = ZohoOrganizationConverter.getStringFieldValue(zohoRecord, "Lang_Acronym");
        org.setAcronym(ZohoUtils.createLanguageMapOfStringList(langAcronym, acronym));
        String logoFieldName = "Logo_link_to_WikimediaCommons";
        org.setLogo(ZohoOrganizationConverter.buildWebResource(zohoRecord, logoFieldName));
        org.setHomepage(ZohoOrganizationConverter.getStringFieldValue(zohoRecord, "Website"));
        List<String> organizationRoleStringList = ZohoUtils.stringListSupplier(zohoRecord.getKeyValue("Organisation_Role2"));
        if (!organizationRoleStringList.isEmpty()) {
            org.setEuropeanaRole(ZohoUtils.createLanguageMapOfStringList(Locale.ENGLISH.getLanguage(), organizationRoleStringList));
        }
        org.setOrganizationDomain(ZohoUtils.createMapWithLists(Locale.ENGLISH.getLanguage(), ZohoUtils.stringFieldSupplier(zohoRecord.getKeyValue("Domain2"))));
        List<String> geographicLevel = ZohoUtils.stringListSupplier(zohoRecord.getKeyValue("Geographic_Level"));
        if (!geographicLevel.isEmpty()) {
            org.setGeographicLevel(ZohoUtils.createMap(Locale.ENGLISH.getLanguage(), geographicLevel.get(0)));
        }
        String organizationCountry = ZohoOrganizationConverter.toEdmCountry(ZohoOrganizationConverter.getStringFieldValue(zohoRecord, "Country1"));
        org.setCountry(organizationCountry);
        org.setSameReferenceLinks(ZohoOrganizationConverter.getAllSameAs(zohoRecord));
        Address address = new Address();
        address.setVcardStreetAddress(ZohoUtils.stringFieldSupplier(zohoRecord.getKeyValue("Street")));
        address.setVcardLocality(ZohoUtils.stringFieldSupplier(zohoRecord.getKeyValue("City")));
        address.setVcardCountryName(ZohoUtils.stringFieldSupplier(zohoRecord.getKeyValue("Country")));
        address.setVcardPostalCode(ZohoUtils.stringFieldSupplier(zohoRecord.getKeyValue("ZIP_code")));
        address.setVcardPostOfficeBox(ZohoUtils.stringFieldSupplier(zohoRecord.getKeyValue("PO_box")));
        String lat = ZohoUtils.stringFieldSupplier(zohoRecord.getKeyValue("Latitude"));
        String lon = ZohoUtils.stringFieldSupplier(zohoRecord.getKeyValue("Longitude"));
        if (lat != null && lon != null) {
            address.setVcardHasGeo(EntityUtils.toGeoUri((String)lat, (String)lon));
        }
        if (address.hasMetadataProperties()) {
            address.setAbout(org.getAbout() + "#address");
            org.setAddress(address);
        }
        if (!(edmLanguage = ZohoUtils.stringListSupplier(zohoRecord.getKeyValue("Official_Language"))).isEmpty()) {
            List edmISOLanguage = edmLanguage.stream().map(ZohoUtils::toIsoLanguage).collect(Collectors.toList());
            org.setLanguage(edmISOLanguage);
        }
        ArrayList<String> hiddenLabels = new ArrayList<String>();
        String hiddenLabel1 = ZohoOrganizationConverter.getStringFieldValue(zohoRecord, "Hidden_1");
        ZohoOrganizationConverter.addValueToList(hiddenLabel1, hiddenLabels);
        String hiddenLabel2 = ZohoOrganizationConverter.getStringFieldValue(zohoRecord, "Hidden_2");
        ZohoOrganizationConverter.addValueToList(hiddenLabel2, hiddenLabels);
        String hiddenLabel3 = ZohoOrganizationConverter.getStringFieldValue(zohoRecord, "Hidden_3");
        ZohoOrganizationConverter.addValueToList(hiddenLabel3, hiddenLabels);
        String hiddenLabel4 = ZohoOrganizationConverter.getStringFieldValue(zohoRecord, "Hidden_4");
        ZohoOrganizationConverter.addValueToList(hiddenLabel4, hiddenLabels);
        hiddenLabels.addAll(ZohoOrganizationConverter.getTextAreaFieldValues(zohoRecord, "Hidden"));
        if (hiddenLabels.size() > 0) {
            org.setHiddenLabel(hiddenLabels);
        }
        if (!(industry = ZohoUtils.stringListSupplier(zohoRecord.getKeyValue("Industry_2"))).isEmpty()) {
            HashMap<String, List<String>> orgDomain = new HashMap<String, List<String>>();
            orgDomain.put("en", industry);
            org.setOrganizationDomain(orgDomain);
        }
        return org;
    }

    private static WebResource buildWebResource(Record zohoRecord, String logoFieldName) {
        String id = ZohoOrganizationConverter.getStringFieldValue(zohoRecord, logoFieldName);
        if (id == null) {
            return null;
        }
        WebResource resource = new WebResource();
        resource.setId(id);
        resource.setSource(EntityUtils.createWikimediaResourceString((String)id));
        return resource;
    }

    private static Map<String, String> getPrefLabel(Map<String, List<String>> allLabels) {
        LinkedHashMap<String, String> prefLabel = new LinkedHashMap<String, String>(allLabels.size());
        allLabels.forEach((key, value) -> prefLabel.put((String)key, (String)value.get(0)));
        return prefLabel;
    }

    private static Map<String, List<String>> getAltLabel(Map<String, List<String>> allLabels) {
        LinkedHashMap<String, List<String>> altLabel = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : allLabels.entrySet()) {
            int size = entry.getValue().size();
            if (size <= 1) continue;
            altLabel.put(entry.getKey(), entry.getValue().subList(1, size));
        }
        return altLabel;
    }

    private static Map<String, List<String>> getAllRecordLabels(Record zohoRecord) {
        LinkedHashMap<String, List<String>> allLabels = new LinkedHashMap<String, List<String>>();
        ZohoOrganizationConverter.addLabel(zohoRecord, allLabels, "Lang_Organisation_Name", "Account_Name");
        for (int i = 1; i <= 5; ++i) {
            ZohoOrganizationConverter.addLabel(zohoRecord, allLabels, "Lang_Alternative_" + i, "Alternative_" + i);
        }
        return allLabels;
    }

    static void addLabel(Record zohoRecord, Map<String, List<String>> allLabels, String langFieldName, String labelFiedName) {
        String isoLanguage = ZohoOrganizationConverter.getIsoLanguage(zohoRecord, langFieldName);
        String label = ZohoOrganizationConverter.getStringFieldValue(zohoRecord, labelFiedName);
        if (label != null) {
            ZohoOrganizationConverter.addLabel(allLabels, isoLanguage, label);
        }
    }

    static String getStringFieldValue(Record zohoRecord, String zohoFieldName) {
        return ZohoUtils.stringFieldSupplier(zohoRecord.getKeyValue(zohoFieldName));
    }

    static List<String> getTextAreaFieldValues(Record zohoRecord, String zohoFieldName) {
        String textArea = ZohoUtils.stringFieldSupplier(zohoRecord.getKeyValue(zohoFieldName));
        if (StringUtils.isBlank((CharSequence)textArea)) {
            return Collections.emptyList();
        }
        return List.of(StringUtils.split((String)textArea, (String)"\n"));
    }

    static String getIsoLanguage(Record zohoRecord, String zohoLangFieldName) {
        return ZohoUtils.toIsoLanguage(ZohoOrganizationConverter.getStringFieldValue(zohoRecord, zohoLangFieldName));
    }

    static void addValueToList(String value, List<String> list) {
        if (value != null) {
            list.add(value);
        }
    }

    static void addLabel(Map<String, List<String>> allLabels, String isoLanguage, String label) {
        allLabels.computeIfAbsent(isoLanguage, k -> new ArrayList());
        allLabels.get(isoLanguage).add(label);
    }

    private static List<String> getAllSameAs(Record zohoRecord) {
        ArrayList<String> sameAsList = new ArrayList<String>();
        for (int i = 1; i <= 3; ++i) {
            String sameAs = ZohoOrganizationConverter.getStringFieldValue(zohoRecord, "SameAs_" + i);
            if (sameAs == null) continue;
            sameAsList.add(sameAs);
        }
        return sameAsList;
    }

    private static String toEdmCountry(String organizationCountry) {
        if (StringUtils.isBlank((CharSequence)organizationCountry)) {
            return null;
        }
        String isoCode = null;
        int commaSeparatorPos = organizationCountry.indexOf(44);
        int bracketSeparatorPos = organizationCountry.indexOf(40);
        if (commaSeparatorPos > 0) {
            isoCode = organizationCountry.substring(commaSeparatorPos + 1).trim();
        } else if (bracketSeparatorPos > 0) {
            isoCode = organizationCountry.substring(0, bracketSeparatorPos).trim();
        }
        return isoCode;
    }

    public static String getOwnerName(Record recordOrganization) {
        return ((User)recordOrganization.getKeyValue("Owner")).getName();
    }

    public static boolean isMarkedForDeletion(Record recordOrganization) {
        Object scheduledDeletion = recordOrganization.getKeyValue("Scheduled_for_deletion");
        if (scheduledDeletion == null) {
            return false;
        }
        return (Boolean)scheduledDeletion;
    }
}

