/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.zoho.organization;

import com.zoho.crm.api.record.Record;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.dereference.Dereferencer;
import eu.europeana.entitymanagement.zoho.organization.ZohoAccessConfiguration;
import eu.europeana.entitymanagement.zoho.organization.ZohoOrganizationConverter;
import java.util.Optional;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class ZohoDereferenceService
implements Dereferencer {
    private final ZohoAccessConfiguration zohoAccessConfiguration;

    public ZohoDereferenceService(ZohoAccessConfiguration zohoAccessConfiguration) {
        this.zohoAccessConfiguration = zohoAccessConfiguration;
    }

    public Optional<Entity> dereferenceEntityById(@NonNull String id) throws Exception {
        Optional<Record> zohoOrganization = this.zohoAccessConfiguration.getZohoAccessClient().getZohoRecordOrganizationById(id);
        return zohoOrganization.map(ZohoOrganizationConverter::convertToOrganizationEntity);
    }
}

