/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.zoho.organization;

import eu.europeana.entitymanagement.zoho.ZohoAccessClient;
import eu.europeana.entitymanagement.zoho.utils.ZohoException;
import eu.europeana.entitymanagement.zoho.utils.ZohoInMemoryTokenStore;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration(value="zohoAccessConfiguration")
@PropertySource(value={"classpath:zoho_import.properties"}, ignoreResourceNotFound=true)
public class ZohoAccessConfiguration {
    @Value(value="${zoho.email:#{null}}")
    private String zohoEmail;
    @Value(value="${zoho.client.id:#{null}}")
    private String zohoClientId;
    @Value(value="${zoho.client.secret:#{null}}")
    private String zohoClientSecret;
    @Value(value="${zoho.refresh.token:#{null}}")
    private String zohoRefreshToken;
    @Value(value="${zoho.redirect.url:#{null}}")
    private String zohoRedirectUrl;
    private volatile ZohoAccessClient zohoAccessClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZohoAccessClient getZohoAccessClient() throws ZohoException {
        if (this.zohoAccessClient == null) {
            ZohoAccessConfiguration zohoAccessConfiguration = this;
            synchronized (zohoAccessConfiguration) {
                if (this.zohoAccessClient == null) {
                    this.zohoAccessClient = new ZohoAccessClient(new ZohoInMemoryTokenStore(), this.zohoEmail, this.zohoClientId, this.zohoClientSecret, this.zohoRefreshToken, this.zohoRedirectUrl);
                }
            }
        }
        return this.zohoAccessClient;
    }
}

