/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.wikidata;

import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.definitions.exceptions.EntityModelCreationException;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.dereference.Dereferencer;
import eu.europeana.entitymanagement.utils.EntityRecordUtils;
import eu.europeana.entitymanagement.web.xml.model.WikidataOrganization;
import eu.europeana.entitymanagement.zoho.utils.WikidataAccessException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class WikidataDereferenceService
implements Dereferencer,
InitializingBean {
    private static final Logger logger = LogManager.getLogger(WikidataDereferenceService.class);
    private final JAXBContext jaxbContext;
    private final String wikidataBaseUrl;
    private ThreadLocal<Unmarshaller> unmarshaller;
    private ThreadLocal<Transformer> transformer;

    @Autowired
    public WikidataDereferenceService(JAXBContext jaxbContext, EntityManagementConfiguration entityManagementConfiguration) {
        this.jaxbContext = jaxbContext;
        this.wikidataBaseUrl = entityManagementConfiguration.getWikidataBaseUrl();
    }

    private void setupJaxb() {
        this.unmarshaller = ThreadLocal.withInitial(() -> {
            try {
                return this.jaxbContext.createUnmarshaller();
            }
            catch (JAXBException e) {
                throw new RuntimeException("Error creating JAXB unmarshaller ", e);
            }
        });
    }

    public void afterPropertiesSet() {
        this.setupJaxb();
        this.setupXsltTransformer();
    }

    private void setupXsltTransformer() {
        TransformerFactoryImpl transformerFactory = new TransformerFactoryImpl();
        this.transformer = ThreadLocal.withInitial(() -> WikidataDereferenceService.lambda$setupXsltTransformer$1((TransformerFactory)transformerFactory));
    }

    public Optional<Entity> dereferenceEntityById(String wikidataUri) throws WikidataAccessException, EntityModelCreationException {
        StringBuilder wikidataXml = null;
        WikidataOrganization wikidataOrganization = null;
        try {
            wikidataXml = this.getEntity(wikidataUri);
            wikidataOrganization = this.parse(wikidataXml.toString());
        }
        catch (JAXBException e) {
            logger.debug("Cannot parse wikidata response: {}", (Object)wikidataXml);
            throw new WikidataAccessException("Cannot parse wikidata xml response for uri: " + wikidataUri, e);
        }
        if (wikidataOrganization == null) {
            return Optional.empty();
        }
        return Optional.of(wikidataOrganization.getOrganization().toEntityModel());
    }

    private StringBuilder getEntity(String uri) throws WikidataAccessException {
        StringBuilder res = new StringBuilder();
        StreamResult wikidataRes = new StreamResult((Writer)new StringBuilderWriter(res));
        String entityResponse = this.getEntityFromURL(uri);
        if (StringUtils.hasLength((String)entityResponse)) {
            try (ByteArrayInputStream stream = new ByteArrayInputStream(entityResponse.getBytes(StandardCharsets.UTF_8));){
                this.transformer.get().setParameter("targetId", uri);
                this.transformer.get().transform(new StreamSource(stream), wikidataRes);
            }
            catch (IOException | TransformerException e) {
                throw new WikidataAccessException("Error transforming Wikidata response", e);
            }
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getEntityFromURL(String urlToRead) throws WikidataAccessException {
        if (StringUtils.hasLength((String)this.wikidataBaseUrl)) {
            urlToRead = this.wikidataBaseUrl + "/entity/" + EntityRecordUtils.getIdFromUrl((String)urlToRead);
        }
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet request = new HttpGet((String)urlToRead);
            request.addHeader("Accept", "application/xml");
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
                if (response.getStatusLine().getStatusCode() != 200) {
                    String string = null;
                    return string;
                }
                HttpEntity entity = response.getEntity();
                if (entity == null) return null;
                String string = EntityUtils.toString((HttpEntity)entity);
                return string;
            }
        }
        catch (IOException e) {
            throw new WikidataAccessException("Error executing the request for uri " + (String)urlToRead, e);
        }
    }

    private WikidataOrganization parse(String xml) throws JAXBException {
        ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        return (WikidataOrganization)this.unmarshaller.get().unmarshal((InputStream)stream);
    }

    private static /* synthetic */ Transformer lambda$setupXsltTransformer$1(TransformerFactory transformerFactory) {
        try {
            InputStream transformerXSL = WikidataDereferenceService.class.getResourceAsStream("/wkd2org.xsl");
            Transformer newTransformer = transformerFactory.newTransformer(new StreamSource(transformerXSL));
            newTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            newTransformer.setParameter("deref", Boolean.TRUE);
            newTransformer.setParameter("address", Boolean.TRUE);
            return newTransformer;
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Error creating XML transformer ", e);
        }
    }
}

