/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web;

import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.definitions.model.ConceptScheme;
import eu.europeana.entitymanagement.exception.EntityNotFoundException;
import eu.europeana.entitymanagement.vocabulary.FormatTypes;
import eu.europeana.entitymanagement.web.BaseRest;
import eu.europeana.entitymanagement.web.service.ConceptSchemeService;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@ConditionalOnWebApplication
public class ConceptSchemeController
extends BaseRest {
    private final ConceptSchemeService emConceptSchemeService;
    public static final String INVALID_UPDATE_REQUEST_MSG = "Request must either specify a 'query' param or contain entity identifiers in body";

    @Autowired
    public ConceptSchemeController(ConceptSchemeService emConceptSchemeService, EntityManagementConfiguration emConfig) {
        this.emConceptSchemeService = emConceptSchemeService;
        this.emConfig = emConfig;
    }

    @ApiOperation(value="Disable a concept scheme", nickname="disableConceptScheme", response=Void.class)
    @RequestMapping(value={"/scheme/{identifier}"}, method={RequestMethod.DELETE}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> disableConceptScheme(@RequestHeader(value="If-Match", required=false) String ifMatchHeader, @PathVariable(value="identifier") String identifier, HttpServletRequest request) throws HttpException, EuropeanaApiException {
        this.verifyWriteAccess("delete", request);
        long numericIdentifier = this.parseNumericIdentifier(identifier);
        ConceptScheme scheme = this.emConceptSchemeService.retrieveConceptScheme(numericIdentifier);
        String etag = this.generateETag(scheme.getModified(), "jsonld", this.getApiVersion());
        this.checkIfMatchHeader(etag, request);
        this.emConceptSchemeService.disableConceptScheme(scheme, true);
        return this.noContentResponse(request);
    }

    long parseNumericIdentifier(String identifier) throws EntityNotFoundException {
        try {
            return Long.parseLong(identifier);
        }
        catch (NumberFormatException e) {
            throw new EntityNotFoundException("No concept scheme found for the given identifier: ", identifier, e);
        }
    }

    @ApiOperation(value="Create an entity grouping/scheme", nickname="createScheme", response=Void.class)
    @PostMapping(value={"/scheme/"}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> createScheme(@RequestParam(value="profile", required=false, defaultValue="minimal") String profile, @RequestBody ConceptScheme conceptScheme, HttpServletRequest request) throws Exception {
        this.verifyWriteAccess("create", request);
        this.emConceptSchemeService.createConceptScheme(conceptScheme);
        return this.generateResponse(request, conceptScheme, HttpStatus.CREATED);
    }

    @ApiOperation(value="Retrieve an entity grouping/scheme", nickname="getConceptSchemeJsonLd", response=Void.class)
    @GetMapping(value={"/scheme/{identifier}.json", "/scheme/{identifier}.jsonld", "/scheme/{identifier}"}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> getConceptSchemeJsonLd(@RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="profile", required=false, defaultValue="minimal") String profile, @PathVariable(value="identifier") String identifier, HttpServletRequest request) throws EuropeanaApiException, HttpException {
        this.verifyReadAccess(request);
        long numericIdentifier = this.parseNumericIdentifier(identifier);
        ConceptScheme scheme = this.emConceptSchemeService.retrieveConceptScheme(numericIdentifier, false);
        return this.generateResponse(request, scheme, HttpStatus.OK);
    }

    @ApiOperation(value="Update concept scheme", nickname="updateConceptScheme", response=Void.class)
    @PutMapping(value={"/scheme/{identifier}"}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> updateConceptScheme(@RequestHeader(value="If-Match", required=false) String ifMatchHeader, @RequestParam(value="profile", required=false, defaultValue="minimal") String profile, @PathVariable(value="identifier") String identifier, @RequestBody ConceptScheme newConceptScheme, HttpServletRequest request) throws Exception {
        this.verifyWriteAccess("update", request);
        long numericIdentifier = this.parseNumericIdentifier(identifier);
        ConceptScheme existingScheme = this.emConceptSchemeService.retrieveConceptScheme(numericIdentifier, false);
        String etag = this.generateETag(existingScheme.getModified(), FormatTypes.jsonld.name(), this.getApiVersion());
        this.checkIfMatchHeader(etag, request);
        existingScheme.setDefinition(new HashMap(newConceptScheme.getDefinition()));
        existingScheme.setPrefLabel(new HashMap(newConceptScheme.getPrefLabel()));
        existingScheme.setModified(new Date());
        this.emConceptSchemeService.storeConceptScheme(existingScheme);
        return this.generateResponse(request, existingScheme, HttpStatus.OK);
    }

    protected ResponseEntity<String> generateResponse(HttpServletRequest request, ConceptScheme scheme, HttpStatus status) throws EuropeanaApiException {
        HttpHeaders headers = this.generateHeaders(scheme, request);
        try {
            String body = this.jsonLdSerializer.serializeObject(scheme);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)status).headers(headers)).body((Object)body);
        }
        catch (IOException e) {
            throw new EuropeanaApiException("Error serializing concept scheme.", (Throwable)e);
        }
    }

    HttpHeaders generateHeaders(ConceptScheme scheme, HttpServletRequest request) {
        String etag = this.generateETag(scheme.getModified(), "jsonld", this.getApiVersion());
        HttpHeaders headers = this.createAllowHeader(request);
        headers.add("Link", "<http://www.w3.org/ns/ldp#Resource>; rel=\"type\"");
        headers.add("ETag", etag);
        headers.add("Content-Type", "application/ld+json;charset=utf-8");
        if (RequestMethod.POST.toString().equals(request.getMethod())) {
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        }
        return headers;
    }
}

