/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.config;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import eu.europeana.entitymanagement.common.config.DataSource;
import eu.europeana.entitymanagement.exception.HttpBadRequestException;
import eu.europeana.entitymanagement.exception.HttpUnprocessableException;
import java.util.List;
import java.util.Optional;

@JacksonXmlRootElement(localName="config")
public class DataSources {
    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="source")
    private List<DataSource> datasources;

    public List<DataSource> getDatasources() {
        return this.datasources;
    }

    public boolean hasDataSource(String url) {
        return this.datasources.stream().anyMatch(s -> url.contains(s.getUrl()));
    }

    public Optional<DataSource> getDatasource(String url) {
        return this.datasources.stream().filter(s -> url.contains(s.getUrl())).findFirst();
    }

    public Optional<DataSource> getEuropeanaDatasource() {
        return this.getDatasourceById("europeana");
    }

    public Optional<DataSource> getDatasourceById(String dataSourceId) {
        return this.datasources.stream().filter(s -> s.getId().equals(dataSourceId)).findFirst();
    }

    public DataSource verifyDataSource(String creationRequestId, boolean allowStatic) throws HttpBadRequestException, HttpUnprocessableException {
        Optional<DataSource> dataSource = this.getDatasource(creationRequestId);
        if (dataSource.isEmpty()) {
            throw new HttpBadRequestException(String.format("id %s does not match a configured datasource", creationRequestId));
        }
        if (!allowStatic && dataSource.get().isStatic()) {
            throw new HttpUnprocessableException(String.format("Entity registration not permitted. id %s matches a static datasource.", creationRequestId));
        }
        return dataSource.get();
    }
}

