/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.writer;

import eu.europeana.entitymanagement.definitions.batch.model.BatchEntityRecord;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.solr.SolrEntityUtils;
import eu.europeana.entitymanagement.solr.service.SolrService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@Component
public class EntitySolrInsertionWriter
implements ItemWriter<BatchEntityRecord> {
    private final SolrService solrService;

    public EntitySolrInsertionWriter(SolrService solrService) {
        this.solrService = solrService;
    }

    public void write(List<? extends BatchEntityRecord> entityRecords) throws Exception {
        List solrEntities = entityRecords.stream().filter(record -> !record.getEntityRecord().isDisabled()).map(entityRecord -> SolrEntityUtils.createSolrEntity((EntityRecord)entityRecord.getEntityRecord())).collect(Collectors.toList());
        if (!solrEntities.isEmpty()) {
            this.solrService.storeMultipleEntities(solrEntities);
        }
    }
}

