/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.processor;

import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.entitymanagement.batch.processor.BaseEntityProcessor;
import eu.europeana.entitymanagement.common.config.DataSource;
import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.config.DataSources;
import eu.europeana.entitymanagement.definitions.batch.model.BatchEntityRecord;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledUpdateType;
import eu.europeana.entitymanagement.definitions.exceptions.EntityModelCreationException;
import eu.europeana.entitymanagement.definitions.model.Aggregation;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.EntityProxy;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.definitions.model.WebResource;
import eu.europeana.entitymanagement.exception.ingestion.EntityValidationException;
import eu.europeana.entitymanagement.normalization.EntityFieldsCleaner;
import eu.europeana.entitymanagement.normalization.EntityFieldsCompleteValidationGroup;
import eu.europeana.entitymanagement.normalization.EntityFieldsDataSourceProxyValidationGroup;
import eu.europeana.entitymanagement.utils.EntityObjectFactory;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import eu.europeana.entitymanagement.web.service.DepictionGeneratorService;
import eu.europeana.entitymanagement.web.service.EntityRecordService;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ValidatorFactory;
import org.springframework.stereotype.Component;

@Component
public class EntityConsolidationProcessor
extends BaseEntityProcessor {
    private final EntityRecordService entityRecordService;
    private final ValidatorFactory emValidatorFactory;
    private final EntityFieldsCleaner emEntityFieldCleaner;
    private final DataSources datasources;
    private final DepictionGeneratorService depictionGeneratorService;

    public EntityConsolidationProcessor(EntityRecordService entityRecordService, ValidatorFactory emValidatorFactory, EntityFieldsCleaner emEntityFieldCleaner, DataSources datasources, EntityManagementConfiguration emConfiguration, DepictionGeneratorService depictionGeneratorService) {
        super(new ScheduledTaskType[]{ScheduledUpdateType.FULL_UPDATE});
        this.entityRecordService = entityRecordService;
        this.emValidatorFactory = emValidatorFactory;
        this.emEntityFieldCleaner = emEntityFieldCleaner;
        this.datasources = datasources;
        this.depictionGeneratorService = depictionGeneratorService;
    }

    @Override
    public BatchEntityRecord doProcessing(BatchEntityRecord batchEntityRecord) throws EuropeanaApiException, EntityModelCreationException {
        WebResource isShownBy;
        boolean isStaticDataSource;
        EntityRecord entityRecord = batchEntityRecord.getEntityRecord();
        List externalProxies = entityRecord.getExternalProxies();
        EntityProxy primaryExternalProxy = (EntityProxy)externalProxies.get(0);
        Entity externalProxyEntity = primaryExternalProxy.getEntity();
        String proxyId = primaryExternalProxy.getProxyId();
        Optional<DataSource> dataSource = this.datasources.getDatasource(proxyId);
        boolean bl = isStaticDataSource = dataSource.isPresent() && dataSource.get().isStatic();
        if (!isStaticDataSource) {
            this.validateDataSourceProxyConstraints(externalProxyEntity);
        }
        if (externalProxies.size() > 1) {
            for (int i = 1; i < externalProxies.size(); ++i) {
                EntityProxy secondaryExternalProxy = (EntityProxy)externalProxies.get(i);
                Entity secondaryProxyEntity = secondaryExternalProxy.getEntity();
                this.validateDataSourceProxyConstraints(secondaryProxyEntity);
                externalProxyEntity = this.entityRecordService.mergeEntities(externalProxyEntity, secondaryProxyEntity);
            }
        }
        Entity europeanaProxyEntity = entityRecord.getEuropeanaProxy().getEntity();
        Entity consolidatedEntity = null;
        consolidatedEntity = isStaticDataSource ? EntityObjectFactory.createConsolidatedEntityObject((Entity)europeanaProxyEntity) : this.entityRecordService.mergeEntities(europeanaProxyEntity, externalProxyEntity);
        this.entityRecordService.processReferenceFields(consolidatedEntity);
        this.entityRecordService.addSameReferenceLinks(consolidatedEntity, externalProxies.stream().map(EntityProxy::getProxyId).collect(Collectors.toList()));
        this.emEntityFieldCleaner.cleanAndNormalize(consolidatedEntity);
        this.entityRecordService.performReferentialIntegrity(consolidatedEntity);
        if (this.hasToGenerateDepiction(consolidatedEntity) && (isShownBy = this.depictionGeneratorService.generateIsShownBy(consolidatedEntity.getEntityId())) != null) {
            consolidatedEntity.setIsShownBy(isShownBy);
        }
        this.validateCompleteValidationConstraints(consolidatedEntity);
        this.copyIsAggregatedBy(entityRecord, consolidatedEntity);
        this.entityRecordService.updateConsolidatedVersion(entityRecord, consolidatedEntity);
        return batchEntityRecord;
    }

    void copyIsAggregatedBy(EntityRecord entityRecord, Entity consolidatedEntity) {
        consolidatedEntity.setIsAggregatedBy(new Aggregation(entityRecord.getEntity().getIsAggregatedBy()));
    }

    boolean hasToGenerateDepiction(Entity consolidatedEntity) {
        boolean isOrganization = EntityTypes.isOrganizationType((String)consolidatedEntity.getType());
        return !isOrganization && consolidatedEntity.getIsShownBy() == null && consolidatedEntity.getDepiction() == null;
    }

    private void validateCompleteValidationConstraints(Entity entity) throws EntityValidationException {
        Set violations = this.emValidatorFactory.getValidator().validate((Object)entity, new Class[]{EntityFieldsCompleteValidationGroup.class});
        if (!violations.isEmpty()) {
            throw new EntityValidationException("The consolidated entity contains invalid data!", violations);
        }
    }

    private void validateDataSourceProxyConstraints(Entity entity) throws EntityValidationException {
        Set violations = this.emValidatorFactory.getValidator().validate((Object)entity, new Class[]{EntityFieldsDataSourceProxyValidationGroup.class});
        if (!violations.isEmpty()) {
            throw new EntityValidationException("The entity from the external data source contains invalid data!", violations);
        }
    }
}

