/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.service;

import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.exception.ScoringComputationException;
import eu.europeana.entitymanagement.utils.EntityRecordUtils;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
public class EnrichmentCountQueryService {
    private static final Map<String, String> ENRICHMENT_QUERY_FIELD_MAP = Map.of(EntityTypes.Agent.getEntityType(), "edm_agent", EntityTypes.Concept.getEntityType(), "skos_concept", EntityTypes.Place.getEntityType(), "edm_place", EntityTypes.TimeSpan.getEntityType(), "edm_timespan", EntityTypes.Organization.getEntityType(), "foaf_organization", EntityTypes.Aggregator.getEntityType(), "foaf_organization");
    private static final Logger logger = LogManager.getLogger(EnrichmentCountQueryService.class);
    private static final String ERROR_MSG = "Error retrieving enrichmentCount for entityId=";
    private static final String contentTierPrefix = " AND contentTier:";
    private final WebClient webClient;
    private final EntityManagementConfiguration configuration;

    public EnrichmentCountQueryService(EntityManagementConfiguration configuration) {
        this.configuration = configuration;
        this.webClient = WebClient.builder().build();
    }

    public int getEnrichmentCount(Entity entity) throws ScoringComputationException {
        String uri = this.buildSearchRequestUrl(entity);
        if (logger.isDebugEnabled()) {
            logger.debug("Getting enrichment count for entityId={}; queryUri={}", (Object)entity.getEntityId(), (Object)uri);
        }
        String response = null;
        Instant start = Instant.now();
        try {
            response = (String)this.webClient.get().uri(uri, new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().bodyToMono(String.class).block();
        }
        catch (Exception e) {
            throw new ScoringComputationException(ERROR_MSG + entity.getEntityId(), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved enrichmentCount for entityId={} in {}ms; response={}", (Object)entity.getEntityId(), (Object)Duration.between(start, Instant.now()).toMillis(), (Object)response);
        }
        if (response == null) {
            throw new ScoringComputationException(ERROR_MSG + entity.getEntityId());
        }
        int result = 0;
        JSONObject responseJson = new JSONObject(response);
        if (responseJson.has("totalResults")) {
            result = responseJson.getInt("totalResults");
        }
        return result;
    }

    String buildSearchRequestUrl(Entity entity) {
        StringBuilder url = new StringBuilder(this.configuration.getSearchApiUrlPrefix());
        String searchQuery = String.format("%s:%s ", ENRICHMENT_QUERY_FIELD_MAP.get(entity.getType()), this.getEntityIdsForQuery(entity));
        url.append("&query=" + searchQuery);
        if (!EntityTypes.isOrganizationType((String)entity.getType())) {
            url.append(contentTierPrefix);
            url.append(this.configuration.getEnrichmentsQueryContentTier());
        }
        url.append("&profile=minimal");
        url.append("&rows=0");
        return url.toString();
    }

    private String getEntityIdsForQuery(Entity entity) {
        if (EntityTypes.isTimeSpan((String)entity.getType())) {
            return "\"" + entity.getEntityId() + "\"";
        }
        if (EntityTypes.isOrganizationType((String)entity.getType())) {
            return this.buildSearchedIdsForOrganizations(entity);
        }
        StringBuilder entityIdsBuilder = new StringBuilder("(\"");
        entityIdsBuilder.append("http://data.europeana.eu/").append(EntityRecordUtils.getEntityRequestPathWithBase((String)entity.getEntityId())).append("\" OR \"").append("http://data.europeana.eu/").append(EntityRecordUtils.getEntityRequestPath((String)entity.getEntityId())).append("\")");
        return entityIdsBuilder.toString();
    }

    String buildSearchedIdsForOrganizations(Entity entity) {
        StringBuilder orgIdsBuilder = new StringBuilder("(\"");
        orgIdsBuilder.append(entity.getEntityId());
        if (entity.getSameReferenceLinks() != null) {
            for (String sameAsUri : entity.getSameReferenceLinks()) {
                if (!sameAsUri.startsWith("http://data.europeana.eu/")) continue;
                orgIdsBuilder.append("\" OR \"");
                orgIdsBuilder.append(sameAsUri);
            }
        }
        orgIdsBuilder.append("\")");
        return orgIdsBuilder.toString();
    }
}

