/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.config;

import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SolrConfig {
    private static final Logger logger = LogManager.getLogger(SolrConfig.class);
    private final EntityManagementConfiguration emConfiguration;

    @Autowired
    public SolrConfig(EntityManagementConfiguration emConfiguration) {
        this.emConfiguration = emConfiguration;
    }

    @Bean(value={"prSolrClient"})
    public SolrClient pageRankSolrClient() {
        if (StringUtils.isNotBlank((CharSequence)this.emConfiguration.getPrSolrZookeeperUrl())) {
            return this.initSolrCloudClient(this.emConfiguration.getPrSolrZookeeperUrl(), this.emConfiguration.getIndexingSolrTimeoutMillis(), this.emConfiguration.getPrSolrCollection());
        }
        return this.initSolrClient(this.emConfiguration.getPrSolrUrl(), this.emConfiguration.getIndexingSolrTimeoutMillis());
    }

    @Bean(value={"indexingSolrClient"})
    public SolrClient indexingSolrClient() {
        if (StringUtils.isNotBlank((CharSequence)this.emConfiguration.getIndexingSolrZookeeperUrl())) {
            return this.initSolrCloudClient(this.emConfiguration.getIndexingSolrZookeeperUrl(), this.emConfiguration.getIndexingSolrTimeoutMillis(), this.emConfiguration.getIndexingSolrCollection());
        }
        return this.initSolrClient(this.emConfiguration.getIndexingSolrUrl(), this.emConfiguration.getIndexingSolrTimeoutMillis());
    }

    private SolrClient initSolrClient(String solrUrl, int timeoutMillis) {
        logger.info("Configuring solr client at the url: {}", (Object)solrUrl);
        if (solrUrl.contains(",")) {
            LBHttpSolrClient.Builder builder = new LBHttpSolrClient.Builder();
            return ((LBHttpSolrClient.Builder)builder.withBaseSolrUrls(solrUrl.split(",")).withConnectionTimeout(timeoutMillis)).build();
        }
        HttpSolrClient.Builder builder = new HttpSolrClient.Builder();
        return ((HttpSolrClient.Builder)builder.withBaseSolrUrl(solrUrl).withConnectionTimeout(timeoutMillis)).build();
    }

    private SolrClient initSolrCloudClient(String solrZookeeperUrl, int timeout, String solrCollection) {
        logger.info("Configuring solr client with the zookeperurls: {} and collection: {}", (Object)solrZookeeperUrl, (Object)solrCollection);
        String[] solrZookeeperUrlsList = solrZookeeperUrl.trim().split(",");
        CloudSolrClient client = ((CloudSolrClient.Builder)new CloudSolrClient.Builder(Arrays.asList(solrZookeeperUrlsList), Optional.empty()).withConnectionTimeout(timeout)).build();
        client.setDefaultCollection(solrCollection);
        return client;
    }
}

