/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.service;

import com.zoho.crm.api.record.Record;
import dev.morphia.query.filters.Filter;
import dev.morphia.query.filters.Filters;
import eu.europeana.api.commons.definitions.utils.DateUtils;
import eu.europeana.entitymanagement.batch.service.EntityUpdateService;
import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.config.DataSources;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.exception.ingestion.EntityUpdateException;
import eu.europeana.entitymanagement.mongo.repository.ZohoSyncRepository;
import eu.europeana.entitymanagement.solr.exception.SolrServiceException;
import eu.europeana.entitymanagement.web.model.BatchOperations;
import eu.europeana.entitymanagement.web.model.FailedOperation;
import eu.europeana.entitymanagement.web.model.Operation;
import eu.europeana.entitymanagement.web.model.ZohoSyncReport;
import eu.europeana.entitymanagement.web.service.BaseZohoAccess;
import eu.europeana.entitymanagement.web.service.EntityRecordService;
import eu.europeana.entitymanagement.zoho.organization.ZohoConfiguration;
import eu.europeana.entitymanagement.zoho.organization.ZohoOrganizationConverter;
import eu.europeana.entitymanagement.zoho.utils.ZohoException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;

@Service(value="emZohoSyncService")
public class ZohoSyncService
extends BaseZohoAccess {
    public static final String ZOHO_SYNC_SLACK_TEMPLATE = "%d organisations in Zoho were synchronised with the following actions:\\ncreated: %d, updated: %d, deprecated: %d, undeprecated: %d, permanently deleted: %d, failed: %d";

    @Autowired
    public ZohoSyncService(EntityRecordService entityRecordService, EntityUpdateService entityUpdateService, EntityManagementConfiguration emConfiguration, DataSources datasources, ZohoConfiguration zohoConfiguration, ZohoSyncRepository zohoSyncRepo) {
        super(entityRecordService, entityUpdateService, emConfiguration, datasources, zohoConfiguration, zohoSyncRepo);
    }

    public ZohoSyncReport synchronizeModifiedZohoOrganizations() throws EntityUpdateException {
        ZohoSyncReport previousSync = this.zohoSyncRepo.findLastZohoSyncReport();
        OffsetDateTime modifiedSince = previousSync != null && previousSync.getStartDate() != null ? DateUtils.toOffsetDateTime((Date)previousSync.getStartDate()) : OffsetDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC);
        return this.synchronizeZohoOrganizations(modifiedSince);
    }

    public ZohoSyncReport synchronizeZohoOrganizations(@NonNull OffsetDateTime modifiedSince) throws EntityUpdateException {
        OffsetDateTime deletedSince = modifiedSince.minusDays(this.emConfiguration.getZohoSyncDeleteOffsetDays());
        if (logger.isInfoEnabled()) {
            logger.info("Synchronizing organizations updated after date: {}, and delete after date :{}", (Object)modifiedSince, (Object)deletedSince);
        }
        ZohoSyncReport zohoSyncReport = new ZohoSyncReport(new Date());
        this.synchronizeZohoOrganizations(modifiedSince, zohoSyncReport);
        this.synchronizeDeletedZohoOrganizations(deletedSince, zohoSyncReport);
        logger.info("Zoho update operations completed successfully:\n {}", (Object)zohoSyncReport);
        this.publishReport(zohoSyncReport);
        return this.zohoSyncRepo.save(zohoSyncReport);
    }

    private void publishReport(ZohoSyncReport zohoSyncReport) {
        if (logger.isDebugEnabled()) {
            logger.debug("Sending report to slack : {}", (Object)zohoSyncReport);
        }
        try {
            if (StringUtils.isBlank((CharSequence)this.emConfiguration.getSlackWebHook())) {
                logger.warn("Slack webhook not configured, status report will not be published over Slack!");
                return;
            }
            String jsonMessage = this.buildSyncReportMessageForSlackWebHook(zohoSyncReport);
            WebClient webClient = WebClient.builder().baseUrl(this.emConfiguration.getSlackWebHook()).build();
            WebClient.ResponseSpec resp = webClient.post().contentType(MediaType.APPLICATION_JSON).bodyValue((Object)jsonMessage).retrieve();
            ResponseEntity response = (ResponseEntity)resp.toEntity(String.class).block();
            if (logger.isDebugEnabled()) {
                logger.debug("Received webhook response: {}", response == null ? "" : response.getBody());
            }
        }
        catch (WebClientResponseException e) {
            logger.warn("Exception occurred while sending slack message!", (Throwable)e);
        }
    }

    String buildSyncReportMessageForSlackWebHook(ZohoSyncReport zohoSyncReport) {
        long synced = zohoSyncReport.getCreatedItems() + zohoSyncReport.getUpdatedItems() + zohoSyncReport.getDeprecatedItems();
        long failures = zohoSyncReport.getFailed() == null ? 0L : (long)zohoSyncReport.getFailed().size();
        String slackMessage = String.format(ZOHO_SYNC_SLACK_TEMPLATE, synced, zohoSyncReport.getCreatedItems(), zohoSyncReport.getUpdatedItems(), zohoSyncReport.getDeprecatedItems(), zohoSyncReport.getEnabledItems(), zohoSyncReport.getDeletedItems(), failures, this.generateFailedMessage(zohoSyncReport));
        return "{\"text\":\"" + slackMessage + "\"}";
    }

    private String generateFailedMessage(ZohoSyncReport zohoSyncReport) {
        if (zohoSyncReport.getFailed() == null || zohoSyncReport.getFailed().isEmpty()) {
            return "";
        }
        String headLine = "\\n\\nThe following organisations failed synchronisation:\\n";
        int estimatedSize = headLine.length() + zohoSyncReport.getFailed().size() * 100;
        StringBuilder builder = new StringBuilder(estimatedSize);
        builder.append(headLine);
        for (FailedOperation failed : zohoSyncReport.getFailed()) {
            builder.append(failed.getZohoId()).append(" because of error: ").append(failed.getMessage()).append("\\n");
        }
        return builder.toString();
    }

    void synchronizeZohoOrganizations(@NonNull OffsetDateTime modifiedSince, ZohoSyncReport zohoSyncReport) {
        int page = 1;
        int pageSize = this.emConfiguration.getZohoSyncBatchSize();
        boolean hasNext = true;
        while (hasNext) {
            List orgList;
            try {
                orgList = this.zohoConfiguration.getZohoAccessClient().getZcrmRecordOrganizations(page, pageSize, modifiedSince);
                this.logExecutionProgress(orgList, page, pageSize);
            }
            catch (ZohoException e) {
                zohoSyncReport.addFailedOperation(null, "Zoho access error", "Zoho synchronization exception occured when handling organizations modified in Zoho, the execution was interupted without updating all organizations", (Throwable)e);
                return;
            }
            BatchOperations operations = this.fillOperations(orgList);
            this.performOperations(operations, zohoSyncReport);
            if (this.isLastPage(orgList.size(), pageSize)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Processing updated zoho records finished at page {}, pageSize {}, items on last page {}", (Object)page, (Object)pageSize, (Object)orgList.size());
                }
                hasNext = false;
                continue;
            }
            ++page;
        }
    }

    void synchronizeDeletedZohoOrganizations(OffsetDateTime modifiedSince, ZohoSyncReport zohoSyncReport) throws EntityUpdateException {
        int startPage = 1;
        int pageSize = this.emConfiguration.getZohoSyncBatchSize();
        boolean hasNext = true;
        int currentPageSize = 0;
        List entitiesZohoCoref = null;
        while (hasNext) {
            try {
                List deletedRecordsInZoho = this.zohoConfiguration.getZohoAccessClient().getZohoDeletedRecordOrganizations(modifiedSince, startPage, pageSize);
                currentPageSize = deletedRecordsInZoho.size();
                entitiesZohoCoref = this.getDeletedEntitiesZohoCoref(deletedRecordsInZoho);
                List entityIdsToDelete = this.getEntityIdsByZohoCorefs(entitiesZohoCoref);
                this.runPermanentDelete(entityIdsToDelete, zohoSyncReport);
            }
            catch (ZohoException e) {
                logger.error("Zoho synchronization exception occured when handling organizations deleted in Zoho", (Throwable)e);
                zohoSyncReport.addFailedOperation(null, "Zoho access error", (Throwable)e);
            }
            catch (SolrServiceException | RuntimeException e) {
                logger.error("Zoho synchronization exception occured when handling organizations deleted in Zoho", e);
                String message = this.buildErrorMessage("Unexpected error occured when deleting organizations with ids: ", entitiesZohoCoref);
                zohoSyncReport.addFailedOperation(null, "Entity deletion error", message, e);
            }
            if (this.isLastPage(currentPageSize, pageSize)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Processing of deleted records is completes at page {}, pageSize {}, items on last page {}", (Object)startPage, (Object)pageSize, (Object)currentPageSize);
                }
                hasNext = false;
                continue;
            }
            ++startPage;
        }
    }

    List<String> getEntityIdsByZohoCorefs(List<String> entitiesZohoCoref) {
        ArrayList<String> entityIdsToDelete = new ArrayList<String>(entitiesZohoCoref.size());
        List recordsToDelete = this.entityRecordService.retrieveMultipleByEntityIdsOrCoreference(entitiesZohoCoref, null);
        for (EntityRecord entityRecord : recordsToDelete) {
            String zohoProxyId = this.getZohoProxyId(entityRecord);
            if (zohoProxyId == null && logger.isWarnEnabled()) {
                logger.warn("Cannot get zohoProxyId! Organization does not have a zoho proxy, but a zoho coref: {} ", (Object)entityRecord);
            }
            if (!entitiesZohoCoref.contains(zohoProxyId)) continue;
            entityIdsToDelete.add(entityRecord.getEntityId());
        }
        return entityIdsToDelete;
    }

    String getZohoProxyId(EntityRecord entityRecord) {
        for (String proxyId : entityRecord.getExternalProxyIds()) {
            if (!proxyId.startsWith(this.zohoConfiguration.getZohoBaseUrl())) continue;
            return proxyId;
        }
        return null;
    }

    boolean isLastPage(int currentPageSize, int maxItemsPerPage) {
        return currentPageSize < maxItemsPerPage;
    }

    BatchOperations fillOperations(List<Record> orgList) {
        BatchOperations operations = new BatchOperations();
        Set modifiedZohoUrls = this.getZohoOrganizationUrls(orgList);
        List existingEntityRecords = this.findEntityRecordsByProxyId(modifiedZohoUrls);
        for (Record zohoOrg : orgList) {
            Long zohoId = zohoOrg.getId();
            Optional entityRecordOptional = this.findRecordInList(zohoId, existingEntityRecords);
            EntityRecord entityRecord = null;
            if (entityRecordOptional.isPresent()) {
                entityRecord = (EntityRecord)entityRecordOptional.get();
            }
            this.addOperation(operations, zohoId, zohoOrg, entityRecord);
        }
        return operations;
    }

    List<EntityRecord> findEntityRecordsByProxyId(Set<String> modifiedInZoho) {
        Filter proxyIdsFilter = Filters.in((String)"proxies.proxyId", modifiedInZoho);
        return this.entityRecordService.findEntitiesWithFilter(0, modifiedInZoho.size(), new Filter[]{proxyIdsFilter}, null);
    }

    private void addOperation(BatchOperations operations, Long zohoId, Record zohoOrg, EntityRecord entityRecord) {
        boolean markedForDeletion;
        boolean hasDpsOwner;
        String zohoRecordEuropeanaID = ZohoOrganizationConverter.getEuropeanaIdFieldValue((Record)zohoOrg);
        String emOperation = this.identifyOperationType(zohoId, zohoRecordEuropeanaID, entityRecord, hasDpsOwner = this.hasRequiredOwnership(zohoOrg), markedForDeletion = ZohoOrganizationConverter.isMarkedForDeletion((Record)zohoOrg), zohoOrg);
        if (emOperation != null) {
            Operation operation = new Operation(zohoRecordEuropeanaID, emOperation, zohoOrg, entityRecord);
            operations.addOperation(operation);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Organization has changed in zoho, but there is no operation to perform on entity database, probably becasue the zoho organization doesn't have the required role, it was marked for deletion, or the generation of Organizations is not allowed for this job instance. Zoho id: {}, hasDpsOwner: {}, markedForDeletion: {}, entityRecord: {}", (Object)zohoId, (Object)hasDpsOwner, (Object)markedForDeletion, (Object)(entityRecord != null ? entityRecord.getEntityId() : "null"));
        }
    }

    String identifyOperationType(Long zohoId, String zohoRecordEuropeanaID, EntityRecord entityRecord, boolean hasDpsOwner, boolean markedForDeletion, Record zohoOrg) {
        if (entityRecord == null) {
            return this.shouldCreate(zohoId, zohoRecordEuropeanaID, hasDpsOwner, markedForDeletion) ? "create" : null;
        }
        if (this.emConfiguration.isGenerateOrganizationEuropeanaId() && this.isModifiedByApi(zohoOrg)) {
            if (logger.isInfoEnabled()) {
                logger.info("Skip Organization organization, it was last modified by the API by the  {}", (Object)zohoId);
            }
            return null;
        }
        if (this.shouldDisable(hasDpsOwner, markedForDeletion)) {
            return "delete";
        }
        if (this.shouldEnable(entityRecord, hasDpsOwner, markedForDeletion)) {
            return "enable";
        }
        if (StringUtils.isBlank((CharSequence)zohoRecordEuropeanaID)) {
            logger.warn("Zoho Organization doesn't have a Europeana ID, it should be set in Zoho before running the update workflow {}", (Object)zohoId);
        }
        return "update";
    }

    private boolean isModifiedByApi(Record zohoOrg) {
        String modifiedBy = ZohoOrganizationConverter.getOwnerName((Record)zohoOrg);
        return "Europeana APIs".equals(modifiedBy);
    }

    boolean shouldEnable(EntityRecord entityRecord, boolean hasDpsOwner, boolean markedForDeletion) {
        return entityRecord.isDisabled() && !this.shouldDisable(hasDpsOwner, markedForDeletion);
    }

    boolean shouldCreate(Long zohoId, String zohoRecordEuropeanaID, boolean hasDpsOwner, boolean markedForDeletion) {
        if (this.skipNonExisting(hasDpsOwner, markedForDeletion)) {
            logger.debug("Organization has changed in zoho, but it is marked for deletion or doesn't have DPS as Owner. Skipped creation for Zoho id: {}, hasDpsOwner: {}, markedForDeletion: {}", (Object)zohoId, (Object)hasDpsOwner, (Object)markedForDeletion);
            return false;
        }
        if (this.skipNoZohoEuropeanaId(zohoRecordEuropeanaID, this.emConfiguration.isGenerateOrganizationEuropeanaId())) {
            logger.debug("Organization has changed in zoho, but the job instance is not allowed to generate entity ids for Organizations. Skipped entity registration for Zoho id: {}", (Object)zohoId);
            return false;
        }
        logger.debug("New Organization to Create for zoho ID: {}", (Object)zohoId);
        return true;
    }

    boolean shouldDisable(boolean hasDpsOwner, boolean markedForDeletion) {
        return !hasDpsOwner || markedForDeletion;
    }

    private boolean skipNoZohoEuropeanaId(String zohoRecordEuropeanaID, boolean organizationIdGenerationEnabled) {
        return StringUtils.isBlank((CharSequence)zohoRecordEuropeanaID) && !organizationIdGenerationEnabled;
    }

    boolean skipNonExisting(boolean hasDpsOwner, boolean markedForDeletion) {
        return markedForDeletion && !this.emConfiguration.isRegisterDeprecated() || !hasDpsOwner;
    }

    boolean needsToBeEnabled(EntityRecord entityRecord, boolean hasDpsOwner, boolean markedForDeletion) {
        return entityRecord != null && entityRecord.isDisabled() && hasDpsOwner && !markedForDeletion;
    }
}

