/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.service;

import com.zoho.crm.api.record.DeletedRecord;
import com.zoho.crm.api.record.Record;
import eu.europeana.api.commons.definitions.utils.DateUtils;
import eu.europeana.entitymanagement.batch.service.EntityUpdateService;
import eu.europeana.entitymanagement.common.config.DataSource;
import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.config.DataSources;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledUpdateType;
import eu.europeana.entitymanagement.definitions.exceptions.UnsupportedEntityTypeException;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.definitions.model.Organization;
import eu.europeana.entitymanagement.exception.EntityCreationException;
import eu.europeana.entitymanagement.exception.FunctionalRuntimeException;
import eu.europeana.entitymanagement.exception.ingestion.EntityUpdateException;
import eu.europeana.entitymanagement.mongo.repository.ZohoSyncRepository;
import eu.europeana.entitymanagement.solr.exception.SolrServiceException;
import eu.europeana.entitymanagement.utils.EntityRecordUtils;
import eu.europeana.entitymanagement.web.model.BatchOperations;
import eu.europeana.entitymanagement.web.model.Operation;
import eu.europeana.entitymanagement.web.model.ZohoSyncReport;
import eu.europeana.entitymanagement.web.service.EntityRecordService;
import eu.europeana.entitymanagement.zoho.organization.ZohoConfiguration;
import eu.europeana.entitymanagement.zoho.organization.ZohoOrganizationConverter;
import eu.europeana.entitymanagement.zoho.utils.ZohoUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseZohoAccess {
    static final Logger logger = LogManager.getLogger(BaseZohoAccess.class);
    final EntityRecordService entityRecordService;
    final EntityUpdateService entityUpdateService;
    final EntityManagementConfiguration emConfiguration;
    final DataSources datasources;
    final DataSource zohoDataSource;
    final ZohoConfiguration zohoConfiguration;
    final ZohoSyncRepository zohoSyncRepo;

    public BaseZohoAccess(EntityRecordService entityRecordService, EntityUpdateService entityUpdateService, EntityManagementConfiguration emConfiguration, DataSources datasources, ZohoConfiguration zohoConfiguration, ZohoSyncRepository zohoSyncRepo) {
        this.entityRecordService = entityRecordService;
        this.entityUpdateService = entityUpdateService;
        this.emConfiguration = emConfiguration;
        this.datasources = datasources;
        this.zohoConfiguration = zohoConfiguration;
        this.zohoDataSource = this.initZohoDataSource();
        this.zohoSyncRepo = zohoSyncRepo;
    }

    protected DataSource initZohoDataSource() {
        Optional<DataSource> zohoDatasource = this.datasources.getDatasourceById("zoho-crm");
        if (zohoDatasource.isEmpty()) {
            throw new FunctionalRuntimeException("No zoho data source found! Zoho data source must be present in configurations with id: zoho-crm");
        }
        return zohoDatasource.get();
    }

    OffsetDateTime generateFixDate() throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss", Locale.ENGLISH);
        String dateInString = "23-Oct-2023 14:38:00";
        try {
            Date date = formatter.parse(dateInString);
            return DateUtils.toOffsetDateTime((Date)date);
        }
        catch (ParseException e) {
            logger.warn("Invalid date format!", (Throwable)e);
            return null;
        }
    }

    protected String buildErrorMessage(String message, List<String> ids) {
        if (ids != null) {
            StringBuilder builder = new StringBuilder(message);
            builder.append(ids);
            message = builder.toString();
        }
        return message;
    }

    protected void logExecutionProgress(List<Record> orgList, int page, int pageSize) {
        int start = (page - 1) * pageSize;
        int end = start + orgList.size();
        logger.debug("Processing organizations set: {} - {}", (Object)start, (Object)end);
    }

    protected void performOperations(BatchOperations operations, ZohoSyncReport zohoSyncReport) {
        this.performCreateOperations(operations.getCreateOperations(), zohoSyncReport);
        this.performDeprecationOperations(operations.getDeleteOperations(), zohoSyncReport);
        this.performEnablingOperations(operations.getEnableOperations(), zohoSyncReport);
        this.performUpdateOperations(operations.getUpdateOperations(), zohoSyncReport);
    }

    @Deprecated
    void performPermanentDeleteOperations(SortedSet<Operation> permanentDeleteOperations, ZohoSyncReport zohoSyncReport) {
        if (permanentDeleteOperations == null || permanentDeleteOperations.isEmpty()) {
            return;
        }
        List<String> entitiesToDelete = permanentDeleteOperations.stream().map(permDelete -> permDelete.getZohoEuropeanaId()).collect(Collectors.toList());
        try {
            this.runPermanentDelete(entitiesToDelete, zohoSyncReport);
        }
        catch (SolrServiceException | RuntimeException e) {
            String message = "Cannot perform permanent delete operations for organizations with ids:" + entitiesToDelete.toArray();
            zohoSyncReport.addFailedOperation(null, "Entity deletion error", message, e);
        }
    }

    void runPermanentDelete(List<String> entitiesToDelete, ZohoSyncReport zohoSyncReport) throws SolrServiceException {
        if (entitiesToDelete == null || entitiesToDelete.isEmpty()) {
            return;
        }
        long deleted = this.entityRecordService.deleteBulk(entitiesToDelete, true);
        zohoSyncReport.increaseDeleted(deleted);
    }

    void performDeprecationOperations(SortedSet<Operation> deprecateOperations, ZohoSyncReport zohoSyncReport) {
        if (deprecateOperations == null || deprecateOperations.isEmpty()) {
            return;
        }
        for (Operation operation : deprecateOperations) {
            boolean allreadyDisabled = operation.getEntityRecord().isDisabled();
            if (allreadyDisabled) {
                if (logger.isInfoEnabled()) {
                    logger.info("Organization was marked for deletion, but it is already disabled. Skipping disable for id: {}", (Object)operation.getZohoEuropeanaId());
                }
            } else {
                this.performDeprecation(zohoSyncReport, operation);
            }
            try {
                logger.info("Updating disabled organization with id: {}", (Object)operation.getZohoEuropeanaId());
                this.entityUpdateService.runSynchronousUpdate(operation.getEntityRecord().getEntityId());
                if (!allreadyDisabled) continue;
                zohoSyncReport.increaseUpdated(1L);
            }
            catch (Exception e) {
                zohoSyncReport.addFailedOperation(operation.getZohoEuropeanaId(), "Entity synchronous update error", e);
            }
        }
    }

    String generateZohoOrganizationUrl(Long zohoRecordId) {
        return ZohoUtils.buildZohoOrganizationId((String)this.zohoConfiguration.getZohoBaseUrl(), (Long)zohoRecordId);
    }

    private void performDeprecation(ZohoSyncReport zohoSyncReport, Operation operation) {
        try {
            this.entityRecordService.disableEntityRecord(operation.getEntityRecord(), false);
            zohoSyncReport.increaseDeprecated(1L);
        }
        catch (EntityUpdateException e) {
            zohoSyncReport.addFailedOperation(operation.getZohoEuropeanaId(), "Solr deletion error", (Throwable)((Object)e));
        }
        catch (RuntimeException e) {
            zohoSyncReport.addFailedOperation(operation.getZohoEuropeanaId(), "Entity deprecation error", e);
        }
    }

    void performEnablingOperations(SortedSet<Operation> enablingOperations, ZohoSyncReport zohoSyncReport) {
        if (enablingOperations == null || enablingOperations.isEmpty()) {
            return;
        }
        for (Operation operation2 : enablingOperations) {
            if (operation2.getEntityRecord().isDisabled()) {
                try {
                    this.entityRecordService.enableEntityRecord(operation2.getEntityRecord());
                    zohoSyncReport.increaseEnabled(1L);
                }
                catch (EntityUpdateException | RuntimeException e) {
                    zohoSyncReport.addFailedOperation(operation2.getEntityRecord().getEntityId(), "Entity enable error", (Throwable)e);
                }
                continue;
            }
            logger.info("The enable operation was not performed as the entity is already enabled in the database. Skipping enable for id: {}", (Object)operation2.getZohoEuropeanaId());
        }
        List<String> entityIds = enablingOperations.stream().map(operation -> operation.getEntityRecord().getEntityId()).collect(Collectors.toList());
        try {
            this.entityUpdateService.scheduleTasks(entityIds, (ScheduledTaskType)ScheduledUpdateType.FULL_UPDATE);
        }
        catch (RuntimeException e) {
            String message = "Cannot schedule update operations for organizations with ids:" + entityIds.toArray();
            zohoSyncReport.addFailedOperation(null, "Entity scheduled update error", message, e);
        }
    }

    void performUpdateOperations(SortedSet<Operation> updateOperations, ZohoSyncReport zohoSyncReport) {
        if (updateOperations == null || updateOperations.isEmpty()) {
            return;
        }
        List<String> entityIds = updateOperations.stream().map(operation -> operation.getEntityRecord().getEntityId()).collect(Collectors.toList());
        try {
            this.entityUpdateService.scheduleTasks(entityIds, (ScheduledTaskType)ScheduledUpdateType.FULL_UPDATE);
            zohoSyncReport.increaseUpdated(updateOperations.size());
        }
        catch (RuntimeException e) {
            String message = "Cannot schedule update operations for organizations with ids:" + entityIds.toArray();
            zohoSyncReport.addFailedOperation(null, "Entity scheduled update error", message, e);
        }
    }

    void performCreateOperations(SortedSet<Operation> createOperations, ZohoSyncReport zohoSyncReport) {
        if (createOperations == null || createOperations.isEmpty()) {
            return;
        }
        List<String> entitiesToUpdate = this.performEntityRegistration(createOperations, zohoSyncReport);
        try {
            this.entityUpdateService.scheduleTasks(entitiesToUpdate, (ScheduledTaskType)ScheduledUpdateType.FULL_UPDATE);
        }
        catch (RuntimeException e) {
            String message = "Cannot schedule update operations for newly created organizations with ids:" + entitiesToUpdate.toArray();
            zohoSyncReport.addFailedOperation(null, "Entity scheduled update error", message, e);
        }
    }

    List<String> performEntityRegistration(SortedSet<Operation> createOperations, ZohoSyncReport zohoSyncReport) {
        ArrayList<String> entitiesToUpdate = new ArrayList<String>(createOperations.size());
        for (Operation operation : createOperations) {
            boolean mustGenerateEuropeanaId = StringUtils.isEmpty((CharSequence)operation.getZohoEuropeanaId());
            String beforeOperationZohoId = mustGenerateEuropeanaId ? null : operation.getZohoEuropeanaId();
            Optional<EntityRecord> registeredRecord = this.performEntityRegistration(operation, zohoSyncReport, entitiesToUpdate);
            if (registeredRecord.isPresent()) {
                if (mustGenerateEuropeanaId) {
                    zohoSyncReport.increaseSubmittedZohoEuropeanaId();
                }
                if (beforeOperationZohoId == null) continue;
                this.verifyOrgIdAfterRegistration(operation, registeredRecord, beforeOperationZohoId);
                continue;
            }
            logger.warn("Organization registration was not completed! Check logs for organization: {}", (Object)operation.getZohoRecord().getId());
        }
        return entitiesToUpdate;
    }

    void verifyOrgIdAfterRegistration(Operation operation, Optional<EntityRecord> registeredRecord, String beforeOperationZohoId) {
        String currentEntityId = registeredRecord.get().getEntityId();
        if (beforeOperationZohoId != null && !currentEntityId.equals(beforeOperationZohoId)) {
            throw new FunctionalRuntimeException("Organization registration should not update existing Org.ID in Zoho! Check logs for organization: " + operation.getZohoRecord().getId() + " oldOrgId: " + beforeOperationZohoId + " new OrgId: " + currentEntityId);
        }
    }

    private Optional<EntityRecord> performEntityRegistration(Operation operation, ZohoSyncReport zohoSyncReport, List<String> entitiesToUpdate) {
        Organization zohoOrganization = ZohoOrganizationConverter.convertToOrganizationEntity((Record)operation.getZohoRecord(), (String)this.zohoConfiguration.getZohoBaseUrl(), (Map)this.emConfiguration.getCountryMappings(), (Map)this.emConfiguration.getRoleMappings());
        Optional<EntityRecord> res = Optional.empty();
        try {
            List<EntityRecord> existingEntities = this.findDupplicateOrganization(operation, zohoOrganization);
            if (!existingEntities.isEmpty()) {
                zohoSyncReport.addFailedOperation(zohoOrganization.getAbout(), "Dupplicate entity error", "Dupplicate of :" + EntityRecordUtils.getEntityIds(existingEntities), null);
            } else {
                Organization europeanaProxyEntity = new Organization();
                europeanaProxyEntity.setAbout(zohoOrganization.getAbout());
                EntityRecord savedEntityRecord = this.entityRecordService.createEntityFromRequest((Entity)europeanaProxyEntity, (Entity)zohoOrganization, this.getZohoDataSource(), operation.getZohoEuropeanaId());
                res = Optional.of(savedEntityRecord);
                if (StringUtils.isEmpty((CharSequence)operation.getZohoEuropeanaId())) {
                    operation.setZohoEuropeanaId(savedEntityRecord.getEntityId());
                }
                entitiesToUpdate.add(savedEntityRecord.getEntityId());
                zohoSyncReport.increaseCreated(1L);
                if (logger.isDebugEnabled()) {
                    logger.debug("Created Entity record for externalId={}; entityId={}", (Object)zohoOrganization.getAbout(), (Object)savedEntityRecord.getEntityId());
                }
            }
        }
        catch (UnsupportedEntityTypeException | EntityCreationException e) {
            zohoSyncReport.addFailedOperation(zohoOrganization.getAbout(), "Entity creation error", "Entity registration failed.", (Throwable)e);
        }
        catch (RuntimeException e) {
            zohoSyncReport.addFailedOperation(zohoOrganization.getAbout(), "Entity creation error", e);
        }
        return res;
    }

    List<EntityRecord> findDupplicateOrganization(Operation operation, Organization zohoOrganization) {
        ArrayList<String> allCorefs = new ArrayList<String>();
        if (operation.getZohoEuropeanaId() != null) {
            allCorefs.add(operation.getZohoEuropeanaId());
        }
        allCorefs.add(zohoOrganization.getAbout());
        String europeanaId = ZohoOrganizationConverter.getEuropeanaIdFieldValue((Record)operation.getZohoRecord());
        if (europeanaId != null) {
            allCorefs.add(europeanaId);
        }
        if (zohoOrganization.getSameReferenceLinks() != null && !zohoOrganization.getSameReferenceLinks().isEmpty()) {
            allCorefs.addAll(zohoOrganization.getSameReferenceLinks());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Searching existing organizations by corefs: {}", allCorefs);
        }
        boolean excludeDisabled = false;
        List<EntityRecord> existingEntities = this.entityRecordService.findEntitiesByCoreference(allCorefs, null, excludeDisabled);
        if (logger.isDebugEnabled() && !existingEntities.isEmpty()) {
            logger.debug("Found existing dupplicated organization with id: {} ", (Object)EntityRecordUtils.getEntityIds(existingEntities));
        }
        return existingEntities;
    }

    protected boolean hasRequiredOwnership(Record zohoRecord) {
        String ownerName = ZohoOrganizationConverter.getOwnerName((Record)zohoRecord);
        boolean hasDpsOwner = ownerName.equals(this.emConfiguration.getZohoSyncOwnerFilter());
        if (!hasDpsOwner && ownerName.contains("DPS")) {
            logger.warn("This organization might have typos in the owner name: '{}'", (Object)ownerName);
        }
        return hasDpsOwner;
    }

    protected Set<String> getZohoOrganizationUrls(List<Record> orgList) {
        HashSet<String> modifiedInZoho = new HashSet<String>();
        if (!orgList.isEmpty()) {
            orgList.forEach(updatedRecord -> modifiedInZoho.add(this.generateZohoOrganizationUrl(updatedRecord.getId())));
        }
        return modifiedInZoho;
    }

    protected List<String> getDeletedEntitiesZohoCoref(List<DeletedRecord> deletedInZoho) {
        ArrayList<String> deletedEntityIds = new ArrayList<String>();
        if (!deletedInZoho.isEmpty()) {
            deletedInZoho.forEach(deletedRecord -> deletedEntityIds.add(this.generateZohoOrganizationUrl(deletedRecord.getId())));
        }
        return deletedEntityIds;
    }

    protected Optional<EntityRecord> findRecordInList(Long zohoId, List<EntityRecord> existingRecords) {
        if (existingRecords == null || existingRecords.isEmpty()) {
            return Optional.ofNullable(null);
        }
        String zohoUrl = this.generateZohoOrganizationUrl(zohoId);
        return existingRecords.stream().filter(er -> er.getExternalProxyIds().contains(zohoUrl)).findFirst();
    }

    public DataSource getZohoDataSource() {
        return this.zohoDataSource;
    }
}

