/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.processor;

import eu.europeana.entitymanagement.batch.processor.BaseEntityProcessor;
import eu.europeana.entitymanagement.definitions.LanguageCodes;
import eu.europeana.entitymanagement.definitions.batch.model.BatchEntityRecord;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledUpdateType;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.exception.EntityMismatchException;
import java.util.Objects;
import java.util.Set;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class EntityVerificationLogger
extends BaseEntityProcessor {
    private final Set<String> supportedLanguageCodes;

    public EntityVerificationLogger(LanguageCodes languageCodes) {
        super(new ScheduledTaskType[]{ScheduledUpdateType.FULL_UPDATE, ScheduledUpdateType.METRICS_UPDATE});
        this.supportedLanguageCodes = languageCodes.getSupportedLangCodes();
    }

    @Override
    BatchEntityRecord doProcessing(@NonNull BatchEntityRecord entityRecord) throws Exception {
        this.checkPrefLabels(entityRecord.getEntityRecord());
        return entityRecord;
    }

    private void checkPrefLabels(EntityRecord entityRecord) throws EntityMismatchException {
        int consolidatedPrefLabels = entityRecord.getEntity().getPrefLabel().size();
        long proxyPrefLabels = entityRecord.getProxies().stream().map(p -> p.getEntity().getPrefLabel()).filter(Objects::nonNull).flatMap(prefLabels -> prefLabels.keySet().stream()).filter(this.supportedLanguageCodes::contains).distinct().count();
        if ((long)consolidatedPrefLabels != proxyPrefLabels) {
            throw new EntityMismatchException(String.format("Consolidated entity for %s has %d prefLabels; expected %d", entityRecord.getEntityId(), consolidatedPrefLabels, proxyPrefLabels));
        }
    }
}

