/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.model;

import com.zoho.crm.api.record.Record;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class Operation
implements Comparable<Operation> {
    private String action;
    private String zohoEuropeanaId;
    private Record zohoRecord;
    private Date modified;
    EntityRecord entityRecord;

    public Operation(String zohoEuropeanaId, String action, Record zohoRecord, EntityRecord entityRecord) {
        if (!StringUtils.isBlank((CharSequence)zohoEuropeanaId)) {
            this.zohoEuropeanaId = zohoEuropeanaId;
        }
        this.action = action;
        this.zohoRecord = zohoRecord;
        this.modified = zohoRecord != null ? new Date(zohoRecord.getModifiedTime().toInstant().toEpochMilli()) : new Date();
        this.entityRecord = entityRecord;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getZohoEuropeanaId() {
        return this.zohoEuropeanaId;
    }

    public void setZohoEuropeanaId(String zohoEuropeanaId) {
        this.zohoEuropeanaId = zohoEuropeanaId;
    }

    public int hashCode() {
        return this.getZohoRecord().getId().hashCode();
    }

    public String toString() {
        return String.format("zohoId: %s, action: %s, zohoEuropeanaId: %", this.getZohoRecord().getId(), this.getAction(), this.getZohoEuropeanaId());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Operation op2 = (Operation)obj;
        if ("perm_delete".equals(this.getAction())) {
            return this.getZohoEuropeanaId().equals(op2.getZohoEuropeanaId());
        }
        return this.getZohoRecord().getId().equals(op2.getZohoRecord().getId()) && this.getAction().equals(op2.getAction());
    }

    @Override
    public int compareTo(Operation o) {
        int ret = this.getModified().compareTo(o.getModified());
        if (ret == 0) {
            ret = this.getAction().compareTo(o.getAction());
        }
        if (ret == 0 && this.getZohoRecord() != null) {
            if (o.getZohoRecord() == null) {
                return 1;
            }
            ret = this.getZohoRecord().getId().compareTo(o.getZohoRecord().getId());
        }
        if ("perm_delete".equals(this.getAction())) {
            ret = this.getZohoEuropeanaId().compareTo(o.getZohoEuropeanaId());
        }
        return ret;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public Record getZohoRecord() {
        return this.zohoRecord;
    }

    public EntityRecord getEntityRecord() {
        return this.entityRecord;
    }
}

