/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.writer;

import eu.europeana.entitymanagement.batch.utils.BatchUtils;
import eu.europeana.entitymanagement.definitions.batch.model.BatchEntityRecord;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledRemovalType;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import eu.europeana.entitymanagement.web.service.EntityRecordService;
import java.util.List;
import java.util.Set;
import org.springframework.batch.item.ItemWriter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class EntityRecordDatabaseRemovalWriter
implements ItemWriter<BatchEntityRecord> {
    private static final Set<ScheduledTaskType> supportedScheduledTasks = Set.of(ScheduledRemovalType.PERMANENT_DELETION);
    private final EntityRecordService entityRecordService;

    public EntityRecordDatabaseRemovalWriter(EntityRecordService entityRecordService) {
        this.entityRecordService = entityRecordService;
    }

    public void write(@NonNull List<? extends BatchEntityRecord> entityRecords) throws Exception {
        List ids = BatchUtils.filterRecordsForWriters((Set)supportedScheduledTasks, entityRecords);
        if (!ids.isEmpty()) {
            this.entityRecordService.deleteBulk(ids, false);
        }
    }
}

