/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.processor;

import eu.europeana.entitymanagement.batch.processor.BaseEntityProcessor;
import eu.europeana.entitymanagement.common.config.DataSource;
import eu.europeana.entitymanagement.config.DataSources;
import eu.europeana.entitymanagement.definitions.batch.model.BatchEntityRecord;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledUpdateType;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.EntityProxy;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.dereference.Dereferencer;
import eu.europeana.entitymanagement.exception.DatasourceDereferenceException;
import eu.europeana.entitymanagement.exception.EntityMismatchException;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import eu.europeana.entitymanagement.web.service.DereferenceServiceLocator;
import eu.europeana.entitymanagement.web.service.EntityRecordService;
import eu.europeana.entitymanagement.zoho.utils.WikidataUtils;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class EntityDereferenceProcessor
extends BaseEntityProcessor {
    private static final String MISMATCH_EXCEPTION_STRING = "DataSource type %s does not match entity type %s for entityId=%s, proxyId=%s";
    private static final Logger logger = LogManager.getLogger(EntityDereferenceProcessor.class);
    private final DereferenceServiceLocator dereferenceServiceLocator;
    private final DataSources datasources;
    private final EntityRecordService entityRecordService;

    @Autowired
    public EntityDereferenceProcessor(DereferenceServiceLocator dereferenceServiceLocator, DataSources datasources, EntityRecordService entityRecordService) {
        super(new ScheduledTaskType[]{ScheduledUpdateType.FULL_UPDATE});
        this.dereferenceServiceLocator = dereferenceServiceLocator;
        this.datasources = datasources;
        this.entityRecordService = entityRecordService;
    }

    public BatchEntityRecord doProcessing(@NonNull BatchEntityRecord entityRecord) throws Exception {
        Date timestamp = new Date();
        TreeSet wikidataEntityIds = new TreeSet();
        this.collectWikidataEntityIds(entityRecord.getEntityRecord().getEuropeanaProxy().getEntity(), wikidataEntityIds);
        for (EntityProxy externalProxy : entityRecord.getEntityRecord().getExternalProxies()) {
            Optional dataSource = this.datasources.getDatasource(externalProxy.getProxyId());
            if (dataSource.isPresent() && ((DataSource)dataSource.get()).isStatic()) continue;
            Entity externalEntity = this.dereferenceAndUpdateProxy(externalProxy, entityRecord.getEntityRecord(), timestamp);
            this.collectWikidataEntityIds(externalEntity, wikidataEntityIds);
        }
        if (EntityTypes.Organization.getEntityType().equals(entityRecord.getEntityRecord().getEntity().getType())) {
            this.handleWikidataReferenceChange(wikidataEntityIds, entityRecord.getEntityRecord(), timestamp);
        }
        return entityRecord;
    }

    private void handleWikidataReferenceChange(@NonNull TreeSet<String> wikidataEntityIds, EntityRecord entityRecord, @NonNull Date timestamp) throws Exception {
        EntityProxy wikidataProxy = entityRecord.getWikidataProxy();
        boolean noWikidataProxy = wikidataProxy == null && wikidataEntityIds.isEmpty();
        boolean noChangeForProxy = wikidataProxy != null && wikidataEntityIds.contains(wikidataProxy.getProxyId());
        boolean noWikidataId = wikidataEntityIds.isEmpty();
        if (noWikidataProxy || noChangeForProxy) {
            return;
        }
        if (noWikidataId && wikidataProxy != null) {
            entityRecord.getProxies().remove(wikidataProxy);
            return;
        }
        String wikidataId = wikidataEntityIds.first();
        if (wikidataProxy == null) {
            EntityProxy newProxy = this.addWikidataProxyAndDeref(wikidataId, entityRecord, timestamp);
            this.logNewProxyCreated(entityRecord, newProxy);
        } else if (!wikidataEntityIds.contains(wikidataProxy.getProxyId())) {
            this.handleNewWikidataId(entityRecord, wikidataEntityIds, wikidataId, wikidataProxy, timestamp);
        }
    }

    private void handleNewWikidataId(EntityRecord entityRecord, TreeSet<String> wikidataEntityIds, String wikidataId, EntityProxy wikidataProxy, Date timestamp) throws Exception {
        boolean hasRedirectionCoref;
        Optional redirectedWikidataId = WikidataUtils.getWikidataId((List)wikidataProxy.getEntity().getSameReferenceLinks());
        boolean bl = hasRedirectionCoref = redirectedWikidataId.isPresent() && wikidataEntityIds.contains(redirectedWikidataId.get());
        if (hasRedirectionCoref) {
            this.logProxyWithRedirectionExists(entityRecord, wikidataId);
        } else {
            this.updateWikidataProxies(entityRecord, wikidataId, wikidataProxy, wikidataEntityIds, timestamp);
        }
    }

    void logNewProxyCreated(EntityRecord entityRecord, EntityProxy newProxy) {
        if (logger.isDebugEnabled()) {
            logger.debug("For Entity Record with id:{}, wikidata proxy with id: {}  was created", (Object)entityRecord.getEntityId(), (Object)newProxy.getProxyId());
        }
    }

    void logProxyWithRedirectionExists(EntityRecord entityRecord, String wikidataId) {
        if (logger.isDebugEnabled()) {
            String message = "For Entity Record with id:{}, wikidata proxy was not replaced as the proxy id: {} was found in coreferences.";
            logger.debug(message, (Object)entityRecord.getEntityId(), (Object)wikidataId);
        }
    }

    private void updateWikidataProxies(EntityRecord entityRecord, String wikidataId, EntityProxy wikidataProxy, TreeSet<String> wikidataEntityIds, @NonNull Date timestamp) throws Exception {
        entityRecord.getProxies().remove(wikidataProxy);
        if (logger.isDebugEnabled()) {
            logger.debug("For Entity Record with id:{}, wikidata proxy with id: {}  was removed", (Object)entityRecord.getEntityId(), (Object)wikidataId);
        }
        if (!wikidataEntityIds.isEmpty()) {
            EntityProxy newProxy = this.addWikidataProxyAndDeref(wikidataId, entityRecord, timestamp);
            if (logger.isDebugEnabled()) {
                logger.debug("For Entity Record with id:{}, wikidata proxy was replaced, new proxy id: {}", (Object)entityRecord.getEntityId(), (Object)newProxy.getProxyId());
            }
        }
    }

    private EntityProxy addWikidataProxyAndDeref(String wikidataId, EntityRecord entityRecord, @NonNull Date timestamp) throws Exception {
        EntityProxy wikidataProxy = this.entityRecordService.appendWikidataProxy(entityRecord, wikidataId, entityRecord.getEntity().getType(), timestamp);
        this.dereferenceAndUpdateProxy(wikidataProxy, entityRecord, timestamp);
        return wikidataProxy;
    }

    private void collectWikidataEntityIds(Entity entity, @NonNull TreeSet<String> wikidataEntityIds) {
        List wikidataIds = WikidataUtils.getAllWikidataIds((List)entity.getSameReferenceLinks());
        if (!wikidataIds.isEmpty()) {
            wikidataEntityIds.addAll(wikidataIds);
        }
    }

    private Entity dereferenceAndUpdateProxy(@NonNull EntityProxy externalProxy, @NonNull EntityRecord entityRecord, @NonNull Date timestamp) throws Exception {
        String entityType;
        String entityId = entityRecord.getEntityId();
        String proxyId = externalProxy.getProxyId();
        Dereferencer dereferencer = this.dereferenceServiceLocator.getDereferencer(proxyId, entityType = entityRecord.getEntity().getType());
        Optional proxyResponseOptional = dereferencer.dereferenceEntityById(proxyId);
        if (proxyResponseOptional.isEmpty()) {
            throw new DatasourceDereferenceException("Unsuccessful dereferenciation (empty response) for externalId=" + proxyId + "; entityId=" + entityId);
        }
        Entity proxyResponse = (Entity)proxyResponseOptional.get();
        String proxyResponseType = proxyResponse.getType();
        if (!proxyResponseType.equals(entityType)) {
            throw new EntityMismatchException(String.format(MISMATCH_EXCEPTION_STRING, proxyResponseType, entityType, entityId, proxyId));
        }
        externalProxy.setEntity(proxyResponse);
        this.handleDatasourceRedirections(externalProxy, proxyResponse);
        this.updateRights(externalProxy);
        externalProxy.getProxyIn().setModified(timestamp);
        return proxyResponse;
    }

    private void handleDatasourceRedirections(EntityProxy externalProxy, Entity proxyResponse) {
        if (!externalProxy.getProxyId().equals(proxyResponse.getEntityId())) {
            proxyResponse.addSameReferenceLink(externalProxy.getProxyId());
            if (logger.isDebugEnabled()) {
                logger.debug("Updating proxy id with the actual value from the external entity {} -> {}", (Object)externalProxy.getProxyId(), (Object)proxyResponse.getEntityId());
            }
            externalProxy.setProxyId(proxyResponse.getEntityId());
        }
    }

    protected void updateRights(EntityProxy externalProxy) {
        Optional dataSource = this.datasources.getDatasource(externalProxy.getProxyId());
        if (dataSource.isPresent() && this.hasChangedRights(externalProxy, (DataSource)dataSource.get())) {
            externalProxy.getProxyIn().setRights(((DataSource)dataSource.get()).getRights());
        }
    }

    boolean hasChangedRights(EntityProxy externalProxy, DataSource dataSource) {
        return !dataSource.getRights().equals(externalProxy.getProxyIn().getRights());
    }
}

