/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.model;

import eu.europeana.entitymanagement.exception.FunctionalRuntimeException;
import eu.europeana.entitymanagement.web.model.Operation;
import java.util.SortedSet;
import java.util.TreeSet;

public class BatchOperations {
    private SortedSet<Operation> createOperations = new TreeSet();
    private SortedSet<Operation> enableOperations = new TreeSet();
    private SortedSet<Operation> updateOperations = new TreeSet();
    private SortedSet<Operation> deleteOperations = new TreeSet();
    private SortedSet<Operation> permanentDeleteOperations = new TreeSet();

    public SortedSet<Operation> getCreateOperations() {
        return this.createOperations;
    }

    public SortedSet<Operation> getEnableOperations() {
        return this.enableOperations;
    }

    public SortedSet<Operation> getUpdateOperations() {
        return this.updateOperations;
    }

    public SortedSet<Operation> getDeleteOperations() {
        return this.deleteOperations;
    }

    public SortedSet<Operation> getPermanentDeleteOperations() {
        return this.permanentDeleteOperations;
    }

    public void addOperation(Operation operation) {
        switch (operation.getAction()) {
            case "create": {
                this.createOperations.add(operation);
                break;
            }
            case "enable": {
                this.enableOperations.add(operation);
                break;
            }
            case "update": {
                this.updateOperations.add(operation);
                break;
            }
            case "delete": {
                this.deleteOperations.add(operation);
                break;
            }
            case "perm_delete": {
                this.permanentDeleteOperations.add(operation);
                break;
            }
            default: {
                throw new FunctionalRuntimeException("Unsuported zoho sync operation: " + operation.getAction());
            }
        }
    }
}

