/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.config;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import eu.europeana.api.commons.config.i18n.I18nService;
import eu.europeana.api.commons.config.i18n.I18nServiceImpl;
import eu.europeana.api.commons.oauth2.service.impl.EuropeanaClientDetailsService;
import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.common.vocabulary.AppConfigConstants;
import eu.europeana.entitymanagement.config.DataSources;
import eu.europeana.entitymanagement.definitions.model.Vocabulary;
import eu.europeana.entitymanagement.exception.ApplicationInitializationException;
import eu.europeana.entitymanagement.mongo.repository.VocabularyRepository;
import eu.europeana.entitymanagement.web.MetisDereferenceUtils;
import eu.europeana.entitymanagement.web.xml.model.RdfXmlUtils;
import eu.europeana.entitymanagement.web.xml.model.XmlBaseEntityImpl;
import eu.europeana.entitymanagement.web.xml.model.XmlConceptImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.web.filter.ShallowEtagHeaderFilter;

@Configuration
public class AppAutoconfig
extends AppConfigConstants {
    private static final Logger LOG = LogManager.getLogger(AppAutoconfig.class);
    @Resource
    private EntityManagementConfiguration emConfiguration;
    @Resource(name="emXmlMapper")
    private XmlMapper xmlMapper;
    @Resource(name="emVocabularyRepo")
    private VocabularyRepository vocabRepository;
    @Resource
    protected JAXBContext jaxbContext;

    public AppAutoconfig() {
        LOG.info("Initializing EntityManagementConfiguration bean as: configuration");
    }

    @PostConstruct
    public void init() throws ApplicationInitializationException {
        String jwtTokenSignatureKey;
        if ((this.emConfiguration.isAuthReadEnabled() || this.emConfiguration.isAuthWriteEnabled()) && ((jwtTokenSignatureKey = this.emConfiguration.getApiKeyPublicKey()) == null || jwtTokenSignatureKey.isBlank())) {
            throw new IllegalStateException("The jwt token signature key cannot be null or empty.");
        }
        this.ensureDatabaseInitialization();
    }

    public void ensureDatabaseInitialization() throws ApplicationInitializationException {
        if (this.vocabRepository.countRecords() < 1L) {
            List xmlEntities;
            try {
                xmlEntities = MetisDereferenceUtils.parseMetisResponseMany((Unmarshaller)this.jaxbContext.createUnmarshaller(), (String)this.emConfiguration.loadRoleVocabulary());
            }
            catch (Exception e) {
                throw new ApplicationInitializationException("Cannot load vocabulary from resources!", (Throwable)e);
            }
            ArrayList<Vocabulary> roles = new ArrayList<Vocabulary>(xmlEntities.size());
            for (XmlBaseEntityImpl xmlEntity : xmlEntities) {
                XmlConceptImpl xmlConcept = (XmlConceptImpl)xmlEntity;
                Vocabulary vocab = new Vocabulary();
                vocab.setId(xmlConcept.getAbout());
                vocab.setInScheme(RdfXmlUtils.toStringList((List)xmlConcept.getInScheme()));
                vocab.setPrefLabel(RdfXmlUtils.toLanguageMap((List)xmlConcept.getPrefLabel()));
                roles.add(vocab);
            }
            this.vocabRepository.saveBulk(roles);
        }
    }

    @Bean(name={"emDataSources"})
    public DataSources getDataSources() throws IOException {
        DataSources dataSources;
        String datasourcesXMLConfigFile = this.emConfiguration.getDatasourcesXMLConfig();
        try (InputStream inputStream = this.getClass().getResourceAsStream(datasourcesXMLConfigFile);){
            assert (inputStream != null);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String contents = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                dataSources = (DataSources)this.xmlMapper.readValue(contents, DataSources.class);
            }
        }
        if (dataSources.getEuropeanaDatasource().isEmpty()) {
            throw new IllegalStateException(String.format("Datasource must be configured with id='%s' in %s", "europeana", datasourcesXMLConfigFile));
        }
        return dataSources;
    }

    @Bean(name={"clientDetailsService"})
    public EuropeanaClientDetailsService getClientDetailsService() {
        EuropeanaClientDetailsService clientDetailsService = new EuropeanaClientDetailsService();
        clientDetailsService.setApiKeyServiceUrl(this.emConfiguration.getApiKeyUrl());
        return clientDetailsService;
    }

    @Bean
    public ShallowEtagHeaderFilter shallowEtagHeaderFilter() {
        return new ShallowEtagHeaderFilter();
    }

    @Bean(name={"i18nService"})
    public I18nService i18nService() {
        return new I18nServiceImpl();
    }

    @Bean(name={"messageSource"})
    public MessageSource i18nMessagesSource() {
        ReloadableResourceBundleMessageSource source = new ReloadableResourceBundleMessageSource();
        source.setBasename("messages");
        source.setDefaultEncoding(StandardCharsets.UTF_8.name());
        return source;
    }
}

