/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.repository;

import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import dev.morphia.Datastore;
import dev.morphia.aggregation.stages.Lookup;
import dev.morphia.aggregation.stages.Projection;
import dev.morphia.aggregation.stages.Unwind;
import dev.morphia.query.FindOptions;
import dev.morphia.query.MorphiaCursor;
import dev.morphia.query.Sort;
import dev.morphia.query.filters.Filter;
import dev.morphia.query.filters.Filters;
import eu.europeana.entitymanagement.definitions.batch.EMBatchConstants;
import eu.europeana.entitymanagement.definitions.batch.model.FailedTask;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTask;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledUpdateType;
import eu.europeana.entitymanagement.mongo.utils.MorphiaUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;

@Repository
public class ScheduledTaskRepository
implements InitializingBean {
    private final Datastore datastore;

    @Autowired
    public ScheduledTaskRepository(@Qualifier(value="emDataStore") Datastore datastore) {
        this.datastore = datastore;
    }

    public void afterPropertiesSet() {
    }

    public BulkWriteResult markAsProcessed(@NonNull List<ScheduledTask> tasks) {
        ArrayList<UpdateOneModel> updates = new ArrayList<UpdateOneModel>(tasks.size());
        for (ScheduledTask task : tasks) {
            updates.add(new UpdateOneModel((Bson)new Document("entityId", (Object)task.getEntityId()).append("updateType", (Object)task.getUpdateType().getValue()), (Bson)new Document("$set", (Object)new Document("hasBeenProcessed", (Object)task.hasBeenProcessed()).append("modified", (Object)task.getModified()))));
        }
        return this.datastore.getCollection(ScheduledTask.class).bulkWrite(updates);
    }

    public BulkWriteResult upsertBulk(@NonNull List<ScheduledTask> tasks) {
        MongoCollection collection = this.datastore.getCollection(ScheduledTask.class);
        ArrayList<UpdateOneModel> updates = new ArrayList<UpdateOneModel>(tasks.size());
        for (ScheduledTask task : tasks) {
            boolean shouldChangeUpdateType;
            Document updateDoc = new Document("entityId", (Object)task.getEntityId()).append("hasBeenProcessed", (Object)task.hasBeenProcessed()).append("modified", (Object)task.getModified());
            Document setOnInsertDoc = new Document("created", (Object)task.getModified()).append("_t", (Object)EMBatchConstants.SCHEDULED_TASK_CLASSNAME);
            boolean bl = shouldChangeUpdateType = task.getUpdateType() == ScheduledUpdateType.FULL_UPDATE;
            if (shouldChangeUpdateType) {
                updateDoc.append("updateType", (Object)task.getUpdateType().getValue());
            } else {
                setOnInsertDoc.append("updateType", (Object)task.getUpdateType().getValue());
            }
            updates.add(new UpdateOneModel((Bson)new Document("entityId", (Object)task.getEntityId()), (Bson)new Document("$set", (Object)updateDoc).append("$setOnInsert", (Object)setOnInsertDoc), (UpdateOptions)MorphiaUtils.UPSERT_OPTS));
        }
        return collection.bulkWrite(updates);
    }

    public long removeProcessedTasks(List<? extends ScheduledTaskType> updateType) {
        return this.datastore.find(ScheduledTask.class).filter(new Filter[]{Filters.eq((String)"hasBeenProcessed", (Object)Boolean.TRUE), Filters.or((Filter[])((Filter[])updateType.stream().map(u -> Filters.eq((String)"updateType", (Object)u.getValue())).toArray(Filter[]::new)))}).delete(MorphiaUtils.MULTI_DELETE_OPTS).getDeletedCount();
    }

    public void deleteScheduledTasks(String entityId) {
        this.datastore.find(ScheduledTask.class).filter(new Filter[]{Filters.eq((String)"entityId", (Object)entityId)}).delete();
    }

    public List<ScheduledTask> getTasks(int start, int limit, Filter[] filters) {
        return this.datastore.find(ScheduledTask.class).filter(filters).iterator(new FindOptions().projection().include(new String[]{"entityId", "updateType"}).skip(start).sort(new Sort[]{Sort.ascending((String)"created"), Sort.ascending((String)"entityId")}).limit(limit)).toList();
    }

    public ScheduledTask getTask(String entityId) {
        return (ScheduledTask)this.datastore.find(ScheduledTask.class).filter(new Filter[]{Filters.eq((String)"entityId", (Object)entityId)}).first();
    }

    public long getRuningTasksCount() {
        return this.datastore.find(ScheduledTask.class).filter(new Filter[]{Filters.eq((String)"hasBeenProcessed", (Object)Boolean.FALSE)}).count();
    }

    public List<ScheduledTask> getTasks(List<String> entityIds) {
        return this.datastore.find(ScheduledTask.class).filter(new Filter[]{Filters.in((String)"entityId", entityIds)}).iterator().toList();
    }

    public void dropCollection() {
        this.datastore.getCollection(ScheduledTask.class).drop();
    }

    public MorphiaCursor<ScheduledTask> getTasksWithFailures(int maxFailedTaskRetries, List<? extends ScheduledTaskType> updateType) {
        return this.datastore.aggregate(ScheduledTask.class).match(new Filter[]{Filters.eq((String)"hasBeenProcessed", (Object)Boolean.FALSE), Filters.in((String)"updateType", (Iterable)updateType.stream().map(ScheduledTaskType::getValue).collect(Collectors.toList()))}).lookup(Lookup.from(FailedTask.class).localField("entityId").foreignField("entityId").as("failed_tasks_lookup")).unwind(Unwind.on((String)"failed_tasks_lookup")).match(new Filter[]{Filters.gte((String)"failed_tasks_lookup.failureCount", (Object)maxFailedTaskRetries)}).project(Projection.of().include("entityId")).execute(ScheduledTask.class);
    }
}

