/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.config;

import dev.morphia.Datastore;
import eu.europeana.batch.config.MongoBatchConfigurer;
import javax.annotation.Resource;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.task.TaskExecutor;

@Configuration
public class JobLauncherConfig {
    private final TaskExecutor synchronousWebRequestExecutor;
    private final TaskExecutor deletionsTaskExecutor;
    @Resource(name="scheduledUpdateTaskExecutor")
    private TaskExecutor defaultTaskExecutor;
    @Resource(name="batchMongoConfigurer")
    private MongoBatchConfigurer mongoBatchConfigurer;

    public JobLauncherConfig(@Qualifier(value="webRequestTaskExecutor") TaskExecutor webRequestJobExecutor, @Qualifier(value="scheduledRemovalTaskExecutor") TaskExecutor deletionsTaskExecutor) {
        this.synchronousWebRequestExecutor = webRequestJobExecutor;
        this.deletionsTaskExecutor = deletionsTaskExecutor;
    }

    public JobLauncher defaultJobLauncher() throws Exception {
        return this.mongoBatchConfigurer.getJobLauncher();
    }

    @Bean(name={"entityUpdateJobLauncher"})
    @Primary
    public JobLauncher entityUpdateJobLauncher() throws Exception {
        return this.defaultJobLauncher();
    }

    @Bean(value={"entityRemovalsJobLauncher"})
    public JobLauncher entityDeletionJobLauncher() throws Exception {
        SimpleJobLauncher jobLauncher = new SimpleJobLauncher();
        jobLauncher.setJobRepository(this.mongoBatchConfigurer.getJobRepository());
        jobLauncher.setTaskExecutor(this.deletionsTaskExecutor);
        jobLauncher.afterPropertiesSet();
        return jobLauncher;
    }

    @Bean(name={"synchronousWebRequestJobLauncher"})
    public JobLauncher synchronousJobLauncher() throws Exception {
        SimpleJobLauncher jobLauncher = new SimpleJobLauncher();
        jobLauncher.setJobRepository(this.mongoBatchConfigurer.getJobRepository());
        jobLauncher.setTaskExecutor(this.synchronousWebRequestExecutor);
        jobLauncher.afterPropertiesSet();
        return jobLauncher;
    }

    @Bean(name={"batchMongoConfigurer"})
    public MongoBatchConfigurer mongoBatchConfigurer(@Qualifier(value="batchDataStore") Datastore datastore) {
        return new MongoBatchConfigurer(datastore, this.defaultTaskExecutor);
    }
}

