/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.config;

import dev.morphia.query.filters.Filter;
import dev.morphia.query.filters.Filters;
import eu.europeana.entitymanagement.batch.listener.EntityUpdateStepListener;
import eu.europeana.entitymanagement.batch.listener.ScheduledTaskItemListener;
import eu.europeana.entitymanagement.batch.processor.EntityConsolidationProcessor;
import eu.europeana.entitymanagement.batch.processor.EntityDereferenceProcessor;
import eu.europeana.entitymanagement.batch.processor.EntityMetricsProcessor;
import eu.europeana.entitymanagement.batch.processor.EntityVerificationLogger;
import eu.europeana.entitymanagement.batch.reader.EntityRecordDatabaseReader;
import eu.europeana.entitymanagement.batch.reader.ScheduledTaskDatabaseReader;
import eu.europeana.entitymanagement.batch.service.FailedTaskService;
import eu.europeana.entitymanagement.batch.service.ScheduledTaskService;
import eu.europeana.entitymanagement.batch.utils.BatchUtils;
import eu.europeana.entitymanagement.batch.writer.EntityRecordDatabaseDeprecationWriter;
import eu.europeana.entitymanagement.batch.writer.EntityRecordDatabaseInsertionWriter;
import eu.europeana.entitymanagement.batch.writer.EntityRecordDatabaseRemovalWriter;
import eu.europeana.entitymanagement.batch.writer.EntitySolrInsertionWriter;
import eu.europeana.entitymanagement.batch.writer.EntitySolrRemovalWriter;
import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.definitions.batch.model.BatchEntityRecord;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledRemovalType;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledUpdateType;
import eu.europeana.entitymanagement.web.service.EntityRecordService;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStreamReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.support.CompositeItemProcessor;
import org.springframework.batch.item.support.CompositeItemWriter;
import org.springframework.batch.item.support.SynchronizedItemStreamReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

@Component
@EnableBatchProcessing
public class EntityUpdateJobConfig {
    private static final String SINGLE_ENTITY_RECORD_READER = "singleEntityRecordReader";
    private static final String SCHEDULED_TASK_READER = "scheduledTaskReader";
    private final JobBuilderFactory jobBuilderFactory;
    private final StepBuilderFactory stepBuilderFactory;
    private final ItemReader<BatchEntityRecord> singleEntityRecordReader;
    private final ItemReader<BatchEntityRecord> scheduledTaskReader;
    private final EntityDereferenceProcessor dereferenceProcessor;
    private final EntityConsolidationProcessor entityUpdateProcessor;
    private final EntityVerificationLogger entityVerificationLogger;
    private final EntityMetricsProcessor entityMetricsProcessor;
    private final EntityVerificationLogger verificationLogger;
    private final EntityRecordDatabaseInsertionWriter dbInsertionWriter;
    private final EntitySolrInsertionWriter solrInsertionWriter;
    private final EntitySolrRemovalWriter solrRemovalWriter;
    private final EntityRecordDatabaseRemovalWriter dbRemovalWriter;
    private final EntityRecordDatabaseDeprecationWriter dbDeprecationWriter;
    private final EntityRecordService entityRecordService;
    private final ScheduledTaskService scheduledTaskService;
    private final FailedTaskService failedTaskService;
    private final ScheduledTaskItemListener itemListener;
    private final TaskExecutor updatesStepExecutor;
    private final TaskExecutor removalsStepExecutor;
    private final TaskExecutor synchronousTaskExecutor;
    private final int configuredBatchChunkSize;
    private final int updatesThrottleLimit;
    private final int removalsThrottleLimit;
    private final int maxFailedTaskRetries;
    private final SkipPolicy noopSkipPolicy = (t, skipCount) -> true;

    @Autowired
    public EntityUpdateJobConfig(JobBuilderFactory jobBuilderFactory, StepBuilderFactory stepBuilderFactory, @Qualifier(value="singleEntityRecordReader") ItemReader<BatchEntityRecord> singleEntityRecordReader, @Qualifier(value="scheduledTaskReader") ItemReader<BatchEntityRecord> scheduledTaskReader, EntityDereferenceProcessor dereferenceProcessor, EntityConsolidationProcessor entityUpdateProcessor, EntityVerificationLogger entityVerificationLogger, EntityMetricsProcessor entityMetricsProcessor, EntityVerificationLogger verificationLogger, EntityRecordDatabaseInsertionWriter dbInsertionWriter, EntitySolrInsertionWriter solrInsertionWriter, EntitySolrRemovalWriter solrRemovalWriter, EntityRecordDatabaseRemovalWriter dbRemovalWriter, EntityRecordDatabaseDeprecationWriter dbDeprecationWriter, EntityRecordService entityRecordService, ScheduledTaskService scheduledTaskService, FailedTaskService failedTaskService, ScheduledTaskItemListener itemListener, @Qualifier(value="updatesStepExecutor") TaskExecutor updatesStepExecutor, @Qualifier(value="removalsStepExecutor") TaskExecutor removalsStepExecutor, @Qualifier(value="webRequestTaskExecutor") TaskExecutor synchronousTaskExecutor, EntityManagementConfiguration emConfig) {
        this.jobBuilderFactory = jobBuilderFactory;
        this.stepBuilderFactory = stepBuilderFactory;
        this.singleEntityRecordReader = singleEntityRecordReader;
        this.scheduledTaskReader = scheduledTaskReader;
        this.dereferenceProcessor = dereferenceProcessor;
        this.entityUpdateProcessor = entityUpdateProcessor;
        this.entityVerificationLogger = entityVerificationLogger;
        this.entityMetricsProcessor = entityMetricsProcessor;
        this.verificationLogger = verificationLogger;
        this.dbInsertionWriter = dbInsertionWriter;
        this.solrInsertionWriter = solrInsertionWriter;
        this.solrRemovalWriter = solrRemovalWriter;
        this.dbRemovalWriter = dbRemovalWriter;
        this.dbDeprecationWriter = dbDeprecationWriter;
        this.entityRecordService = entityRecordService;
        this.scheduledTaskService = scheduledTaskService;
        this.failedTaskService = failedTaskService;
        this.itemListener = itemListener;
        this.updatesStepExecutor = updatesStepExecutor;
        this.removalsStepExecutor = removalsStepExecutor;
        this.synchronousTaskExecutor = synchronousTaskExecutor;
        this.configuredBatchChunkSize = emConfig.getBatchChunkSize();
        this.updatesThrottleLimit = emConfig.getBatchUpdatesThrottleLimit();
        this.removalsThrottleLimit = emConfig.getBatchRemovalsThrottleLimit();
        this.maxFailedTaskRetries = emConfig.getMaxFailedTaskRetries();
    }

    private <T> SynchronizedItemStreamReader<T> threadSafeReader(ItemStreamReader<T> reader) {
        SynchronizedItemStreamReader synchronizedItemStreamReader = new SynchronizedItemStreamReader();
        synchronizedItemStreamReader.setDelegate(reader);
        return synchronizedItemStreamReader;
    }

    @Bean(name={"singleEntityRecordReader"})
    @StepScope
    private EntityRecordDatabaseReader singleEntityRecordReader(@Value(value="#{jobParameters[entityId]}") String entityIdString, @Value(value="#{jobParameters[updateType]}") String updateType) {
        return new EntityRecordDatabaseReader(updateType, this.entityRecordService, this.configuredBatchChunkSize, new Filter[]{Filters.eq((String)"entityId", (Object)entityIdString)});
    }

    @Bean(name={"scheduledTaskReader"})
    @StepScope
    private SynchronizedItemStreamReader<BatchEntityRecord> scheduledTaskReader(@Value(value="#{jobParameters[currentStartTime]}") Date currentStartTime, @Value(value="#{jobParameters[updateType]}") String updateType) {
        List updateTypeList = Stream.of(updateType.split(",")).map(String::trim).collect(Collectors.toList());
        ScheduledTaskDatabaseReader reader = new ScheduledTaskDatabaseReader(this.scheduledTaskService, this.entityRecordService, this.configuredBatchChunkSize, new Filter[]{Filters.lte((String)"created", (Object)currentStartTime), Filters.in((String)"updateType", updateTypeList)});
        return this.threadSafeReader((ItemStreamReader)reader);
    }

    @Bean
    @StepScope
    private ScheduledTaskItemListener entityUpdateListener(@Value(value="#{jobParameters[isSynchronous]}") String isSynchronousString) {
        return new ScheduledTaskItemListener(this.failedTaskService, this.scheduledTaskService, Boolean.parseBoolean(isSynchronousString));
    }

    private StepExecutionListener stepExecutionListener(List<? extends ScheduledTaskType> updateType, boolean isSynchronous) {
        return new EntityUpdateStepListener(this.scheduledTaskService, updateType, isSynchronous, this.maxFailedTaskRetries);
    }

    @Bean
    private ItemProcessor<BatchEntityRecord, BatchEntityRecord> compositeUpdateProcessor() {
        CompositeItemProcessor compositeItemProcessor = new CompositeItemProcessor();
        compositeItemProcessor.setDelegates(Arrays.asList(this.dereferenceProcessor, this.entityUpdateProcessor, this.entityMetricsProcessor, this.entityVerificationLogger));
        return compositeItemProcessor;
    }

    private ItemWriter<BatchEntityRecord> compositeEntityInsertionWriter() {
        CompositeItemWriter compositeWriter = new CompositeItemWriter();
        compositeWriter.setDelegates(Arrays.asList(this.dbInsertionWriter, this.solrInsertionWriter));
        return compositeWriter;
    }

    private ItemWriter<BatchEntityRecord> compositeEntityDeprecationDeletionWriter() {
        CompositeItemWriter compositeWriter = new CompositeItemWriter();
        compositeWriter.setDelegates(Arrays.asList(this.dbDeprecationWriter, this.dbRemovalWriter, this.solrRemovalWriter));
        return compositeWriter;
    }

    private Step updateEntity(List<ScheduledUpdateType> updateType, boolean isSynchronous) {
        ItemReader reader = isSynchronous ? this.singleEntityRecordReader : this.scheduledTaskReader;
        TaskExecutor executor = isSynchronous ? this.synchronousTaskExecutor : this.updatesStepExecutor;
        int chunkSize = isSynchronous ? 1 : this.configuredBatchChunkSize;
        SimpleStepBuilder step = this.stepBuilderFactory.get(BatchUtils.STEP_UPDATE_ENTITY).chunk(chunkSize).reader(reader);
        step.processor(this.compositeUpdateProcessor());
        return ((AbstractTaskletStepBuilder)step.writer(this.compositeEntityInsertionWriter()).listener((ItemProcessListener)this.itemListener).faultTolerant().skipPolicy(this.noopSkipPolicy).taskExecutor(executor).throttleLimit(this.updatesThrottleLimit).listener(this.stepExecutionListener(updateType, isSynchronous))).build();
    }

    private Step removeEntity(List<ScheduledRemovalType> removalType, int chunkSize, TaskExecutor executor, ItemReader<BatchEntityRecord> reader) {
        SimpleStepBuilder step = this.stepBuilderFactory.get(BatchUtils.STEP_REMOVE_ENTITY).chunk(chunkSize).reader(reader);
        step.writer(this.compositeEntityDeprecationDeletionWriter());
        return ((AbstractTaskletStepBuilder)step.listener((ItemProcessListener)this.itemListener).faultTolerant().skipPolicy(this.noopSkipPolicy).taskExecutor(executor).throttleLimit(this.removalsThrottleLimit).listener(this.stepExecutionListener(removalType, false))).build();
    }

    public Job updateSingleEntity() {
        return ((JobBuilder)this.jobBuilderFactory.get(BatchUtils.JOB_UPDATE_SINGLE_ENTITY).incrementer((JobParametersIncrementer)new RunIdIncrementer())).start(this.updateEntity(List.of(ScheduledUpdateType.FULL_UPDATE), true)).build();
    }

    public Job updateScheduledEntities(List<ScheduledUpdateType> updateType) {
        return this.jobBuilderFactory.get(BatchUtils.JOB_UPDATE_SCHEDULED_ENTITIES).start(this.updateEntity(updateType, false)).build();
    }

    public Job removeScheduledEntities(List<ScheduledRemovalType> removalType) {
        return this.jobBuilderFactory.get(BatchUtils.JOB_REMOVE_SCHEDULED_ENTITIES).start(this.removeEntity(removalType, this.configuredBatchChunkSize, this.removalsStepExecutor, this.scheduledTaskReader)).build();
    }

    EntityVerificationLogger getVerificationLogger() {
        return this.verificationLogger;
    }
}

