/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.service;

import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.result.UpdateResult;
import eu.europeana.entitymanagement.batch.repository.FailedTaskRepository;
import eu.europeana.entitymanagement.definitions.batch.model.FailedTask;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FailedTaskService {
    private final FailedTaskRepository failureRepository;
    private static final Logger logger = LogManager.getLogger(FailedTaskService.class);

    @Autowired
    public FailedTaskService(FailedTaskRepository failureRepository) {
        this.failureRepository = failureRepository;
    }

    public void persistFailure(String entityId, ScheduledTaskType updateType, Exception e) {
        UpdateResult result = this.failureRepository.upsert(this.createUpdateFailure(entityId, updateType, Instant.now(), e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)));
        logger.debug("Persisted update failure to db. entityId={} matched={}, modified={}", (Object)entityId, (Object)result.getMatchedCount(), (Object)result.getModifiedCount());
    }

    public void persistFailureBulk(Map<String, ScheduledTaskType> entityIdsToUpdateType, Exception e) {
        String message = e.getMessage();
        String stackTrace = ExceptionUtils.getStackTrace((Throwable)e);
        Instant now = Instant.now();
        List failures = entityIdsToUpdateType.entrySet().stream().map(r -> this.createUpdateFailure((String)r.getKey(), (ScheduledTaskType)r.getValue(), now, message, stackTrace)).collect(Collectors.toList());
        BulkWriteResult writeResult = this.failureRepository.upsertBulk(failures);
        logger.debug("Persisted update failures to db: matched={}, modified={}, inserted={}", (Object)writeResult.getMatchedCount(), (Object)writeResult.getModifiedCount(), (Object)writeResult.getInsertedCount());
    }

    public void removeFailures(List<String> entityIds) {
        long removeCount = this.failureRepository.removeFailures(entityIds);
        if (removeCount > 0L) {
            logger.debug("Removed update failures from db: count={}", (Object)removeCount);
        }
    }

    public List<String> getEntityIdsWithFailures(int start, int count) {
        return this.failureRepository.getEntityIdsWithFailures(start, count);
    }

    public void dropCollection() {
        this.failureRepository.dropCollection();
    }

    public Optional<FailedTask> getFailure(String entityId) {
        return Optional.ofNullable(this.failureRepository.getFailure(entityId));
    }

    public List<FailedTask> getFailures(List<String> entityIds) {
        return this.failureRepository.getFailures(entityIds);
    }

    private FailedTask createUpdateFailure(String entityId, ScheduledTaskType updateType, Instant modified, String message, String stacktrace) {
        return new FailedTask.Builder(entityId, updateType).modified(modified).message(message).stackTrace(stacktrace).build();
    }
}

