/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.listener;

import eu.europeana.entitymanagement.batch.service.ScheduledTaskService;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.lang.NonNull;

public class EntityUpdateStepListener
implements StepExecutionListener {
    private static final Logger logger = LogManager.getLogger(EntityUpdateStepListener.class);
    private final ScheduledTaskService scheduledTaskService;
    private final List<? extends ScheduledTaskType> updateType;
    private final int maxFailedTaskRetries;
    private final boolean isSynchronous;

    public EntityUpdateStepListener(ScheduledTaskService scheduledTaskService, List<? extends ScheduledTaskType> updateType, boolean isSynchronous, int maxFailedTaskRetries) {
        this.scheduledTaskService = scheduledTaskService;
        this.updateType = updateType;
        this.isSynchronous = isSynchronous;
        this.maxFailedTaskRetries = maxFailedTaskRetries;
    }

    public void beforeStep(@NonNull StepExecution stepExecution) {
        if (!this.isSynchronous) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cleaning up processed tasks before step execution. updateType={}", (Object)this.updateType.stream().map(ScheduledTaskType::getValue).collect(Collectors.joining(",")));
            }
            this.scheduledTaskService.removeProcessedTasks(this.updateType);
        }
    }

    public ExitStatus afterStep(@NonNull StepExecution stepExecution) {
        if (this.isSynchronous) {
            return ExitStatus.NOOP;
        }
        this.scheduledTaskService.removeScheduledTasksWithFailures(this.maxFailedTaskRetries, this.updateType);
        return ExitStatus.COMPLETED;
    }
}

