/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.service;

import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.definitions.model.WebResource;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
public class DepictionGeneratorService {
    private final WebClient webClient;
    EntityManagementConfiguration configuration;

    public DepictionGeneratorService(EntityManagementConfiguration configuration) {
        this.configuration = configuration;
        this.webClient = WebClient.builder().build();
    }

    public WebResource generateIsShownBy(String entityUri) throws EuropeanaApiException {
        String uri = this.buildSearchRequestUrl(entityUri);
        String response = null;
        try {
            response = (String)this.webClient.get().uri(uri, new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().bodyToMono(String.class).block();
        }
        catch (Exception e) {
            throw new EuropeanaApiException("Unable to get the valid response from the Search and Record API.", (Throwable)e);
        }
        if (response == null) {
            return null;
        }
        JSONObject responseJson = new JSONObject(response);
        String edmIsShownBy = null;
        String itemId = null;
        String edmPreview = null;
        if (!responseJson.has("items")) {
            return null;
        }
        JSONArray itemsList = responseJson.getJSONArray("items");
        if (itemsList.length() <= 0) {
            return null;
        }
        JSONObject item = (JSONObject)itemsList.get(0);
        edmIsShownBy = this.getIsShownBy(item);
        if (item.has("id")) {
            itemId = item.getString("id");
        }
        edmPreview = this.getEdmPreview(item);
        return new WebResource(edmIsShownBy, this.configuration.getItemDataEndpoint() + itemId, edmPreview);
    }

    String getEdmPreview(JSONObject item) {
        JSONArray edmPreviewList;
        if (item.has("edmPreview") && (edmPreviewList = item.getJSONArray("edmPreview")).length() > 0) {
            return edmPreviewList.getString(0);
        }
        return null;
    }

    String getIsShownBy(JSONObject item) {
        JSONArray edmIsShownByList;
        if (item.has("edmIsShownBy") && (edmIsShownByList = item.getJSONArray("edmIsShownBy")).length() > 0) {
            return edmIsShownByList.getString(0);
        }
        return null;
    }

    String buildSearchRequestUrl(String entityUri) {
        StringBuilder url = new StringBuilder(this.configuration.getSearchApiUrlPrefix());
        url.append("&query=\"").append(entityUri).append("\" AND provider_aggregation_edm_isShownBy:*").append("&sort=contentTier+desc,metadataTier+desc").append("&profile=minimal").append("&rows=1");
        return url.toString();
    }
}

