/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.reader;

import dev.morphia.query.filters.Filter;
import eu.europeana.entitymanagement.batch.reader.BaseDatabaseReader;
import eu.europeana.entitymanagement.batch.service.ScheduledTaskService;
import eu.europeana.entitymanagement.definitions.batch.model.BatchEntityRecord;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTask;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.vocabulary.EntityProfile;
import eu.europeana.entitymanagement.web.service.EntityRecordService;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.NonNull;

public class ScheduledTaskDatabaseReader
extends BaseDatabaseReader<BatchEntityRecord> {
    private static final Logger logger = LogManager.getLogger(ScheduledTaskDatabaseReader.class);
    private final ScheduledTaskService scheduledTaskService;
    private final EntityRecordService entityRecordService;
    private final Filter[] scheduledTaskFilter;

    public ScheduledTaskDatabaseReader(ScheduledTaskService scheduledTaskService, EntityRecordService entityRecordService, int pageSize, Filter ... scheduledTaskFilter) {
        super(pageSize);
        this.scheduledTaskService = scheduledTaskService;
        this.entityRecordService = entityRecordService;
        this.scheduledTaskFilter = scheduledTaskFilter;
    }

    @NonNull
    protected Iterator<BatchEntityRecord> doPageRead() {
        int start = this.page * this.pageSize;
        List<ScheduledTask> scheduledTasks = this.scheduledTaskService.getTasks(start, this.pageSize, this.scheduledTaskFilter);
        List<String> entityIds = scheduledTasks.stream().map(st -> st.getEntityId()).toList();
        List<EntityRecord> records = this.entityRecordService.retrieveMultipleByEntityIds(entityIds, false, true, EntityProfile.dereference.name());
        List<BatchEntityRecord> batchRecords = this.toBatchEntityRecords(records, scheduledTasks);
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved {} scheduled entities from database. skip={}, limit={}, entityIds={}", (Object)batchRecords.size(), (Object)start, (Object)this.pageSize, entityIds);
        }
        return batchRecords.iterator();
    }

    @Override
    String getClassName() {
        return ScheduledTaskDatabaseReader.class.getSimpleName();
    }
}

