/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement;

import eu.europeana.entitymanagement.batch.model.JobType;
import eu.europeana.entitymanagement.batch.service.BatchEntityUpdateExecutor;
import eu.europeana.entitymanagement.batch.service.ScheduledTaskService;
import eu.europeana.entitymanagement.exception.ingestion.EntityUpdateException;
import eu.europeana.entitymanagement.web.model.ZohoSyncReport;
import eu.europeana.entitymanagement.web.service.ZohoSyncService;
import java.time.Duration;
import java.util.Arrays;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.actuate.autoconfigure.security.servlet.ManagementWebSecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

@SpringBootApplication(scanBasePackages={"eu.europeana.entitymanagement"}, exclude={SecurityAutoConfiguration.class, ManagementWebSecurityAutoConfiguration.class, DataSourceAutoConfiguration.class})
public class EntityManagementApp
implements CommandLineRunner {
    private static final Logger LOG = LogManager.getLogger(EntityManagementApp.class);
    private static final int WAITING_INTREVAL = 5;
    @Autowired
    private BatchEntityUpdateExecutor batchUpdateExecutor;
    @Autowired
    private ZohoSyncService zohoSyncService;

    public static void main(String[] args) {
        ConfigurableApplicationContext context;
        if (EntityManagementApp.isScheduledTask(args)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Starting batch updates execution with args: {}", (Object)Arrays.toString(args));
            }
            EntityManagementApp.validateArguments(args);
            context = EntityManagementApp.startStandAlloneApp(args);
            if (LOG.isInfoEnabled()) {
                LOG.info("Batch scheduling was completed for {}, waiting for completion of asynchonuous processing ", (Object)Arrays.toString(args));
            }
            ScheduledTaskService scheduledTaskService = EntityManagementApp.getScheduledTasksService(context);
            long notCompletedTasks = 0L;
            boolean processingComplete = false;
            do {
                long currentRunningTasks = scheduledTaskService.getRunningTasksCount();
                if (LOG.isInfoEnabled()) {
                    LOG.info("Scheduled Tasks to process : before {}, after {}", (Object)notCompletedTasks, (Object)currentRunningTasks);
                }
                if (currentRunningTasks == 0L || currentRunningTasks == notCompletedTasks) {
                    processingComplete = true;
                } else {
                    processingComplete = false;
                    notCompletedTasks = currentRunningTasks;
                }
                try {
                    Thread.sleep(Duration.ofMinutes(5L).toMillis());
                }
                catch (InterruptedException e) {
                    LOG.error("Cannot complete execution!", (Throwable)e);
                    SpringApplication.exit((ApplicationContext)context, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
                    System.exit(-2);
                }
            } while (!processingComplete);
        } else {
            LOG.info("No args provided to application. Starting web server");
            SpringApplication.run(EntityManagementApp.class, (String[])args);
            return;
        }
        LOG.info("Stoping application after processing all Schdeduled Tasks!");
        System.exit(SpringApplication.exit((ApplicationContext)context, (ExitCodeGenerator[])new ExitCodeGenerator[0]));
    }

    static boolean isScheduledTask(String[] args) {
        return EntityManagementApp.hasCmdLineParams(args);
    }

    static ScheduledTaskService getScheduledTasksService(ConfigurableApplicationContext context) {
        return (ScheduledTaskService)context.getBean("batchScheduledTaskService");
    }

    static ConfigurableApplicationContext startStandAlloneApp(String[] args) {
        return new SpringApplicationBuilder(new Class[]{EntityManagementApp.class}).web(WebApplicationType.NONE).run(args);
    }

    static boolean hasCmdLineParams(String[] args) {
        return args != null && args.length > 0;
    }

    public void run(String ... args) throws Exception {
        if (EntityManagementApp.isScheduledTask(args)) {
            this.runScheduledTasks(args);
        }
    }

    void runScheduledTasks(String ... args) throws EntityUpdateException {
        Set<String> tasks = Set.of(args);
        if (tasks.contains(JobType.ZOHO_SYNC.value())) {
            LOG.info("Executing zoho sync");
            ZohoSyncReport zohoSyncReport = this.zohoSyncService.synchronizeModifiedZohoOrganizations();
            LOG.info("Synchronization Report: {}", (Object)zohoSyncReport.toString());
        }
        if (tasks.contains(JobType.SCHEDULE_DELETION.value())) {
            LOG.info("Executing scheduled deletions");
            this.batchUpdateExecutor.runScheduledDeprecationsAndDeletions();
        }
        if (tasks.contains(JobType.SCHEDULE_UPDATE.value())) {
            LOG.info("Executing scheduled updates");
            this.batchUpdateExecutor.runScheduledUpdate();
        }
    }

    private static void validateArguments(String[] args) {
        for (String arg : args) {
            if (JobType.isValidJobType(arg)) continue;
            String allowdJobTypes = JobType.values().toString();
            LOG.error("Unsupported argument '{}'. Supported arguments are '{}'", (Object)arg, (Object)allowdJobTypes);
            System.exit(1);
        }
    }
}

