/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.service;

import com.mongodb.client.result.UpdateResult;
import dev.morphia.query.filters.Filter;
import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.entitymanagement.common.config.DataSource;
import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.config.DataSources;
import eu.europeana.entitymanagement.definitions.exceptions.EntityModelCreationException;
import eu.europeana.entitymanagement.definitions.exceptions.UnsupportedEntityTypeException;
import eu.europeana.entitymanagement.definitions.model.Agent;
import eu.europeana.entitymanagement.definitions.model.Aggregation;
import eu.europeana.entitymanagement.definitions.model.Concept;
import eu.europeana.entitymanagement.definitions.model.ConceptScheme;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.EntityProxy;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.definitions.model.Organization;
import eu.europeana.entitymanagement.definitions.model.Place;
import eu.europeana.entitymanagement.definitions.model.TimeSpan;
import eu.europeana.entitymanagement.definitions.model.ZohoLabelUriMapping;
import eu.europeana.entitymanagement.definitions.web.EntityIdDisabledStatus;
import eu.europeana.entitymanagement.exception.EntityAlreadyExistsException;
import eu.europeana.entitymanagement.exception.EntityCreationException;
import eu.europeana.entitymanagement.exception.EntityNotFoundException;
import eu.europeana.entitymanagement.exception.EntityRemovedException;
import eu.europeana.entitymanagement.exception.HttpBadRequestException;
import eu.europeana.entitymanagement.exception.HttpUnprocessableException;
import eu.europeana.entitymanagement.exception.MultipleChoicesException;
import eu.europeana.entitymanagement.exception.ingestion.EntityUpdateException;
import eu.europeana.entitymanagement.mongo.repository.EntityRecordRepository;
import eu.europeana.entitymanagement.mongo.repository.VocabularyRepository;
import eu.europeana.entitymanagement.solr.SolrUtils;
import eu.europeana.entitymanagement.solr.exception.SolrServiceException;
import eu.europeana.entitymanagement.solr.service.SolrService;
import eu.europeana.entitymanagement.utils.EntityObjectFactory;
import eu.europeana.entitymanagement.utils.EntityRecordUtils;
import eu.europeana.entitymanagement.utils.EntityUtils;
import eu.europeana.entitymanagement.vocabulary.EntityProfile;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import eu.europeana.entitymanagement.web.service.BaseEntityRecordService;
import eu.europeana.entitymanagement.zoho.organization.ZohoConfiguration;
import eu.europeana.entitymanagement.zoho.utils.WikidataUtils;
import eu.europeana.entitymanagement.zoho.utils.ZohoException;
import eu.europeana.entitymanagement.zoho.utils.ZohoUtils;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="emEntityRecordService")
public class EntityRecordService
extends BaseEntityRecordService {
    @Autowired
    public EntityRecordService(EntityRecordRepository entityRecordRepository, VocabularyRepository vocabRepository, EntityManagementConfiguration emConfiguration, ZohoConfiguration zohoConfiguration, DataSources datasources, SolrService solrService) {
        super(entityRecordRepository, vocabRepository, emConfiguration, zohoConfiguration, datasources, solrService);
    }

    public boolean existsByEntityId(String entityId) {
        return this.entityRecordRepository.existsByEntityId(entityId);
    }

    private Optional<EntityRecord> retrieveByEntityId(String entityId) {
        return Optional.ofNullable(this.entityRecordRepository.findByEntityId(entityId, null));
    }

    public List<EntityRecord> retrieveMultipleByEntityIds(List<String> entityIds, boolean excludeDisabled, boolean fetchFullRecord, String profiles) {
        List resp = this.entityRecordRepository.findByEntityIds(entityIds, excludeDisabled, fetchFullRecord);
        if (fetchFullRecord && !resp.isEmpty()) {
            for (EntityRecord record : resp) {
                this.postProcessOrganizationRetrieval(profiles, record);
            }
        }
        return resp;
    }

    public List<EntityRecord> retrieveMultipleByEntityIdsOrCoreference(List<String> entityIds, String profiles) {
        List records = this.entityRecordRepository.findByEntityIdsOrCoreference(entityIds);
        ArrayList<EntityRecord> recordsSorted = new ArrayList<EntityRecord>();
        HashSet<String> foundIds = new HashSet<String>(entityIds.size());
        for (String id : entityIds) {
            Optional<EntityRecord> recordIdMatched = records.stream().filter(er -> id.equals(er.getEntityId()) || er.getEntity().getSameReferenceLinks().contains(id)).findFirst();
            if (!recordIdMatched.isPresent() || foundIds.contains(recordIdMatched.get().getEntityId())) continue;
            EntityRecord foundRecord = recordIdMatched.get();
            recordsSorted.add(foundRecord);
            this.postProcessOrganizationRetrieval(profiles, foundRecord);
            foundIds.add(foundRecord.getEntityId());
        }
        return recordsSorted;
    }

    public EntityRecord retrieveEntityRecord(EntityTypes type, String identifier, String profiles, boolean retrieveDisabled) throws EuropeanaApiException {
        String entityUri = EntityRecordUtils.buildEntityIdUri((EntityTypes)type, (String)identifier);
        return this.retrieveEntityRecord(entityUri, profiles, retrieveDisabled);
    }

    public EntityRecord retrieveEntityRecord(String entityUri, String profiles, boolean retrieveDisabled) throws EntityNotFoundException, EntityRemovedException {
        Optional<EntityRecord> entityRecordOpt = this.retrieveByEntityId(entityUri);
        if (entityRecordOpt.isEmpty()) {
            throw new EntityNotFoundException(entityUri);
        }
        EntityRecord entityRecord = entityRecordOpt.get();
        if (!retrieveDisabled && entityRecord.isDisabled()) {
            throw new EntityRemovedException(String.format("Entity '%s' has been removed", entityUri));
        }
        this.postProcessOrganizationRetrieval(profiles, entityRecord);
        return entityRecord;
    }

    void postProcessOrganizationRetrieval(String profiles, EntityRecord entityRecord) {
        if (EntityTypes.isOrganization((String)entityRecord.getEntity().getType())) {
            Organization org = (Organization)entityRecord.getEntity();
            if (EntityProfile.hasDereferenceProfile((String)profiles)) {
                this.dereferenceLinkedEntities(org);
            }
        }
    }

    public void dereferenceLinkedEntities(Organization org) {
        if (org.getCountryId() != null) {
            EntityRecord countryRecord = this.entityRecordRepository.findByEntityId(org.getCountryId(), new String[]{"entity"});
            this.setDereferencedCountry(org, countryRecord);
            ZohoLabelUriMapping mapping = (ZohoLabelUriMapping)this.emConfiguration.getCountryIdMappings().get(org.getCountryId());
            if (mapping != null) {
                org.setCountryISO(mapping.getCountryISOCode());
            }
        }
        if (org.getEuropeanaRoleIds() != null && !org.getEuropeanaRoleIds().isEmpty()) {
            org.setEuropeanaRole(this.vocabRepository.findByUri(org.getEuropeanaRoleIds()));
        }
    }

    public String getRedirectUriWhenNotFound(EntityTypes type, String identifier, EntityNotFoundException entityNotFoundException, HttpServletRequest request) throws MultipleChoicesException, EntityNotFoundException {
        String entityUri = EntityRecordUtils.buildEntityIdUri((EntityTypes)type, (String)identifier);
        List<EntityRecord> corefEntities = this.findEntitiesByCoreference(Collections.singletonList(entityUri), null, false);
        if (corefEntities.size() > 1) {
            throw new MultipleChoicesException(String.format("There are multiple choices for redirecting the entity id: '%s'. They include: '%s'.", entityUri, EntityRecordUtils.getEntityIds(corefEntities).toString()));
        }
        if (corefEntities.size() == 1) {
            String redirectionEntityId = corefEntities.get(0).getEntityId();
            return EntityRecordUtils.buildRedirectionLocation((String)identifier, (String)redirectionEntityId, (String)request.getRequestURI(), (String)request.getQueryString());
        }
        throw entityNotFoundException;
    }

    public String getRedirectUriWhenDeprecated(EntityRecord deprecatedEntity, String identifier, HttpServletRequest request) throws EntityRemovedException, MultipleChoicesException {
        List<String> allCorefEuropeanaIds = deprecatedEntity.getEntity().getSameReferenceLinks().stream().filter(el -> el.startsWith("http://data.europeana.eu/")).collect(Collectors.toList());
        List<EntityRecord> entitiesRedirect = this.retrieveMultipleByEntityIds(allCorefEuropeanaIds, true, false, null);
        if (entitiesRedirect.size() > 1) {
            throw new MultipleChoicesException(String.format("There are multiple choices for redirecting the entity id: '%s'. They include: '%s'.", deprecatedEntity.getEntityId(), EntityRecordUtils.getEntityIds(entitiesRedirect).toString()));
        }
        if (entitiesRedirect.size() == 1) {
            String redirectionEntityId = entitiesRedirect.get(0).getEntityId();
            return EntityRecordUtils.buildRedirectionLocation((String)identifier, (String)redirectionEntityId, (String)request.getRequestURI(), (String)request.getQueryString());
        }
        throw new EntityRemovedException(String.format("Entity '%s' has been removed", deprecatedEntity.getEntityId()));
    }

    public List<EntityIdDisabledStatus> retrieveEntityDeprecationStatus(List<String> entityIds, boolean excludeDisabled) {
        return this.entityRecordRepository.getEntityIds(entityIds, excludeDisabled);
    }

    public EntityRecord saveEntityRecord(EntityRecord er) {
        return this.entityRecordRepository.save(er);
    }

    public List<EntityRecord> saveBulkEntityRecords(List<EntityRecord> records) {
        return this.entityRecordRepository.saveBulk(records);
    }

    public long deleteBulk(List<String> entityIds, boolean deleteFromSolr) throws SolrServiceException {
        long deleteCount;
        if (deleteFromSolr && !entityIds.isEmpty()) {
            this.solrService.deleteById(entityIds, true);
            this.logger.debug("Deleted {} entityRecords from Solr: entityIds={}", (Object)entityIds.size(), entityIds);
        }
        if ((deleteCount = this.entityRecordRepository.deleteBulk(entityIds)) > 0L) {
            this.logger.debug("Deleted {} entityRecords from database: entityIds={}", (Object)deleteCount, entityIds);
        }
        return deleteCount;
    }

    public void disableBulk(List<String> entityIds) {
        UpdateResult updateResult = this.entityRecordRepository.disableBulk(entityIds);
        this.logger.debug("Deprecated {} entities: entityIds={}", (Object)updateResult.getModifiedCount(), entityIds);
    }

    public void disableEntityRecord(EntityRecord er, boolean forceSolrCommit) throws EntityUpdateException {
        try {
            this.solrService.deleteById(List.of(er.getEntityId()), forceSolrCommit);
        }
        catch (SolrServiceException e) {
            throw new EntityUpdateException("Cannot delete solr record with id: " + er.getEntityId(), e);
        }
        er.setDisabled(new Date());
        this.entityRecordRepository.save(er);
    }

    @Deprecated
    void updateEntitiesInScheme(ConceptScheme scheme) {
        if (scheme.getItems() == null) {
            return;
        }
        for (String entityUrl : scheme.getItems()) {
            Optional<EntityRecord> erOpt = this.retrieveByEntityId(entityUrl);
            if (erOpt.isEmpty()) continue;
            EntityRecord er = erOpt.get();
            List inScheme = er.getEntity().getInScheme();
            if (inScheme != null) {
                inScheme.remove(scheme.getConceptSchemeId());
            }
            this.entityRecordRepository.save(er);
        }
    }

    public void enableEntityRecord(EntityRecord entityRecord) throws EntityUpdateException {
        entityRecord.setDisabled(null);
        EntityRecord savedEntityRecord = this.saveEntityRecord(entityRecord);
        this.indexDereferencedEntity(savedEntityRecord);
    }

    public void indexDereferencedEntity(EntityRecord entityRecord) throws EntityUpdateException {
        try {
            EntityRecord recordToIndex = EntityTypes.isOrganization((String)entityRecord.getEntity().getType()) ? this.retrieveEntityRecord(entityRecord.getEntityId(), EntityProfile.dereference.name(), false) : entityRecord;
            this.solrService.storeEntity(SolrUtils.createSolrEntity((EntityRecord)recordToIndex));
        }
        catch (EntityNotFoundException | EntityRemovedException | SolrServiceException e) {
            throw new EntityUpdateException("Cannot create solr record for entity with id: " + entityRecord.getEntityId(), (Throwable)e);
        }
    }

    public EntityRecord update(EntityRecord entityRecord) {
        return this.saveEntityRecord(entityRecord);
    }

    public long delete(String entityId) throws SolrServiceException {
        this.solrService.deleteById(List.of(entityId), true);
        return this.entityRecordRepository.deleteForGood(entityId);
    }

    public EntityRecord createEntityFromMigrationRequest(Entity europeanaProxyEntity, String type, String identifier) throws EntityAlreadyExistsException, HttpBadRequestException, HttpUnprocessableException, EntityModelCreationException, UnsupportedEntityTypeException {
        String externalProxyId = europeanaProxyEntity.getEntityId();
        DataSource externalDatasource = this.datasources.verifyDataSource(externalProxyId, true);
        Date timestamp = new Date();
        Entity entity = EntityObjectFactory.createConsolidatedEntityObject((String)type);
        String entityId = this.generateEntityId(EntityTypes.getByEntityType((String)entity.getType()), identifier);
        this.checkIfEntityAlreadyExists(entityId);
        entity.setEntityId(entityId);
        entity.setSameReferenceLinks(new ArrayList<String>(List.of(externalProxyId)));
        EntityRecord entityRecord = new EntityRecord();
        entityRecord.setEntityId(entityId);
        entityRecord.setEntity(entity);
        europeanaProxyEntity.setEntityId(entityId);
        Entity metisEntity = EntityObjectFactory.createProxyEntityObject((String)type);
        this.setEuropeanaMetadata(europeanaProxyEntity, entityId, new ArrayList<String>(List.of(externalProxyId)), entityRecord, timestamp);
        this.setExternalProxy(metisEntity, externalProxyId, entityId, externalDatasource, entityRecord, timestamp, 1);
        this.updateEntityAggregation(entityRecord, entityId, timestamp);
        return this.entityRecordRepository.save(entityRecord);
    }

    public EntityRecord createEntityFromRequest(Entity europeanaProxyEntity, Entity datasourceResponse, DataSource dataSource, String predefinedEntityId) throws EntityCreationException, UnsupportedEntityTypeException {
        String externalEntityId = europeanaProxyEntity.getEntityId();
        boolean isZohoOrg = this.isZohoOrg(externalEntityId, datasourceResponse);
        if (this.isRegistrationRejected(predefinedEntityId, isZohoOrg)) {
            throw new EntityCreationException("This instance is not allowed to register new Organizations. Registration of external entity refused: " + externalEntityId);
        }
        String entityId = predefinedEntityId != null ? this.verifyPredefinedOrganizationEntityId(predefinedEntityId, isZohoOrg) : this.generateEntityId(datasourceResponse);
        EntityRecord entityRecord = this.buildEntityRecordObject(entityId, europeanaProxyEntity, datasourceResponse, dataSource, externalEntityId, isZohoOrg);
        if (isZohoOrg && predefinedEntityId == null) {
            this.updateEuropeanaIDFieldInZoho(externalEntityId, entityId);
        }
        return this.entityRecordRepository.save(entityRecord);
    }

    boolean isRegistrationRejected(String predefinedEntityId, boolean isZohoOrg) {
        return isZohoOrg && !this.emConfiguration.isGenerateOrganizationEuropeanaId() && predefinedEntityId == null;
    }

    EntityRecord buildEntityRecordObject(String entityId, Entity europeanaProxyEntity, Entity datasourceResponse, DataSource dataSource, String externalEntityId, boolean isZohoOrg) throws EntityCreationException {
        Optional wikidataId;
        Entity entity;
        Date timestamp = new Date();
        try {
            entity = EntityObjectFactory.createConsolidatedEntityObject((Entity)europeanaProxyEntity);
        }
        catch (EntityModelCreationException e) {
            throw new EntityCreationException(e.getMessage(), e);
        }
        EntityRecord entityRecord = new EntityRecord();
        entityRecord.setEntityId(entityId);
        entity.setEntityId(entityId);
        List<String> sameAs = this.buildSameAsReferenceLinks(externalEntityId, datasourceResponse, europeanaProxyEntity);
        entity.setSameReferenceLinks(sameAs);
        entityRecord.setEntity(entity);
        europeanaProxyEntity.setEntityId(entityId);
        List<String> dereferencedCorefs = this.buildDereferencedCorefs(datasourceResponse, externalEntityId);
        this.setEuropeanaMetadata(europeanaProxyEntity, entityId, dereferencedCorefs, entityRecord, timestamp);
        this.setExternalProxy(datasourceResponse, externalEntityId, entityId, dataSource, entityRecord, timestamp, 1);
        if (isZohoOrg && (wikidataId = WikidataUtils.getWikidataId((List)datasourceResponse.getSameReferenceLinks())).isPresent()) {
            String wikidataOrganizationId = (String)wikidataId.get();
            this.appendWikidataProxy(entityRecord, wikidataOrganizationId, datasourceResponse.getType(), timestamp);
            europeanaProxyEntity.addSameReferenceLink(wikidataOrganizationId);
        }
        this.updateEntityAggregation(entityRecord, entityId, timestamp);
        return entityRecord;
    }

    boolean isZohoOrg(String externalEntityId, Entity datasourceResponse) {
        return ZohoUtils.isZohoOrganization((String)externalEntityId, (String)datasourceResponse.getType());
    }

    private String verifyPredefinedOrganizationEntityId(String predefinedEntityId, boolean isZohoOrg) throws EntityCreationException {
        if (!isZohoOrg || predefinedEntityId == null) {
            throw new EntityCreationException("Predefined entity ids can be used only for registration of Zoho Organizations. Creation with predefined entity id refused: " + predefinedEntityId);
        }
        if (this.emConfiguration.isGenerateOrganizationEuropeanaId()) {
            long predefinedIdentifier = Long.parseLong(StringUtils.substringAfterLast((String)predefinedEntityId, (String)"/"));
            long lastGeneratedId = this.entityRecordRepository.getLastGeneratedIdentifier(EntityTypes.Organization.getEntityType());
            if (lastGeneratedId < predefinedIdentifier || predefinedIdentifier < 1L) {
                throw new EntityCreationException("Predefined entity id is out of range: " + predefinedEntityId + " identifier must be smaller onr equal than: " + lastGeneratedId);
            }
        }
        return predefinedEntityId;
    }

    List<String> buildDereferencedCorefs(Entity datasourceResponse, String externalEntityId) {
        ArrayList<String> corefs = new ArrayList<String>();
        corefs.add(externalEntityId);
        if (!corefs.contains(datasourceResponse.getAbout())) {
            corefs.add(datasourceResponse.getAbout());
        }
        return corefs;
    }

    public EntityProxy appendWikidataProxy(EntityRecord entityRecord, String wikidataProxyId, String entityType, Date timestamp) throws EntityCreationException {
        try {
            Entity wikidataProxyEntity = EntityObjectFactory.createProxyEntityObject((String)entityType);
            Optional<DataSource> wikidataDatasource = this.getDataSource(wikidataProxyId);
            int proxyNr = entityRecord.getProxies().size();
            EntityProxy wikidataProxy = this.setExternalProxy(wikidataProxyEntity, wikidataProxyId, entityRecord.getEntityId(), wikidataDatasource.get(), entityRecord, timestamp, proxyNr);
            entityRecord.getEntity().addSameReferenceLink(wikidataProxyId);
            this.updateEntityAggregation(entityRecord, entityType, timestamp);
            return wikidataProxy;
        }
        catch (EntityModelCreationException e) {
            throw new EntityCreationException(e.getMessage(), e);
        }
    }

    String generateEntityId(Entity datasourceResponse) throws UnsupportedEntityTypeException {
        return this.generateEntityId(EntityTypes.getByEntityType((String)datasourceResponse.getType()), null);
    }

    List<String> buildSameAsReferenceLinks(String externalProxyId, Entity datasourceResponse, Entity europeanaProxyEntity) {
        TreeSet<String> sameAsUrls = new TreeSet<String>();
        sameAsUrls.add(datasourceResponse.getEntityId());
        sameAsUrls.add(externalProxyId);
        if (datasourceResponse.getSameReferenceLinks() != null) {
            sameAsUrls.addAll(datasourceResponse.getSameReferenceLinks());
        }
        if (europeanaProxyEntity.getSameReferenceLinks() != null) {
            sameAsUrls.addAll(europeanaProxyEntity.getSameReferenceLinks());
        }
        ArrayList<String> sameAs = new ArrayList<String>(sameAsUrls);
        return sameAs;
    }

    private Optional<DataSource> getDataSource(String externalProxyId) throws EntityCreationException {
        Optional<DataSource> externalDatasourceOptional = this.datasources.getDatasource(externalProxyId);
        if (externalDatasourceOptional.isEmpty()) {
            throw new EntityCreationException("No configured datasource for id " + externalProxyId);
        }
        return externalDatasourceOptional;
    }

    private void checkIfEntityAlreadyExists(String entityId) throws EntityAlreadyExistsException {
        Optional<EntityRecord> entityRecordOpt = this.retrieveByEntityId(entityId);
        if (entityRecordOpt.isPresent()) {
            throw new EntityAlreadyExistsException(entityId);
        }
    }

    private String generateEntityId(EntityTypes entityType, String entityId) {
        if (entityId != null) {
            return EntityRecordUtils.buildEntityIdUri((EntityTypes)entityType, (String)entityId);
        }
        long dbId = this.entityRecordRepository.generateAutoIncrement(entityType.getEntityType());
        return EntityRecordUtils.buildEntityIdUri((EntityTypes)entityType, (String)String.valueOf(dbId));
    }

    public void performReferentialIntegrity(Entity entity) {
        this.performCommonReferentialIntegrity(entity);
        switch (EntityTypes.valueOf((String)entity.getType())) {
            case Concept: {
                this.performReferentialIntegrityConcept((Concept)entity);
                break;
            }
            case Agent: {
                this.performReferentialIntegrityAgent((Agent)entity);
                break;
            }
            case Place: {
                this.performReferentialIntegrityPlace((Place)entity);
                break;
            }
            case TimeSpan: {
                this.performReferentialIntegrityTimespan((TimeSpan)entity);
                break;
            }
            case Organization: {
                break;
            }
        }
    }

    private void performCommonReferentialIntegrity(Entity entity) {
        List hasPartField = entity.getHasPart();
        entity.setHasPart(this.replaceWithInternalReferences(hasPartField));
        List isPartOfField = entity.getIsPartOfArray();
        entity.setIsPartOfArray(this.replaceWithInternalReferences(isPartOfField));
        List isRelatedToField = entity.getIsRelatedTo();
        entity.setIsRelatedTo(this.replaceWithInternalReferences(isRelatedToField));
    }

    private void performReferentialIntegrityConcept(Concept entity) {
        List broaderField = entity.getBroader();
        entity.setBroader(this.replaceWithInternalReferences(broaderField));
        List narrowerField = entity.getNarrower();
        entity.setNarrower(this.replaceWithInternalReferences(narrowerField));
        List relatedField = entity.getRelated();
        entity.setRelated(this.replaceWithInternalReferences(relatedField));
    }

    private void performReferentialIntegrityAgent(Agent entity) {
        List placeOfBirthField = entity.getPlaceOfBirth();
        entity.setPlaceOfBirth(this.replaceWithInternalReferences(placeOfBirthField));
        List placeOfDeathField = entity.getPlaceOfDeath();
        entity.setPlaceOfDeath(this.replaceWithInternalReferences(placeOfDeathField));
        List professionOrOccupationField = entity.getProfessionOrOccupation();
        entity.setProfessionOrOccupation(this.replaceWithInternalReferences(professionOrOccupationField));
        List hasMetField = entity.getHasMet();
        entity.setHasMet(this.replaceWithInternalReferences(hasMetField));
        List wasPresentField = entity.getWasPresentAt();
        entity.setWasPresentAt(this.replaceWithInternalReferences(wasPresentField));
        List dateField = entity.getDate();
        entity.setDate(this.replaceWithInternalReferences(dateField));
    }

    private void performReferentialIntegrityPlace(Place entity) {
        List isNextInSequenceField = entity.getIsNextInSequence();
        entity.setIsNextInSequence(this.replaceWithInternalReferences(isNextInSequenceField));
    }

    private void performReferentialIntegrityTimespan(TimeSpan entity) {
        List isNextInSequenceField = entity.getIsNextInSequence();
        entity.setIsNextInSequence(this.replaceWithInternalReferences(isNextInSequenceField));
    }

    private List<String> replaceWithInternalReferences(List<String> originalReferences) {
        if (originalReferences == null) {
            return null;
        }
        ArrayList<String> updatedReferences = new ArrayList<String>();
        for (String entry : originalReferences) {
            this.addValueOrInternalReference(updatedReferences, entry);
        }
        if (updatedReferences.isEmpty()) {
            return null;
        }
        return updatedReferences;
    }

    public Entity mergeEntities(Entity primary, Entity secondary) throws EuropeanaApiException, EntityModelCreationException {
        List<Field> fieldsToCombine = EntityUtils.getAllFields(primary.getClass()).stream().filter(f -> !ignoredMergeFields.contains(f.getName())).toList();
        return this.combineEntities(primary, secondary, fieldsToCombine, true);
    }

    public void updateConsolidatedVersion(EntityRecord entityRecord, Entity consolidatedEntity) {
        entityRecord.setEntity(consolidatedEntity);
        this.updateEntityAggregation(entityRecord, consolidatedEntity.getEntityId(), new Date());
    }

    public void replaceEuropeanaProxy(Entity updateRequestEntity, EntityRecord entityRecord) {
        EntityProxy europeanaProxy = entityRecord.getEuropeanaProxy();
        String entityId = europeanaProxy.getEntity().getEntityId();
        europeanaProxy.setEntity(updateRequestEntity);
        europeanaProxy.getEntity().setEntityId(entityId);
        europeanaProxy.getProxyIn().setModified(Date.from(Instant.now()));
    }

    public void dropRepository() {
        this.entityRecordRepository.dropCollection();
    }

    public List<EntityRecord> findEntitiesWithFilter(int start, int limit, Filter[] queryFilters, String profiles) {
        List records = this.entityRecordRepository.find(start, limit, queryFilters);
        for (EntityRecord entityRecord : records) {
            this.postProcessOrganizationRetrieval(profiles, entityRecord);
        }
        return records;
    }

    private void updateEntityAggregation(EntityRecord entityRecord, String entityId, Date timestamp) {
        Aggregation aggregation = entityRecord.getEntity().getIsAggregatedBy();
        if (aggregation == null) {
            aggregation = this.createNewAggregation(entityId, timestamp);
            entityRecord.getEntity().setIsAggregatedBy(aggregation);
        } else {
            aggregation.setModified(timestamp);
        }
        this.updateEntityAggregatesList(aggregation, entityRecord, entityId);
    }

    private void updateEntityAggregatesList(Aggregation aggregation, EntityRecord entityRecord, String entityId) {
        ArrayList<String> aggregates = new ArrayList<String>();
        aggregates.add(EntityRecordUtils.getEuropeanaAggregationId((String)entityId));
        if (entityRecord.getExternalProxies() != null) {
            for (int i = 0; i < entityRecord.getExternalProxies().size(); ++i) {
                aggregates.add(EntityRecordUtils.getDatasourceAggregationId((String)entityRecord.getEntityId(), (int)(i + 1)));
            }
        }
        aggregation.setAggregates(aggregates);
    }

    public void changeExternalProxy(EntityRecord entityRecord, String newProxyId) throws EuropeanaApiException, EntityModelCreationException {
        DataSource dataSource = this.datasources.verifyDataSource(newProxyId, true);
        List externalProxies = entityRecord.getExternalProxies();
        if (externalProxies.size() > 1) {
            throw new HttpBadRequestException("Changing provenance not supported for entity");
        }
        EntityProxy externalProxy = (EntityProxy)externalProxies.get(0);
        String entityType = externalProxy.getEntity().getType();
        entityRecord.getProxies().remove(externalProxy);
        this.setExternalProxy(EntityObjectFactory.createProxyEntityObject((String)entityType), newProxyId, entityRecord.getEntityId(), dataSource, entityRecord, new Date(), 1);
    }

    public EntityRecord updateUsedForEnrichment(EntityTypes type, String identifier, String profile, String action) throws EuropeanaApiException {
        EntityRecord entityRecord = this.retrieveEntityRecord(type, identifier, profile, false);
        if (StringUtils.equals((String)action, (String)"enable")) {
            entityRecord.getEntity().getIsAggregatedBy().setEnrich(Boolean.TRUE);
        }
        if (StringUtils.equals((String)action, (String)"disable")) {
            entityRecord.getEntity().getIsAggregatedBy().setEnrich(Boolean.FALSE);
        }
        return this.update(entityRecord);
    }

    void updateEuropeanaIDFieldInZoho(String zohoOrganizationUrl, String europeanaId) throws EntityCreationException {
        try {
            this.zohoConfiguration.getZohoAccessClient().updateZohoRecordOrganizationStringField(zohoOrganizationUrl, "Europeana_org_ID", europeanaId);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Updated organization id in Zoho got organization: {} - {}", (Object)zohoOrganizationUrl, (Object)europeanaId);
            }
        }
        catch (ZohoException e) {
            String message = "Updating EuropeanaID field in Zoho faild for Organization: " + zohoOrganizationUrl;
            throw new EntityCreationException(message, e);
        }
    }
}

