/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.IndexOptions;
import dev.morphia.annotations.Indexed;
import eu.europeana.api.commons.definitions.utils.DateUtils;
import eu.europeana.entitymanagement.web.model.FailedOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bson.types.ObjectId;

@JsonPropertyOrder(value={"lastSyncDate", "executionStatus", "new", "enabled", "updated", "deprecated", "deleted", "failed"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Entity(value="ZohoSyncReport")
public class ZohoSyncReport {
    @Id
    @JsonIgnore
    private ObjectId dbId;
    @Indexed(options=@IndexOptions(unique=true))
    Date startDate;
    long createdItems;
    long enabledItems;
    long updatedItems;
    long deprecatedItems;
    long deletedItems;
    long submittedZohoEuropeanaId;
    private List<FailedOperation> failed;

    public ZohoSyncReport(Date startDate) {
        this.startDate = startDate;
    }

    public ZohoSyncReport() {
    }

    @JsonProperty(value="new")
    public long getCreatedItems() {
        return this.createdItems;
    }

    public void setCreatedItems(long created) {
        this.createdItems = created;
    }

    public void increaseCreated(long created) {
        this.createdItems += created;
    }

    @JsonProperty(value="enabled")
    public long getEnabledItems() {
        return this.enabledItems;
    }

    public void setEnabledItems(long enabled) {
        this.enabledItems = enabled;
    }

    public void increaseEnabled(long enabled) {
        this.enabledItems += enabled;
    }

    @JsonProperty(value="updated")
    public long getUpdatedItems() {
        return this.updatedItems;
    }

    public void setUpdatedItems(long updated) {
        this.updatedItems = updated;
    }

    public void increaseUpdated(long updated) {
        this.updatedItems += updated;
    }

    @JsonProperty(value="deprecated")
    public long getDeprecatedItems() {
        return this.deprecatedItems;
    }

    public void setDeprecatedItems(long deprecated) {
        this.deprecatedItems = deprecated;
    }

    public void increaseDeprecated(long deprecated) {
        this.deprecatedItems += deprecated;
    }

    @JsonProperty(value="deleted")
    public long getDeletedItems() {
        return this.deletedItems;
    }

    public void setDeletedItems(long deleted) {
        this.deletedItems = deleted;
    }

    public void increaseDeleted(long deleted) {
        this.deletedItems += deleted;
    }

    @JsonProperty(value="submittedZohoEuropeanaID")
    public long getSubmittedZohoEuropeanaId() {
        return this.submittedZohoEuropeanaId;
    }

    public void setSubmittedZohoEuropeanaId(long submittedZohoEuropeanaId) {
        this.submittedZohoEuropeanaId = submittedZohoEuropeanaId;
    }

    public void increaseSubmittedZohoEuropeanaId() {
        ++this.submittedZohoEuropeanaId;
    }

    @JsonProperty(value="executionStatus")
    public String getExecutionStatus() {
        if (this.getFailed() == null || this.getFailed().isEmpty()) {
            return "completed";
        }
        return "incomplete";
    }

    public String toString() {
        return String.format("lastSyncDate: %s,%n created: %d,%n enabled: %d, %n updated: %d,%n deprecated: %d,%n deleted: %d,%n updated EuropeanaID in Zoho: %d,%n executionStatus: %s", DateUtils.convertDateToStr((Date)this.getStartDate()), this.getCreatedItems(), this.getEnabledItems(), this.getUpdatedItems(), this.getDeprecatedItems(), this.getDeletedItems(), this.getSubmittedZohoEuropeanaId(), this.getExecutionStatus());
    }

    @JsonProperty(value="lastSyncDate")
    public Date getStartDate() {
        return this.startDate;
    }

    private void addFailedOperation(FailedOperation operation) {
        if (this.failed == null) {
            this.failed = new ArrayList<FailedOperation>();
        }
        this.failed.add(operation);
    }

    public void addFailedOperation(String id, String error, Throwable th) {
        this.addFailedOperation(id, error, th.getMessage(), th);
    }

    public void addFailedOperation(String id, String error, String message, Throwable th) {
        String trace;
        String string = trace = th == null ? null : ExceptionUtils.getStackTrace((Throwable)th);
        if (error == null && th != null) {
            error = th.getClass().getSimpleName();
        }
        FailedOperation failedOperation = new FailedOperation(id, error, message, trace);
        this.addFailedOperation(failedOperation);
    }

    @JsonProperty(value="failed")
    public List<FailedOperation> getFailed() {
        return this.failed;
    }

    public ObjectId getDbId() {
        return this.dbId;
    }

    public void setDbId(ObjectId dbId) {
        this.dbId = dbId;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setFailed(List<FailedOperation> failed) {
        this.failed = failed;
    }
}

