/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.reader;

import eu.europeana.entitymanagement.definitions.batch.model.BatchEntityRecord;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTask;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.batch.item.data.AbstractPaginatedDataItemReader;

public abstract class BaseDatabaseReader<T>
extends AbstractPaginatedDataItemReader<T> {
    private final int readerPageSize;

    protected BaseDatabaseReader(int pageSize) {
        this.readerPageSize = pageSize;
    }

    abstract String getClassName();

    protected void doOpen() throws Exception {
        super.doOpen();
        this.setSaveState(false);
        this.setPageSize(this.readerPageSize);
        this.setName(this.getClassName());
    }

    List<BatchEntityRecord> toBatchEntityRecords(List<EntityRecord> result, ScheduledTaskType scheduledTaskType) {
        return result.stream().map(rec -> new BatchEntityRecord(rec, scheduledTaskType)).collect(Collectors.toList());
    }

    List<BatchEntityRecord> toBatchEntityRecords(List<EntityRecord> result, List<ScheduledTask> scheduledTasks) {
        Map<String, ScheduledTaskType> taskTypeMap = scheduledTasks.stream().collect(Collectors.toMap(ScheduledTask::getEntityId, ScheduledTask::getUpdateType));
        return result.stream().map(rec -> new BatchEntityRecord(rec, (ScheduledTaskType)taskTypeMap.get(rec.getEntityId()))).collect(Collectors.toList());
    }
}

