/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.config;

import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SolrConfig {
    private static final Logger logger = LogManager.getLogger(SolrConfig.class);
    private final EntityManagementConfiguration emConfiguration;

    @Autowired
    public SolrConfig(EntityManagementConfiguration emConfiguration) {
        this.emConfiguration = emConfiguration;
    }

    @Bean(value={"prSolrClient"})
    public SolrClient pageRankSolrClient() {
        logger.info("Configuring pageRank solr client at the url: {}", (Object)this.emConfiguration.getPrSolrUrl());
        return new HttpSolrClient.Builder(this.emConfiguration.getPrSolrUrl()).build();
    }

    @Bean(value={"indexingSolrClient"})
    public SolrClient indexingSolrClient() {
        if (StringUtils.isNotBlank((CharSequence)this.emConfiguration.getIndexingSolrZookeeperUrl())) {
            return this.initSolrCloudClient();
        }
        return this.initSolrClient();
    }

    private SolrClient initSolrClient() {
        logger.info("Configuring indexing solr client at the url: {}", (Object)this.emConfiguration.getIndexingSolrUrl());
        if (this.emConfiguration.getIndexingSolrUrl().contains(",")) {
            LBHttpSolrClient.Builder builder = new LBHttpSolrClient.Builder();
            return ((LBHttpSolrClient.Builder)builder.withBaseSolrUrls(this.emConfiguration.getIndexingSolrUrl().split(",")).withConnectionTimeout(this.emConfiguration.getIndexingSolrTimeoutMillis())).build();
        }
        HttpSolrClient.Builder builder = new HttpSolrClient.Builder();
        return ((HttpSolrClient.Builder)builder.withBaseSolrUrl(this.emConfiguration.getIndexingSolrUrl()).withConnectionTimeout(this.emConfiguration.getIndexingSolrTimeoutMillis())).build();
    }

    private SolrClient initSolrCloudClient() {
        logger.info("Configuring indexing solr client with the zookeperurls: {} and collection: {}", (Object)this.emConfiguration.getIndexingSolrUrl(), (Object)this.emConfiguration.getIndexingSolrCollection());
        String[] solrZookeeperUrls = this.emConfiguration.getIndexingSolrZookeeperUrl().trim().split(",");
        CloudSolrClient client = ((CloudSolrClient.Builder)new CloudSolrClient.Builder(Arrays.asList(solrZookeeperUrls), Optional.empty()).withConnectionTimeout(this.emConfiguration.getIndexingSolrTimeoutMillis())).build();
        client.setDefaultCollection(this.emConfiguration.getIndexingSolrCollection());
        return client;
    }
}

