/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web;

import eu.europeana.api.commons.config.i18n.I18nService;
import eu.europeana.api.commons.error.EuropeanaApiErrorResponse;
import eu.europeana.api.commons.web.exception.EuropeanaGlobalExceptionHandler;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.entitymanagement.web.service.RequestPathMethodService;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpMediaTypeException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
@ConditionalOnWebApplication
public class EMExceptionHandler
extends EuropeanaGlobalExceptionHandler {
    private I18nService i18nService;

    @Autowired
    public EMExceptionHandler(RequestPathMethodService requestPathMethodService, I18nService i18nService) {
        this.requestPathMethodService = requestPathMethodService;
        this.i18nService = i18nService;
    }

    @ExceptionHandler
    public ResponseEntity<EuropeanaApiErrorResponse> handleCommonHttpException(HttpException e, HttpServletRequest httpRequest) {
        EuropeanaApiErrorResponse response = new EuropeanaApiErrorResponse.Builder(httpRequest, (Exception)e, this.stackTraceEnabled()).setStatus(e.getStatus().value()).setError(e.getStatus().getReasonPhrase()).setMessage(this.i18nService.getMessage(e.getI18nKey(), e.getI18nParams())).setCode(e.getI18nKey()).build();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)e.getStatus()).headers(this.createHttpHeaders(httpRequest))).body((Object)response);
    }

    @ExceptionHandler
    public ResponseEntity<EuropeanaApiErrorResponse> handleException(HttpMessageNotReadableException e, HttpServletRequest httpRequest) {
        EuropeanaApiErrorResponse response = new EuropeanaApiErrorResponse.Builder(httpRequest, (Exception)e, this.stackTraceEnabled()).setStatus(HttpStatus.BAD_REQUEST.value()).setError("Error parsing request body").setMessage("JSON is either malformed or missing required 'type' property").build();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)HttpStatus.BAD_REQUEST.value()).headers(this.createHttpHeaders(httpRequest))).body((Object)response);
    }

    @ExceptionHandler(value={HttpMediaTypeException.class})
    public ResponseEntity<EuropeanaApiErrorResponse> handleInvalidMediaType(HttpMediaTypeException e, HttpServletRequest httpRequest) {
        EuropeanaApiErrorResponse response = new EuropeanaApiErrorResponse.Builder(httpRequest, (Exception)e, this.stackTraceEnabled()).setStatus(HttpStatus.UNSUPPORTED_MEDIA_TYPE.value()).setError(e.getMessage()).setMessage("Unsupported media type. Supported types are: " + MediaType.toString((Collection)e.getSupportedMediaTypes())).build();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)HttpStatus.UNSUPPORTED_MEDIA_TYPE.value()).headers(this.createHttpHeaders(httpRequest))).body((Object)response);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ResponseEntity<EuropeanaApiErrorResponse> handleNoHandlerFoundException(NoHandlerFoundException e, HttpServletRequest httpRequest) {
        EuropeanaApiErrorResponse response = new EuropeanaApiErrorResponse.Builder(httpRequest, (Exception)e, this.stackTraceEnabled()).setStatus(HttpStatus.NOT_FOUND.value()).setError(HttpStatus.NOT_FOUND.getReasonPhrase()).setMessage(e.getMessage()).build();
        return ResponseEntity.status((int)HttpStatus.NOT_FOUND.value()).contentType(MediaType.APPLICATION_JSON).body((Object)response);
    }
}

