/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.service;

import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.entitymanagement.common.config.DataSource;
import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.config.DataSources;
import eu.europeana.entitymanagement.definitions.exceptions.EntityModelCreationException;
import eu.europeana.entitymanagement.definitions.model.Aggregation;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.EntityProxy;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.definitions.model.Organization;
import eu.europeana.entitymanagement.exception.ingestion.EntityUpdateException;
import eu.europeana.entitymanagement.mongo.repository.EntityRecordRepository;
import eu.europeana.entitymanagement.mongo.repository.VocabularyRepository;
import eu.europeana.entitymanagement.solr.service.SolrService;
import eu.europeana.entitymanagement.utils.EMCollectionUtils;
import eu.europeana.entitymanagement.utils.EntityObjectFactory;
import eu.europeana.entitymanagement.utils.EntityRecordUtils;
import eu.europeana.entitymanagement.utils.UriValidator;
import eu.europeana.entitymanagement.vocabulary.EntityFieldsTypes;
import eu.europeana.entitymanagement.zoho.organization.ZohoConfiguration;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class BaseEntityRecordService {
    final EntityRecordRepository entityRecordRepository;
    final VocabularyRepository vocabRepository;
    final EntityManagementConfiguration emConfiguration;
    final DataSources datasources;
    final SolrService solrService;
    final ZohoConfiguration zohoConfiguration;
    protected final Logger logger = LogManager.getLogger(this.getClass());
    static final Set<String> ignoredMergeFields = Set.of("type", "isAggregatedBy");

    protected BaseEntityRecordService(EntityRecordRepository entityRecordRepository, VocabularyRepository vocabRepository, EntityManagementConfiguration emConfiguration, ZohoConfiguration zohoConfiguration, DataSources datasources, SolrService solrService) {
        this.entityRecordRepository = entityRecordRepository;
        this.vocabRepository = vocabRepository;
        this.emConfiguration = emConfiguration;
        this.zohoConfiguration = zohoConfiguration;
        this.datasources = datasources;
        this.solrService = solrService;
    }

    public List<EntityRecord> findEntitiesByCoreference(List<String> uris, String entityId, boolean excludeDisabled) {
        return this.entityRecordRepository.findEntitiesByCoreference(uris, entityId, excludeDisabled);
    }

    protected void addValueOrInternalReference(List<String> updatedReferences, String value) {
        if (value.startsWith("http://data.europeana.eu/") || !UriValidator.isUri((String)value)) {
            updatedReferences.add(value);
        } else {
            List<EntityRecord> records = this.findEntitiesByCoreference(Collections.singletonList(value), null, true);
            if (!records.isEmpty()) {
                updatedReferences.add(records.get(0).getEntityId());
            }
        }
    }

    protected Entity combineEntities(Entity primary, Entity secondary, List<Field> fieldsToCombine, boolean accumulate) throws EuropeanaApiException, EntityModelCreationException {
        Entity consolidatedEntity = EntityObjectFactory.createConsolidatedEntityObject((String)primary.getType());
        try {
            HashMap<Object, Object> prefLabelsForAltLabels = new HashMap<Object, Object>();
            for (Field field : fieldsToCombine) {
                Class<?> fieldType = field.getType();
                String fieldName = field.getName();
                if (this.isStringOrPrimitive(fieldType)) {
                    this.mergePrimitiveField(field, primary, secondary, consolidatedEntity);
                    continue;
                }
                if (Date.class.isAssignableFrom(fieldType)) {
                    this.mergeDateField(field, primary, secondary, consolidatedEntity);
                    continue;
                }
                if (fieldType.isArray()) {
                    Object[] mergedArray = this.mergeArrays(primary, secondary, field, accumulate);
                    consolidatedEntity.setFieldValue(field, (Object)mergedArray);
                    continue;
                }
                if (List.class.isAssignableFrom(fieldType)) {
                    this.mergeListField(field, primary, secondary, consolidatedEntity, accumulate);
                    continue;
                }
                if (Map.class.isAssignableFrom(fieldType)) {
                    this.combineEntities(consolidatedEntity, primary, secondary, prefLabelsForAltLabels, field, fieldName, accumulate);
                    continue;
                }
                this.mergeCustomObjects(primary, secondary, field, consolidatedEntity);
            }
            this.mergeSkippedPrefLabels(consolidatedEntity, prefLabelsForAltLabels, fieldsToCombine);
        }
        catch (IllegalAccessException e) {
            throw new EntityUpdateException("Metadata consolidation failed to access required properties!", e);
        }
        return consolidatedEntity;
    }

    void mergeListField(Field field, Entity primary, Entity secondary, Entity consolidatedEntity, boolean accumulate) throws IllegalAccessException, EntityUpdateException {
        List fieldValuePrimaryObjectList = (List)primary.getFieldValue(field);
        List fieldValueSecondaryObjectList = (List)secondary.getFieldValue(field);
        this.mergeList(consolidatedEntity, fieldValuePrimaryObjectList, fieldValueSecondaryObjectList, field, accumulate);
    }

    void mergeDateField(Field field, Entity primary, Entity secondary, Entity consolidatedEntity) throws IllegalAccessException {
        Object fieldValuePrimaryObjectDate = primary.getFieldValue(field);
        Object fieldValueSecondaryObjectDate = secondary.getFieldValue(field);
        if (fieldValuePrimaryObjectDate != null) {
            consolidatedEntity.setFieldValue(field, (Object)new Date(((Date)fieldValuePrimaryObjectDate).getTime()));
        } else if (fieldValueSecondaryObjectDate != null) {
            consolidatedEntity.setFieldValue(field, (Object)new Date(((Date)fieldValueSecondaryObjectDate).getTime()));
        }
    }

    void mergePrimitiveField(Field field, Entity primary, Entity secondary, Entity consolidatedEntity) throws IllegalAccessException {
        Object fieldValuePrimaryObjectPrimitiveOrString = primary.getFieldValue(field);
        Object fieldValueSecondaryObjectPrimitiveOrString = secondary.getFieldValue(field);
        if (fieldValuePrimaryObjectPrimitiveOrString != null) {
            consolidatedEntity.setFieldValue(field, fieldValuePrimaryObjectPrimitiveOrString);
        } else if (fieldValueSecondaryObjectPrimitiveOrString != null) {
            consolidatedEntity.setFieldValue(field, fieldValueSecondaryObjectPrimitiveOrString);
        }
    }

    private void mergeCustomObjects(Entity primary, Entity secondary, Field field, Entity consolidatedEntity) throws IllegalAccessException, EntityUpdateException {
        Object primaryObj = primary.getFieldValue(field);
        Object secondaryObj = secondary.getFieldValue(field);
        if (primaryObj != null) {
            consolidatedEntity.setFieldValue(field, this.deepCopyOfObject(primaryObj));
        } else if (secondaryObj != null) {
            consolidatedEntity.setFieldValue(field, this.deepCopyOfObject(secondaryObj));
        }
    }

    protected void mergePrimarySecondaryListWitoutDuplicates(Map<Object, Object> fieldValuePrimaryObject, Object key, Map.Entry elemSecondary, String fieldName, Map<Object, Object> prefLabelsForAltLabels) throws EntityUpdateException {
        if (fieldValuePrimaryObject.containsKey(key) && List.class.isAssignableFrom(elemSecondary.getValue().getClass())) {
            List listSecondaryObject = (List)elemSecondary.getValue();
            List<Object> listPrimaryObject = this.deepCopyOfList((List)fieldValuePrimaryObject.get(key));
            boolean listPrimaryObjectChanged = false;
            for (Object elemSecondaryList : listSecondaryObject) {
                if (EMCollectionUtils.ifValueAlreadyExistsInList(listPrimaryObject, elemSecondaryList, (boolean)BaseEntityRecordService.doSloppyMatch(fieldName))) continue;
                listPrimaryObject.add(elemSecondaryList);
                if (listPrimaryObjectChanged) continue;
                listPrimaryObjectChanged = true;
            }
            if (listPrimaryObjectChanged) {
                fieldValuePrimaryObject.put(key, listPrimaryObject);
            }
        } else if (fieldValuePrimaryObject.containsKey(key) && fieldName.toLowerCase().contains("pref") && fieldName.toLowerCase().contains("label")) {
            Object primaryObjectPrefLabel = fieldValuePrimaryObject.get(key);
            if (!primaryObjectPrefLabel.equals(elemSecondary.getValue())) {
                prefLabelsForAltLabels.put(key, elemSecondary.getValue());
            }
        } else if (!fieldValuePrimaryObject.containsKey(key)) {
            fieldValuePrimaryObject.put(key, elemSecondary.getValue());
        }
    }

    protected boolean addValuesToAltLabel(Map<Object, Object> prefLabelsForAltLabels, Map<Object, Object> altLabelPrimaryObject, boolean altLabelPrimaryValueChanged) throws EntityUpdateException {
        for (Map.Entry<Object, Object> prefLabel : prefLabelsForAltLabels.entrySet()) {
            String keyPrefLabel = (String)prefLabel.getKey();
            List altLabelPrimaryObjectList = (List)altLabelPrimaryObject.get(keyPrefLabel);
            List<Object> altLabelPrimaryValue = this.deepCopyOfList(altLabelPrimaryObjectList);
            if (!this.shouldValuesBeAddedToAltLabel(altLabelPrimaryValue, prefLabel)) continue;
            altLabelPrimaryValue.add(prefLabel.getValue());
            if (!altLabelPrimaryValueChanged) {
                altLabelPrimaryValueChanged = true;
            }
            altLabelPrimaryObject.put(keyPrefLabel, altLabelPrimaryValue);
        }
        return altLabelPrimaryValueChanged;
    }

    protected boolean isFieldAltLabel(String fieldName) {
        return fieldName.toLowerCase().contains("alt") && fieldName.toLowerCase().contains("label");
    }

    private boolean shouldValuesBeAddedToAltLabel(List<Object> altLabelPrimaryValue, Map.Entry<Object, Object> prefLabel) {
        return altLabelPrimaryValue.isEmpty() || !altLabelPrimaryValue.isEmpty() && !EMCollectionUtils.ifValueAlreadyExistsInList(altLabelPrimaryValue, (Object)prefLabel.getValue(), (boolean)true);
    }

    void mergeList(Entity consolidatedEntity, List<Object> fieldValuePrimaryObjectList, List<Object> fieldValueSecondaryObjectList, Field field, boolean accumulate) throws IllegalAccessException, EntityUpdateException {
        List<Object> fieldValuePrimaryObject = this.deepCopyOfList(fieldValuePrimaryObjectList);
        List<Object> fieldValueSecondaryObject = this.deepCopyOfList(fieldValueSecondaryObjectList);
        if (!CollectionUtils.isEmpty(fieldValuePrimaryObject) && !CollectionUtils.isEmpty(fieldValueSecondaryObject) && accumulate) {
            for (Object secondaryObjectListObject : fieldValueSecondaryObject) {
                this.addToPrimaryList(field, fieldValuePrimaryObject, secondaryObjectListObject);
            }
            consolidatedEntity.setFieldValue(field, fieldValuePrimaryObject);
        } else if (!CollectionUtils.isEmpty(fieldValuePrimaryObject)) {
            consolidatedEntity.setFieldValue(field, fieldValuePrimaryObject);
        } else if (!CollectionUtils.isEmpty(fieldValueSecondaryObject)) {
            consolidatedEntity.setFieldValue(field, fieldValueSecondaryObject);
        }
    }

    private void addToPrimaryList(Field field, List<Object> fieldValuePrimaryObject, Object secondaryObjectListObject) {
        if (!EMCollectionUtils.ifValueAlreadyExistsInList(fieldValuePrimaryObject, (Object)secondaryObjectListObject, (boolean)BaseEntityRecordService.doSloppyMatch(field.getName()))) {
            fieldValuePrimaryObject.add(secondaryObjectListObject);
        }
    }

    Object[] mergeArrays(Entity primary, Entity secondary, Field field, boolean append) throws IllegalAccessException, EntityUpdateException {
        Object[] primaryArray = (Object[])primary.getFieldValue(field);
        Object[] secondaryArray = (Object[])secondary.getFieldValue(field);
        Object[] deepCopyPrimaryArray = this.deepCopyOfArray(primaryArray);
        Object[] deepCopySecondaryArray = this.deepCopyOfArray(secondaryArray);
        if (deepCopyPrimaryArray.length == 0 && deepCopySecondaryArray.length == 0) {
            return deepCopyPrimaryArray;
        }
        if (deepCopyPrimaryArray.length == 0) {
            return deepCopySecondaryArray;
        }
        if (secondaryArray.length == 0 || !append) {
            return deepCopyPrimaryArray;
        }
        TreeSet<Object> mergedAndOrdered = new TreeSet<Object>(Arrays.asList(deepCopyPrimaryArray));
        for (Object second : deepCopySecondaryArray) {
            if (EMCollectionUtils.ifValueAlreadyExistsInList(Arrays.asList(deepCopyPrimaryArray), (Object)second, (boolean)BaseEntityRecordService.doSloppyMatch(field.getName()))) continue;
            mergedAndOrdered.add(second);
        }
        return mergedAndOrdered.toArray(Arrays.copyOf(deepCopyPrimaryArray, 0));
    }

    private Object deepCopyOfObject(Object obj) throws EntityUpdateException {
        if (obj == null || this.isStringOrPrimitive(obj.getClass())) {
            return obj;
        }
        try {
            return obj.getClass().getConstructor(obj.getClass()).newInstance(obj);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new EntityUpdateException("Metadata consolidation failed due to illegal creation of the object copy by calling newInstance.", e);
        }
    }

    private Object[] deepCopyOfArray(Object[] input) throws EntityUpdateException {
        Object[] copy;
        if (input == null || input.length == 0) {
            return new Object[0];
        }
        if (this.isStringOrPrimitive(input[0].getClass())) {
            copy = (Object[])input.clone();
        } else {
            copy = new Object[input.length];
            for (int i = 0; i < input.length; ++i) {
                try {
                    copy[i] = input[i].getClass().getDeclaredConstructor(input[i].getClass()).newInstance(input[i]);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new EntityUpdateException("Metadata consolidation failed due to illegal creation of the object copy within an array by calling newInstance.", e);
                }
            }
        }
        return copy;
    }

    private List<Object> deepCopyOfList(List<Object> input) throws EntityUpdateException {
        ArrayList<Object> copy;
        if (input == null || input.isEmpty()) {
            return new ArrayList<Object>();
        }
        if (this.isStringOrPrimitive(input.get(0).getClass())) {
            copy = new ArrayList<Object>(input);
        } else {
            copy = new ArrayList(input.size());
            for (Object obj : input) {
                try {
                    copy.add(obj.getClass().getDeclaredConstructor(obj.getClass()).newInstance(obj));
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new EntityUpdateException("Metadata consolidation failed due to illegal creation of the object copy within a list by calling newInstance.", e);
                }
            }
        }
        return copy;
    }

    protected Map<Object, Object> deepCopyOfMap(Map<Object, Object> input) throws EntityUpdateException {
        HashMap<Object, Object> copy;
        if (input == null || input.isEmpty()) {
            return new HashMap<Object, Object>();
        }
        Object mapFirstKey = input.entrySet().iterator().next().getKey();
        Object mapFirstValue = input.entrySet().iterator().next().getValue();
        if (this.isStringOrPrimitive(mapFirstKey.getClass()) && this.isStringOrPrimitive(mapFirstValue.getClass())) {
            copy = new HashMap<Object, Object>(input);
        } else {
            copy = new HashMap(input.size());
            for (Map.Entry<Object, Object> entry : input.entrySet()) {
                List<Object> keyDeepCopy = null;
                List<Object> valueDeepCopy = null;
                keyDeepCopy = List.class.isAssignableFrom(mapFirstKey.getClass()) ? this.deepCopyOfList((List)entry.getKey()) : this.deepCopyOfObject(entry.getKey());
                valueDeepCopy = List.class.isAssignableFrom(mapFirstValue.getClass()) ? this.deepCopyOfList((List)entry.getValue()) : this.deepCopyOfObject(entry.getValue());
                copy.put(keyDeepCopy, valueDeepCopy);
            }
        }
        return copy;
    }

    protected Aggregation createNewAggregation(String entityId, Date timestamp) {
        Aggregation isAggregatedBy = new Aggregation();
        isAggregatedBy.setId(EntityRecordUtils.getIsAggregatedById((String)entityId));
        isAggregatedBy.setCreated(timestamp);
        isAggregatedBy.setModified(timestamp);
        return isAggregatedBy;
    }

    protected void setEuropeanaMetadata(Entity europeanaProxyMetadata, String entityId, List<String> corefs, EntityRecord entityRecord, Date timestamp) {
        Aggregation europeanaAggr = new Aggregation();
        Optional<DataSource> europeanaDataSource = this.datasources.getEuropeanaDatasource();
        europeanaAggr.setId(EntityRecordUtils.getEuropeanaAggregationId((String)entityId));
        if (europeanaDataSource.isPresent()) {
            europeanaAggr.setRights(europeanaDataSource.get().getRights());
            europeanaAggr.setSource(europeanaDataSource.get().getUrl());
        }
        europeanaAggr.setCreated(timestamp);
        europeanaAggr.setModified(timestamp);
        EntityProxy europeanaProxy = new EntityProxy();
        europeanaProxy.setProxyId(EntityRecordUtils.getEuropeanaProxyId((String)entityId));
        europeanaProxy.setProxyFor(entityId);
        europeanaProxy.setProxyIn(europeanaAggr);
        this.addSameReferenceLinks(europeanaProxyMetadata, corefs);
        europeanaProxy.setEntity(europeanaProxyMetadata);
        entityRecord.addProxy(europeanaProxy);
    }

    public void addSameReferenceLinks(Entity entity, List<String> uris) {
        List entitySameReferenceLinks = entity.getSameReferenceLinks();
        if (entitySameReferenceLinks == null) {
            entity.setSameReferenceLinks(new ArrayList<String>(uris));
            return;
        }
        entity.setSameReferenceLinks(Stream.concat(entitySameReferenceLinks.stream(), uris.stream()).distinct().collect(Collectors.toList()));
    }

    protected EntityProxy setExternalProxy(Entity metisResponse, String proxyId, String entityId, DataSource externalDatasource, EntityRecord entityRecord, Date timestamp, int aggregationId) {
        Aggregation datasourceAggr = new Aggregation();
        datasourceAggr.setId(EntityRecordUtils.getDatasourceAggregationId((String)entityId, (int)aggregationId));
        datasourceAggr.setCreated(timestamp);
        datasourceAggr.setModified(timestamp);
        datasourceAggr.setRights(externalDatasource.getRights());
        datasourceAggr.setSource(externalDatasource.getUrl());
        EntityProxy datasourceProxy = new EntityProxy();
        datasourceProxy.setProxyId(proxyId);
        datasourceProxy.setProxyFor(entityId);
        datasourceProxy.setProxyIn(datasourceAggr);
        datasourceProxy.setEntity(metisResponse);
        entityRecord.addProxy(datasourceProxy);
        return datasourceProxy;
    }

    protected void processRoleReference(Organization org) {
        if (org.getEuropeanaRoleIds() != null && !org.getEuropeanaRoleIds().isEmpty()) {
            List vocabs = this.vocabRepository.findByUri(org.getEuropeanaRoleIds());
            if (vocabs.isEmpty()) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("No vocabularies with the uris: {} were found in the database. Cannot assign role reference to organization with id {}", (Object)org.getEuropeanaRoleIds(), (Object)org.getEntityId());
                }
            } else {
                org.setEuropeanaRoleRefs(vocabs);
            }
        }
    }

    protected void processCountryReference(Organization org) {
        if (StringUtils.isEmpty((String)org.getCountryId())) {
            return;
        }
        String europeanaCountryId = this.getEuropeanaCountryId(org);
        if (europeanaCountryId == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Dropping unsupported country id in consolidated entity version: {} -- {} ", (Object)org.getEntityId(), (Object)org.getCountryId());
            }
            org.setCountryId(null);
        } else {
            org.setCountryId(europeanaCountryId);
            EntityRecord orgCountry = this.entityRecordRepository.findByEntityId(europeanaCountryId, null);
            if (orgCountry != null) {
                org.setCountryRef(orgCountry);
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn("No country found in database for the entity id: {}. Cannot assign country reference to organization with id {}", (Object)europeanaCountryId, (Object)org.getEntityId());
            }
        }
    }

    String getEuropeanaCountryId(Organization org) {
        if (EntityRecordUtils.isEuropeanaEntity((String)org.getCountryId())) {
            return org.getCountryId();
        }
        return null;
    }

    boolean isStringOrPrimitive(Class<?> fieldType) {
        return String.class.isAssignableFrom(fieldType) || ClassUtils.isPrimitiveOrWrapper(fieldType);
    }

    void combineEntities(Entity consolidatedEntity, Entity primary, Entity secondary, Map<Object, Object> prefLabelsForAltLabels, Field field, String fieldName, boolean accumulate) throws IllegalAccessException, EntityUpdateException {
        Map fieldValuePrimaryObjectMap = (Map)primary.getFieldValue(field);
        Map fieldValueSecondaryObjectMap = (Map)secondary.getFieldValue(field);
        Map<Object, Object> fieldValuePrimaryObject = this.deepCopyOfMap(fieldValuePrimaryObjectMap);
        Map<Object, Object> fieldValueSecondaryObject = this.deepCopyOfMap(fieldValueSecondaryObjectMap);
        if (!CollectionUtils.isEmpty(fieldValuePrimaryObject) && !CollectionUtils.isEmpty(fieldValueSecondaryObject) && accumulate) {
            for (Map.Entry<Object, Object> elemSecondary : fieldValueSecondaryObject.entrySet()) {
                Object key = elemSecondary.getKey();
                this.mergePrimarySecondaryListWitoutDuplicates(fieldValuePrimaryObject, key, elemSecondary, fieldName, prefLabelsForAltLabels);
            }
            consolidatedEntity.setFieldValue(field, fieldValuePrimaryObject);
        } else if (!CollectionUtils.isEmpty(fieldValuePrimaryObject)) {
            consolidatedEntity.setFieldValue(field, fieldValuePrimaryObject);
        } else if (!CollectionUtils.isEmpty(fieldValueSecondaryObject)) {
            consolidatedEntity.setFieldValue(field, fieldValueSecondaryObject);
        }
    }

    void mergeSkippedPrefLabels(Entity consolidatedEntity, Map<Object, Object> prefLabelsForAltLabels, List<Field> allEntityFields) throws IllegalAccessException, EntityUpdateException {
        if (prefLabelsForAltLabels.isEmpty()) {
            return;
        }
        Optional<Field> altLabelField = allEntityFields.stream().filter(field -> this.isFieldAltLabel(field.getName())).findFirst();
        if (altLabelField.isEmpty()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("altLabel field not found in list: {}", allEntityFields);
            }
            return;
        }
        Map altLabelConsolidatedMap = (Map)consolidatedEntity.getFieldValue(altLabelField.get());
        Map<Object, Object> altLabelPrimaryObject = this.deepCopyOfMap(altLabelConsolidatedMap);
        boolean altLabelPrimaryValueChanged = false;
        if (altLabelPrimaryValueChanged = this.addValuesToAltLabel(prefLabelsForAltLabels, altLabelPrimaryObject, altLabelPrimaryValueChanged)) {
            consolidatedEntity.setFieldValue(altLabelField.get(), altLabelPrimaryObject);
        }
    }

    static boolean doSloppyMatch(String fieldName) {
        if (EntityFieldsTypes.hasTypeDefinition((String)fieldName)) {
            String type = EntityFieldsTypes.getFieldType((String)fieldName);
            if (StringUtils.equals((String)type, (String)"Text")) {
                return true;
            }
            if (StringUtils.equals((String)type, (String)"URI") || StringUtils.equals((String)type, (String)"Keyword")) {
                return false;
            }
        }
        return false;
    }
}

