/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web;

import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.entitymanagement.batch.service.EntityUpdateService;
import eu.europeana.entitymanagement.common.config.DataSource;
import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.config.DataSources;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledRemovalType;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledUpdateType;
import eu.europeana.entitymanagement.definitions.exceptions.UnsupportedEntityTypeException;
import eu.europeana.entitymanagement.definitions.model.Aggregation;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.EntityProxy;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.definitions.web.EntityIdDisabledStatus;
import eu.europeana.entitymanagement.definitions.web.EntityIdResponse;
import eu.europeana.entitymanagement.dereference.Dereferencer;
import eu.europeana.entitymanagement.exception.DatasourceNotKnownException;
import eu.europeana.entitymanagement.exception.EntityMismatchException;
import eu.europeana.entitymanagement.exception.EntityNotFoundException;
import eu.europeana.entitymanagement.exception.EntityRemovedException;
import eu.europeana.entitymanagement.exception.HttpBadRequestException;
import eu.europeana.entitymanagement.exception.MultipleChoicesException;
import eu.europeana.entitymanagement.solr.SolrSearchCursorIterator;
import eu.europeana.entitymanagement.solr.exception.SolrServiceException;
import eu.europeana.entitymanagement.solr.model.SolrEntity;
import eu.europeana.entitymanagement.solr.service.SolrService;
import eu.europeana.entitymanagement.utils.EntityRecordUtils;
import eu.europeana.entitymanagement.vocabulary.EntityProfile;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import eu.europeana.entitymanagement.vocabulary.FormatTypes;
import eu.europeana.entitymanagement.vocabulary.ValidationObject;
import eu.europeana.entitymanagement.web.BaseRest;
import eu.europeana.entitymanagement.web.service.DereferenceServiceLocator;
import eu.europeana.entitymanagement.web.service.EntityRecordService;
import io.swagger.annotations.ApiOperation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@Validated
@ConditionalOnWebApplication
public class EMController
extends BaseRest {
    private final EntityRecordService entityRecordService;
    private final SolrService solrService;
    private final DereferenceServiceLocator dereferenceServiceLocator;
    private final DataSources datasources;
    private final EntityUpdateService entityUpdateService;
    private static final String EXTERNAL_ID_REMOVED_MSG = "Entity id '%s' already exists as '%s', which has been removed";
    private static final String SAME_AS_NOT_EXISTS_MSG = "Url '%s' does not exist in entity owl:sameAs or skos:exactMatch";
    public static final String INVALID_UPDATE_REQUEST_MSG = "Request must either specify a 'query' param or contain entity identifiers in body";
    public static final EntityProfile DEFAULT_REQUEST_PROFILE = EntityProfile.external;

    @Autowired
    public EMController(EntityRecordService entityRecordService, SolrService solrService, DereferenceServiceLocator dereferenceServiceLocator, DataSources datasources, EntityUpdateService entityUpdateService, EntityManagementConfiguration emConfig) {
        this.entityRecordService = entityRecordService;
        this.solrService = solrService;
        this.dereferenceServiceLocator = dereferenceServiceLocator;
        this.datasources = datasources;
        this.entityUpdateService = entityUpdateService;
    }

    @ApiOperation(value="Disable an entity", nickname="disableEntity", response=Void.class)
    @DeleteMapping(value={"/entity/{type}/{identifier}"}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> disableEntity(@RequestHeader(value="If-Match", required=false) String ifMatchHeader, @PathVariable(value="type") String type, @PathVariable(value="identifier") String identifier, @RequestParam(value="profile", required=false) String profile, HttpServletRequest request) throws HttpException, EuropeanaApiException {
        this.verifyWriteAccess("delete", request);
        EntityRecord entityRecord = null;
        try {
            entityRecord = this.entityRecordService.retrieveEntityRecord(EntityTypes.getByEntityType((String)type), identifier, profile, false);
        }
        catch (UnsupportedEntityTypeException e) {
            throw new EntityNotFoundException("/" + type + "/" + identifier, e);
        }
        Aggregation isAggregatedBy = entityRecord.getEntity().getIsAggregatedBy();
        String etag = this.generateETag(isAggregatedBy.getModified(), FormatTypes.jsonld.name(), this.getApiVersion());
        this.checkIfMatchHeader(etag, request);
        boolean isSynchronous = this.containsSyncProfile(profile);
        String entityId = entityRecord.getEntityId();
        this.logger.debug("Deprecating entityId={}, isSynchronous={}", (Object)entityId, (Object)isSynchronous);
        if (isSynchronous) {
            this.entityRecordService.disableEntityRecord(entityRecord, true);
        } else {
            this.entityUpdateService.scheduleTasks(Collections.singletonList(entityId), (ScheduledTaskType)ScheduledRemovalType.DEPRECATION);
        }
        return this.noContentResponse(request);
    }

    @ApiOperation(value="Re-enable an entity", nickname="enableEntity", response=Void.class)
    @PostMapping(value={"/entity/{type}/{identifier}"}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> enableEntity(@RequestParam(value="profile", required=false) String profile, @PathVariable(value="type") String type, @PathVariable(value="identifier") String identifier, HttpServletRequest request) throws HttpException, EuropeanaApiException {
        List<EntityProfile> entityProfile = this.getEntityProfile(profile);
        this.verifyWriteAccess("update", request);
        EntityTypes enType = null;
        try {
            enType = EntityTypes.getByEntityType((String)type);
        }
        catch (UnsupportedEntityTypeException e1) {
            throw new EntityNotFoundException("/" + type + "/" + identifier, e1);
        }
        EntityRecord entityRecord = this.entityRecordService.retrieveEntityRecord(enType, identifier, profile, true);
        if (!entityRecord.isDisabled()) {
            return this.generateResponseEntityForEntityRecord(request, entityProfile, FormatTypes.jsonld, null, "application/ld+json;charset=utf-8", entityRecord, HttpStatus.OK);
        }
        this.logger.debug("Re-enabling entityId={}", (Object)entityRecord.getEntityId());
        this.entityRecordService.enableEntityRecord(entityRecord);
        entityRecord = this.entityRecordService.retrieveEntityRecord(enType, identifier, profile, false);
        return this.generateResponseEntityForEntityRecord(request, entityProfile, FormatTypes.jsonld, null, "application/ld+json;charset=utf-8", entityRecord, HttpStatus.OK);
    }

    @ApiOperation(value="Update an entity", nickname="updateEntity", response=Void.class)
    @PutMapping(value={"/entity/{type}/{identifier}"}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> updateEntity(@RequestHeader(value="If-Match", required=false) String ifMatchHeader, @RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="profile", required=false) String profile, @PathVariable(value="type") String type, @PathVariable(value="identifier") String identifier, @RequestBody Entity updateRequestEntity, HttpServletRequest request) throws Exception {
        this.verifyWriteAccess("update", request);
        this.validateBodyEntity((ValidationObject)updateRequestEntity, false);
        EntityTypes enType = null;
        try {
            enType = EntityTypes.getByEntityType((String)type);
        }
        catch (UnsupportedEntityTypeException e) {
            throw new EntityNotFoundException("/" + type + "/" + identifier, e);
        }
        EntityRecord entityRecord = this.entityRecordService.retrieveEntityRecord(enType, identifier, profile, false);
        if (!entityRecord.getEntity().getType().equals(updateRequestEntity.getType())) {
            throw new HttpBadRequestException(String.format("Request type %s does not match Entity type", updateRequestEntity.getType()));
        }
        this.verifyCoreferencesForUpdate(updateRequestEntity, entityRecord);
        Aggregation isAggregatedBy = entityRecord.getEntity().getIsAggregatedBy();
        String etag = this.generateETag(isAggregatedBy.getModified(), FormatTypes.jsonld.name(), this.getApiVersion());
        this.checkIfMatchHeader(etag, request);
        this.entityRecordService.replaceEuropeanaProxy(updateRequestEntity, entityRecord);
        this.entityRecordService.update(entityRecord);
        try {
            return this.launchTaskAndRetrieveEntity(request, EntityTypes.getByEntityType((String)type), identifier, entityRecord, profile);
        }
        catch (UnsupportedEntityTypeException e) {
            throw new EntityNotFoundException("/" + type + "/" + identifier, e);
        }
    }

    private void verifyCoreferencesForUpdate(Entity updateRequestEntity, EntityRecord entityRecord) throws HttpBadRequestException {
        if (updateRequestEntity.getSameReferenceLinks() == null || updateRequestEntity.getSameReferenceLinks().isEmpty()) {
            throw new HttpBadRequestException("The mandatory coreferences (sameAs or exactMatch field) are missing in the request body");
        }
        List<EntityRecord> existingEntities = this.entityRecordService.findEntitiesByCoreference(updateRequestEntity.getSameReferenceLinks(), entityRecord.getEntityId(), false);
        if (!existingEntities.isEmpty()) {
            throw new HttpBadRequestException("The entity coreferences (sameAs or exactMatch field) contains an entry indicating the provided input as being a dupplicate of : " + EntityRecordUtils.getEntityIds(existingEntities));
        }
        List proxyIds = entityRecord.getExternalProxyIds();
        proxyIds.removeAll(updateRequestEntity.getSameReferenceLinks());
        if (!proxyIds.isEmpty()) {
            throw new HttpBadRequestException("The coreferences (sameAs or exactMatch field) of the request body does not contain the following proxies of the existing record:" + proxyIds);
        }
    }

    @ApiOperation(value="Update an entity from external data source", nickname="updateEntityFromDatasource", response=Void.class)
    @PostMapping(value={"/entity/{type}/{identifier}/management/update"}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> triggerSingleEntityFullUpdate(@PathVariable(value="type") String type, @PathVariable(value="identifier") String identifier, @RequestParam(value="profile", required=false) String profile, HttpServletRequest request) throws Exception {
        this.verifyWriteAccess("update", request);
        EntityTypes enType = null;
        try {
            enType = EntityTypes.getByEntityType((String)type);
        }
        catch (UnsupportedEntityTypeException e) {
            throw new EntityNotFoundException("/" + type + "/" + identifier, e);
        }
        EntityRecord entityRecord = this.entityRecordService.retrieveEntityRecord(enType, identifier, profile, false);
        this.datasources.verifyDataSource(((EntityProxy)entityRecord.getExternalProxies().get(0)).getProxyId(), false);
        return this.launchTaskAndRetrieveEntity(request, enType, identifier, entityRecord, profile);
    }

    @ApiOperation(value="Update multiple entities from external data source", nickname="updateMultipleEntityFromDatasource", response=Void.class)
    @PostMapping(value={"/entity/management/update"}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<EntityIdResponse> triggerFullUpdateMultipleEntities(@RequestBody(required=false) List<String> entityIds, @RequestParam(value="query", required=false) String query, HttpServletRequest request) throws Exception {
        this.verifyWriteAccess("update", request);
        if (StringUtils.isNotEmpty((CharSequence)query)) {
            return this.scheduleUpdatesWithSearch(request, query, (ScheduledTaskType)ScheduledUpdateType.FULL_UPDATE);
        }
        if (CollectionUtils.isEmpty(entityIds)) {
            throw new HttpBadRequestException(INVALID_UPDATE_REQUEST_MSG);
        }
        return this.scheduleBatchUpdates(request, entityIds, (ScheduledTaskType)ScheduledUpdateType.FULL_UPDATE);
    }

    @ApiOperation(value="Update metrics for given entities", nickname="updateMetricsForEntities", response=Void.class)
    @PostMapping(value={"/entity/management/metrics"}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<EntityIdResponse> triggerMetricsUpdateMultipleEntities(@RequestBody(required=false) List<String> entityIds, @RequestParam(value="query", required=false) String query, HttpServletRequest request) throws Exception {
        this.verifyWriteAccess("update", request);
        if (StringUtils.isNotEmpty((CharSequence)query)) {
            return this.scheduleUpdatesWithSearch(request, query, (ScheduledTaskType)ScheduledUpdateType.METRICS_UPDATE);
        }
        if (CollectionUtils.isEmpty(entityIds)) {
            throw new HttpBadRequestException(INVALID_UPDATE_REQUEST_MSG);
        }
        return this.scheduleBatchUpdates(request, entityIds, (ScheduledTaskType)ScheduledUpdateType.METRICS_UPDATE);
    }

    @ApiOperation(value="Enable or disable the use of the entity for enrichment", nickname="enableDisableForEnrich", response=Void.class)
    @PostMapping(value={"/entity/{type}/{identifier}/management/enrich"}, produces={"application/json", "application/ld+json"})
    public ResponseEntity<String> enableDisableForEnrich(@PathVariable(value="type") String type, @PathVariable(value="identifier") String identifier, @RequestParam(value="action") String action, @RequestParam(value="profile", required=false, defaultValue="internal") String profile, HttpServletRequest request) throws Exception {
        this.verifyWriteAccess("update", request);
        this.validateAction(action);
        EntityRecord entityRecord = this.entityRecordService.updateUsedForEnrichment(EntityTypes.getByEntityType((String)type), identifier, profile, action);
        entityRecord = this.launchMetricsUpdateTask(entityRecord, profile, true);
        return this.generateResponseEntityForEntityRecord(request, this.getEntityProfile(profile), FormatTypes.jsonld, null, "application/ld+json;charset=utf-8", entityRecord, HttpStatus.OK);
    }

    private void validateAction(String action) throws HttpBadRequestException {
        if (!StringUtils.equalsAnyIgnoreCase((CharSequence)action, (CharSequence[])new CharSequence[]{"enable", "disable"})) {
            throw new HttpBadRequestException("Invalid value for param action: " + action + ". Supported values are [enable, disable]");
        }
    }

    @ApiOperation(value="Retrieve a known entity", nickname="getEntityJsonLd", response=Void.class)
    @GetMapping(value={"/entity/{type}/base/{identifier}.jsonld", "/entity/{type}/base/{identifier}.json", "/entity/{type}/{identifier}.jsonld", "/entity/{type}/{identifier}.json", "/entity/{type}/base/{identifier}", "/entity/{type}/{identifier}"}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> getJsonLdEntity(@RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="profile", required=false) String profile, @RequestParam(value="lang", required=false) String languages, @PathVariable(value="type") String type, @PathVariable(value="identifier") String identifier, HttpServletRequest request) throws EuropeanaApiException, HttpException {
        this.verifyReadAccess(request);
        try {
            return this.createResponseForRetrieve(EntityTypes.getByEntityType((String)type), identifier, profile, request, FormatTypes.jsonld, languages, "application/ld+json;charset=utf-8");
        }
        catch (UnsupportedEntityTypeException e) {
            throw new EntityNotFoundException("/" + type + "/" + identifier, e);
        }
    }

    @ApiOperation(value="Retrieve a known entity", nickname="getEntityXml", response=Void.class)
    @RequestMapping(value={"/entity/{type}/base/{identifier}.xml", "/entity/{type}/{identifier}.xml", "/entity/{type}/{identifier}"}, method={RequestMethod.GET}, produces={"application/xml", "application/rdf+xml", "rdf/xml"})
    public ResponseEntity<String> getXmlEntity(@RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="profile", required=false) String profile, @RequestParam(value="lang", required=false) String languages, @PathVariable(value="type") String type, @PathVariable(value="identifier") String identifier, HttpServletRequest request) throws EuropeanaApiException, HttpException {
        this.verifyReadAccess(request);
        try {
            return this.createResponseForRetrieve(EntityTypes.getByEntityType((String)type), identifier, profile, request, FormatTypes.xml, languages, "application/rdf+xml");
        }
        catch (UnsupportedEntityTypeException e) {
            throw new EntityNotFoundException("/" + type + "/" + identifier, e);
        }
    }

    @ApiOperation(value="Retrieve a known entity", nickname="getEntitySchemaJsonLd", response=Void.class)
    @GetMapping(value={"/entity/{type}/base/{identifier}.schema.jsonld", "/entity/{type}/base/{identifier}.schema.json", "/entity/{type}/{identifier}.schema.jsonld", "/entity/{type}/{identifier}.schema.json"}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> getEntitySchemaJsonLd(@RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="profile", required=false) String profile, @RequestParam(value="lang", required=false) String languages, @PathVariable(value="type") String type, @PathVariable(value="identifier") String identifier, HttpServletRequest request) throws EuropeanaApiException, HttpException {
        this.verifyReadAccess(request);
        try {
            return this.createResponseForRetrieve(EntityTypes.getByEntityType((String)type), identifier, profile, request, FormatTypes.schema, languages, "application/ld+json;charset=utf-8");
        }
        catch (UnsupportedEntityTypeException e) {
            throw new EntityNotFoundException("/" + type + "/" + identifier, e);
        }
    }

    @ApiOperation(value="Register a new entity", nickname="registerEntity", response=Void.class)
    @PostMapping(value={"/entity/"}, produces={"application/json", "application/ld+json"})
    public ResponseEntity<String> registerEntity(@RequestBody Entity europeanaProxyEntity, HttpServletRequest request) throws Exception {
        List<String> corefs;
        this.verifyWriteAccess("create", request);
        this.validateBodyEntity((ValidationObject)europeanaProxyEntity, false);
        String creationRequestId = europeanaProxyEntity.getEntityId();
        if (!StringUtils.isNotEmpty((CharSequence)creationRequestId)) {
            throw new HttpBadRequestException("Mandatory field missing in the request body: id");
        }
        this.logger.debug("Registering new entity: externalId={}", (Object)creationRequestId);
        if (europeanaProxyEntity.getIsAggregatedBy() != null) {
            europeanaProxyEntity.setIsAggregatedBy(null);
        }
        if (europeanaProxyEntity.getSameReferenceLinks() == null) {
            corefs = Collections.singletonList(creationRequestId);
        } else {
            corefs = new ArrayList<String>(europeanaProxyEntity.getSameReferenceLinks());
            corefs.add(creationRequestId);
        }
        List<EntityRecord> existingEntities = this.entityRecordService.findEntitiesByCoreference(corefs, null, false);
        ResponseEntity<String> response = this.checkExistingEntity(existingEntities, creationRequestId);
        if (response != null) {
            return response;
        }
        DataSource dataSource = this.datasources.verifyDataSource(creationRequestId, false);
        String creationRequestType = europeanaProxyEntity.getType();
        if (EntityTypes.isOrganization((String)creationRequestType) && !creationRequestId.contains("crm.zoho.eu")) {
            throw new HttpBadRequestException(String.format("The Organization entity should come from Zoho and have the corresponding id format containing: %s", "crm.zoho.eu"));
        }
        Entity datasourceResponse = this.dereferenceEntity(creationRequestId, creationRequestType);
        EntityRecord savedEntityRecord = this.entityRecordService.createEntityFromRequest(europeanaProxyEntity, datasourceResponse, dataSource, null);
        this.logger.debug("Created Entity record for externalId={}; entityId={}", (Object)creationRequestId, (Object)savedEntityRecord.getEntityId());
        return this.launchTaskAndRetrieveEntity(request, EntityTypes.getByEntityType((String)savedEntityRecord.getEntity().getType()), this.getDatabaseIdentifier(savedEntityRecord.getEntityId()), savedEntityRecord, EntityProfile.internal.toString());
    }

    Entity dereferenceEntity(String creationRequestId, String creationRequestType) throws Exception, DatasourceNotKnownException, EntityMismatchException {
        Dereferencer dereferenceService = this.dereferenceServiceLocator.getDereferencer(creationRequestId, creationRequestType);
        Optional datasourceResponseOptional = dereferenceService.dereferenceEntityById(creationRequestId);
        if (datasourceResponseOptional.isEmpty()) {
            throw new DatasourceNotKnownException("Unsuccessful dereferenciation for externalId=" + creationRequestId);
        }
        Entity datasourceResponse = (Entity)datasourceResponseOptional.get();
        if (!datasourceResponse.getType().equals(creationRequestType)) {
            throw new EntityMismatchException(String.format("Datasource type '%s' does not match type '%s' in request", datasourceResponse.getType(), creationRequestType));
        }
        return datasourceResponse;
    }

    @ApiOperation(value="Change provenance for an Entity", nickname="changeProvenance")
    @PutMapping(value={"/entity/{type}/{identifier}/management/source"}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> changeProvenance(@PathVariable(value="type") String type, @PathVariable(value="identifier") String identifier, @RequestParam(value="profile", required=false) String profile, @RequestParam(value="url") String url, HttpServletRequest request) throws Exception {
        this.verifyWriteAccess("update", request);
        EntityTypes enType = EntityTypes.getByEntityType((String)type);
        EntityRecord entityRecord = this.entityRecordService.retrieveEntityRecord(enType, identifier, profile, false);
        if (!entityRecord.getEntity().getSameReferenceLinks().contains(url)) {
            throw new HttpBadRequestException(String.format(SAME_AS_NOT_EXISTS_MSG, url));
        }
        this.entityRecordService.changeExternalProxy(entityRecord, url);
        this.entityRecordService.update(entityRecord);
        return this.launchTaskAndRetrieveEntity(request, enType, identifier, entityRecord, profile);
    }

    @ApiOperation(value="Retrieve multiple entities", nickname="retrieveEntities")
    @PostMapping(value={"/entity/retrieve"}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> retrieveEntities(@RequestParam(value="wskey", required=false) String wskey, @RequestBody List<String> urls, HttpServletRequest request) throws Exception {
        this.verifyReadAccess(request);
        return this.createResponseMultipleEntities(urls, request);
    }

    private ResponseEntity<String> createResponseForRetrieve(EntityTypes type, String identifier, String profile, HttpServletRequest request, FormatTypes outFormat, String languages, String contentType) throws EuropeanaApiException {
        EntityRecord entityRecord = null;
        try {
            entityRecord = this.entityRecordService.retrieveEntityRecord(type, identifier, profile, true);
        }
        catch (EntityNotFoundException ex) {
            String redirectUri = this.entityRecordService.getRedirectUriWhenNotFound(type, identifier, ex, request);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.MOVED_PERMANENTLY).location(URI.create(redirectUri))).build();
        }
        if (entityRecord.isDisabled()) {
            String redirectUri = this.entityRecordService.getRedirectUriWhenDeprecated(entityRecord, identifier, request);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.MOVED_PERMANENTLY).location(URI.create(redirectUri))).build();
        }
        List<EntityProfile> entityProfile = this.getEntityProfile(profile);
        return this.generateResponseEntityForEntityRecord(request, entityProfile, outFormat, languages, contentType, entityRecord, HttpStatus.OK);
    }

    private ResponseEntity<String> createResponseMultipleEntities(List<String> entityIds, HttpServletRequest request) throws EuropeanaApiException {
        List<EntityRecord> entityRecords = this.entityRecordService.retrieveMultipleByEntityIdsOrCoreference(entityIds);
        String contentType = "application/ld+json;charset=utf-8";
        HttpHeaders headers = this.createAllowHeader(request);
        headers.add("Content-Type", contentType);
        String body = this.serialize(entityRecords);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(headers)).body((Object)body);
    }

    private List<EntityProfile> getEntityProfile(String profileParamString) throws HttpBadRequestException {
        if (!StringUtils.isNotEmpty((CharSequence)profileParamString)) {
            return List.of(DEFAULT_REQUEST_PROFILE);
        }
        String[] splitAndTrimProfile = (String[])Arrays.stream(profileParamString.split(",")).map(String::trim).toArray(String[]::new);
        ArrayList<String> requestProfiles = new ArrayList<String>(List.of(splitAndTrimProfile));
        List validProfiles = Arrays.stream(EntityProfile.values()).map(Enum::name).collect(Collectors.toList());
        requestProfiles.retainAll(validProfiles);
        if (requestProfiles.isEmpty() || requestProfiles.contains(EntityProfile.internal.name()) && requestProfiles.contains(EntityProfile.external.name())) {
            throw new HttpBadRequestException("Invalid profile query param " + profileParamString);
        }
        return requestProfiles.stream().map(EntityProfile::valueOf).collect(Collectors.toList());
    }

    private EntityRecord launchMetricsUpdateTask(EntityRecord entityRecord, String profile, boolean includeDisabled) throws Exception {
        this.entityUpdateService.runSynchronousMetricsUpdate(entityRecord.getEntityId());
        return this.entityRecordService.retrieveEntityRecord(entityRecord.getEntityId(), profile, includeDisabled);
    }

    private ResponseEntity<String> launchTaskAndRetrieveEntity(HttpServletRequest request, EntityTypes type, String identifier, EntityRecord entityRecord, String profile) throws Exception {
        this.launchUpdateTask(entityRecord.getEntityId());
        entityRecord = this.entityRecordService.retrieveEntityRecord(type, identifier, profile, false);
        return this.generateResponseEntityForEntityRecord(request, this.getEntityProfile(profile), FormatTypes.jsonld, null, "application/ld+json;charset=utf-8", entityRecord, HttpStatus.ACCEPTED);
    }

    private ResponseEntity<String> checkExistingEntity(List<EntityRecord> existingEntities, String entityCreationId) throws EntityRemovedException, MultipleChoicesException {
        if (existingEntities == null || existingEntities.isEmpty()) {
            return null;
        }
        if (existingEntities.size() > 1) {
            throw new MultipleChoicesException(String.format("There are multiple choices for redirecting the entity id: '%s'. They include: '%s'.", entityCreationId, EntityRecordUtils.getEntityIds(existingEntities).toString()));
        }
        if (existingEntities.get(0).isDisabled()) {
            throw new EntityRemovedException(String.format(EXTERNAL_ID_REMOVED_MSG, entityCreationId, existingEntities.get(0).getEntityId()));
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.MOVED_PERMANENTLY).location(UriComponentsBuilder.newInstance().path("/entity/{id}").buildAndExpand(new Object[]{EntityRecordUtils.extractEntityPathFromEntityId((String)existingEntities.get(0).getEntityId())}).toUri())).build();
    }

    private ResponseEntity<EntityIdResponse> scheduleBatchUpdates(HttpServletRequest request, List<String> entityIds, ScheduledTaskType updateType) {
        EntityIdResponse entityIdResponse = new EntityIdResponse();
        List<String> entityIdsToSchedule = this.updateEntityIdResponse(entityIdResponse, entityIds);
        this.entityUpdateService.scheduleTasks(entityIdsToSchedule, updateType);
        HttpHeaders httpHeaders = this.createAllowHeader(request);
        httpHeaders.add("Content-Type", "application/ld+json;charset=utf-8");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.accepted().headers(httpHeaders)).body((Object)entityIdResponse);
    }

    ResponseEntity<EntityIdResponse> scheduleUpdatesWithSearch(HttpServletRequest request, String query, ScheduledTaskType updateType) throws SolrServiceException {
        SolrSearchCursorIterator iterator = this.solrService.getSearchIterator(query, List.of("type", "id"));
        EntityIdResponse entityIdResponse = new EntityIdResponse();
        while (iterator.hasNext()) {
            List solrEntities = iterator.next();
            List<String> entityIds = solrEntities.stream().map(SolrEntity::getEntityId).collect(Collectors.toList());
            List<String> entityIdsToSchedule = this.updateEntityIdResponse(entityIdResponse, entityIds);
            this.entityUpdateService.scheduleTasks(entityIdsToSchedule, updateType);
        }
        HttpHeaders httpHeaders = this.createAllowHeader(request);
        httpHeaders.add("Content-Type", "application/ld+json;charset=utf-8");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.accepted().headers(httpHeaders)).body((Object)entityIdResponse);
    }

    private List<String> updateEntityIdResponse(EntityIdResponse entityIdResponse, List<String> entityIds) {
        List<EntityIdDisabledStatus> statusList = this.entityRecordService.retrieveEntityDeprecationStatus(entityIds, false);
        List existingEntityIds = statusList.stream().map(EntityIdDisabledStatus::getEntityId).collect(Collectors.toList());
        List failures = entityIds.stream().filter(e -> !existingEntityIds.contains(e)).collect(Collectors.toList());
        Map<Boolean, List<EntityIdDisabledStatus>> entityIdsByDisabled = statusList.stream().collect(Collectors.groupingBy(EntityIdDisabledStatus::isDisabled));
        List<EntityIdDisabledStatus> nonDisabledEntities = entityIdsByDisabled.get(false);
        List<String> toBeScheduled = CollectionUtils.isEmpty(nonDisabledEntities) ? Collections.emptyList() : nonDisabledEntities.stream().map(EntityIdDisabledStatus::getEntityId).collect(Collectors.toList());
        List<EntityIdDisabledStatus> disabledEntities = entityIdsByDisabled.get(true);
        List skipped = CollectionUtils.isEmpty(disabledEntities) ? Collections.emptyList() : disabledEntities.stream().map(EntityIdDisabledStatus::getEntityId).collect(Collectors.toList());
        entityIdResponse.updateValues(entityIds.size(), toBeScheduled, failures, skipped, this.emConfig.getEntityIdResponseMaxSize());
        return toBeScheduled;
    }

    private void launchUpdateTask(String entityId) throws Exception {
        this.entityUpdateService.runSynchronousUpdate(entityId);
    }
}

