/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.serialization;

import eu.europeana.entitymanagement.definitions.exceptions.EntityManagementRuntimeException;
import eu.europeana.entitymanagement.exception.FunctionalRuntimeException;
import eu.europeana.entitymanagement.web.xml.model.RdfBaseWrapper;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="emXmlSerializer")
public class EntityXmlSerializer
implements InitializingBean {
    private final JAXBContext jaxbContext;
    private ThreadLocal<Marshaller> marshaller;

    @Autowired
    public EntityXmlSerializer(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public void afterPropertiesSet() {
        this.marshaller = ThreadLocal.withInitial(() -> {
            try {
                Marshaller newMarshaller = this.jaxbContext.createMarshaller();
                newMarshaller.setProperty("jaxb.formatted.output", (Object)true);
                return newMarshaller;
            }
            catch (JAXBException e) {
                throw new FunctionalRuntimeException("Error creating JAXB unmarshaller ", e);
            }
        });
    }

    public String serializeXmlExternal(RdfBaseWrapper xmlWrapper) throws EntityManagementRuntimeException {
        StringWriter sw = new StringWriter();
        try {
            this.marshaller.get().marshal((Object)xmlWrapper, (Writer)sw);
        }
        catch (JAXBException e) {
            throw new EntityManagementRuntimeException(String.format("Error serializing xml; about=%s ", xmlWrapper.getXmlEntity().getAbout()), (Throwable)e);
        }
        return sw.toString();
    }
}

