/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.config;

import java.util.HashMap;
import java.util.Map;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    MediaType jsonLdMediaType = MediaType.valueOf((String)"application/ld+json");
    Map<String, MediaType> mediaTypesMaping = new HashMap<String, MediaType>();

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/v2/api-docs").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Headers"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/v2/api-docs/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Headers"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/scheme/").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"POST"}).exposedHeaders(new String[]{"Allow", "Link", "ETag", "Access-Control-Allow-Headers"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/scheme/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET", "PUT", "DELETE", "HEAD"}).exposedHeaders(new String[]{"Allow", "Vary", "Link", "ETag", "Access-Control-Allow-Headers"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"*"}).allowedHeaders(new String[]{"*"}).allowCredentials(false).exposedHeaders(new String[]{"Allow"}).maxAge(1000L);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorPathExtension(true);
        configurer.useRegisteredExtensionsOnly(true);
        configurer.mediaTypes(this.getMediaTypesMapping());
        configurer.defaultContentType(new MediaType[]{MediaType.valueOf((String)"application/ld+json")});
    }

    private Map<String, MediaType> getMediaTypesMapping() {
        this.mediaTypesMaping.put("json", MediaType.APPLICATION_JSON);
        this.mediaTypesMaping.put("jsonld", this.jsonLdMediaType);
        this.mediaTypesMaping.put("xml", MediaType.APPLICATION_XML);
        return this.mediaTypesMaping;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/public/**"}).addResourceLocations(new String[]{"classpath:/public/"});
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setUseTrailingSlashMatch(Boolean.valueOf(false));
    }
}

