/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.service;

import com.mongodb.bulk.BulkWriteResult;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.internal.MorphiaCursor;
import eu.europeana.entitymanagement.batch.repository.ScheduledTaskRepository;
import eu.europeana.entitymanagement.definitions.batch.model.BatchEntityRecord;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTask;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="batchScheduledTaskService")
public class ScheduledTaskService {
    private final ScheduledTaskRepository repository;
    private static final Logger logger = LogManager.getLogger(ScheduledTaskService.class);

    @Autowired
    public ScheduledTaskService(ScheduledTaskRepository repository) {
        this.repository = repository;
    }

    public void scheduleTasksForEntities(Map<String, ScheduledTaskType> entityIdsToUpdateType) {
        List<ScheduledTask> tasks = this.createScheduledTasks(entityIdsToUpdateType, false);
        BulkWriteResult writeResult = this.repository.upsertBulk(tasks);
        logger.debug("Persisted scheduled tasks to db: matched={}, modified={}, inserted={}", (Object)writeResult.getMatchedCount(), (Object)writeResult.getModifiedCount(), (Object)writeResult.getInsertedCount());
    }

    public void markAsProcessed(Map<String, ScheduledTaskType> entityIdsToUpdateType) {
        List<ScheduledTask> tasks = this.createScheduledTasks(entityIdsToUpdateType, true);
        BulkWriteResult writeResult = this.repository.markAsProcessed(tasks);
        logger.debug("Marked scheduled tasks as processed: matched={}, modified={}, inserted={}", (Object)writeResult.getMatchedCount(), (Object)writeResult.getModifiedCount(), (Object)writeResult.getInsertedCount());
    }

    public void removeProcessedTasks(List<? extends ScheduledTaskType> updateType) {
        long removeCount = this.repository.removeProcessedTasks(updateType);
        if (removeCount > 0L && logger.isDebugEnabled()) {
            logger.debug("Removed scheduled tasks from db: count={}, updateType={}", (Object)removeCount, (Object)updateType.stream().map(ScheduledTaskType::getValue).collect(Collectors.joining(",")));
        }
    }

    public void removeScheduledTasksWithFailures(int maxFailedTaskRetries, List<? extends ScheduledTaskType> updateType) {
        try (MorphiaCursor<ScheduledTask> cursor = this.repository.getTasksWithFailures(maxFailedTaskRetries, updateType);){
            while (cursor.hasNext()) {
                this.repository.deleteScheduledTask(((ScheduledTask)cursor.next()).getEntityId());
            }
        }
    }

    public List<BatchEntityRecord> getEntityRecordsForTasks(int start, int count, Filter[] queryFilters) {
        return this.repository.getEntityRecordsForTasks(start, count, queryFilters);
    }

    public long getRunningTasksCount() {
        return this.repository.getRuningTasksCount();
    }

    public Optional<ScheduledTask> getTask(String entityId) {
        return Optional.ofNullable(this.repository.getTask(entityId));
    }

    public List<ScheduledTask> getTasks(List<String> entityIds) {
        return this.repository.getTasks(entityIds);
    }

    private List<ScheduledTask> createScheduledTasks(Map<String, ScheduledTaskType> entityIdToUpdateType, boolean hasBeenProcessed) {
        Instant now = Instant.now();
        return entityIdToUpdateType.entrySet().stream().map(mapElem -> new ScheduledTask.Builder((String)mapElem.getKey(), (ScheduledTaskType)mapElem.getValue()).setProcessed(hasBeenProcessed).modified(now).build()).collect(Collectors.toList());
    }

    public void dropCollection() {
        this.repository.dropCollection();
    }
}

