/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.service;

import eu.europeana.entitymanagement.batch.config.EntityUpdateJobConfig;
import eu.europeana.entitymanagement.batch.utils.BatchUtils;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledRemovalType;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledUpdateType;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@PropertySources(value={@PropertySource(value={"classpath:entitymanagement.properties"}), @PropertySource(value={"classpath:entitymanagement.user.properties"}, ignoreResourceNotFound=true)})
@Component
public class BatchEntityUpdateExecutor {
    private static final Logger logger = LogManager.getLogger(BatchEntityUpdateExecutor.class);
    private final JobLauncher entityUpdateJobLauncher;
    private final JobLauncher entityDeletionsJobLauncher;
    private final EntityUpdateJobConfig updateJobConfig;

    @Autowired
    public BatchEntityUpdateExecutor(@Qualifier(value="entityUpdateJobLauncher") JobLauncher entityUpdateJobLauncher, @Qualifier(value="entityRemovalsJobLauncher") JobLauncher entityDeletionsJobLauncher, EntityUpdateJobConfig batchUpdateConfig) {
        this.entityUpdateJobLauncher = entityUpdateJobLauncher;
        this.entityDeletionsJobLauncher = entityDeletionsJobLauncher;
        this.updateJobConfig = batchUpdateConfig;
    }

    @Async
    public void runScheduledUpdate() {
        logger.info("Triggering scheduled full and metrics update for entities");
        try {
            this.entityUpdateJobLauncher.run(this.updateJobConfig.updateScheduledEntities(List.of(ScheduledUpdateType.FULL_UPDATE, ScheduledUpdateType.METRICS_UPDATE)), BatchUtils.createJobParameters(null, Date.from(Instant.now()), List.of(ScheduledUpdateType.FULL_UPDATE, ScheduledUpdateType.METRICS_UPDATE), false));
        }
        catch (Exception e) {
            logger.warn("Error running scheduled full and metrics update", (Throwable)e);
        }
    }

    @Async
    public void runScheduledDeprecationsAndDeletions() {
        logger.info("Triggering scheduled deprecations and deletions for entities");
        try {
            this.entityDeletionsJobLauncher.run(this.updateJobConfig.removeScheduledEntities(List.of(ScheduledRemovalType.PERMANENT_DELETION, ScheduledRemovalType.DEPRECATION)), BatchUtils.createJobParameters(null, Date.from(Instant.now()), List.of(ScheduledRemovalType.PERMANENT_DELETION, ScheduledRemovalType.DEPRECATION), false));
        }
        catch (Exception e) {
            logger.warn("Error running scheduled deprecations and deletions", (Throwable)e);
        }
    }
}

