/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.service;

import eu.europeana.entitymanagement.dereference.Dereferencer;
import eu.europeana.entitymanagement.web.service.MetisDereferenceService;
import eu.europeana.entitymanagement.wikidata.WikidataDereferenceService;
import eu.europeana.entitymanagement.zoho.organization.ZohoDereferenceService;
import eu.europeana.entitymanagement.zoho.utils.WikidataUtils;
import eu.europeana.entitymanagement.zoho.utils.ZohoUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DereferenceServiceLocator {
    private final MetisDereferenceService metisDereferenceService;
    private final ZohoDereferenceService zohoDereferenceService;
    private final WikidataDereferenceService wikidataDereferenceService;

    @Autowired
    public DereferenceServiceLocator(MetisDereferenceService metisDereferenceService, ZohoDereferenceService zohoDereferenceService, WikidataDereferenceService wikidataDereferenceService) {
        this.metisDereferenceService = metisDereferenceService;
        this.zohoDereferenceService = zohoDereferenceService;
        this.wikidataDereferenceService = wikidataDereferenceService;
    }

    public Dereferencer getDereferencer(String id, String entityType) {
        if (WikidataUtils.isWikidataOrganization((String)id, (String)entityType)) {
            return this.wikidataDereferenceService;
        }
        if (ZohoUtils.isZohoOrganization((String)id, (String)entityType)) {
            return this.zohoDereferenceService;
        }
        return this.metisDereferenceService;
    }
}

