/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.service;

import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.dereference.Dereferencer;
import eu.europeana.entitymanagement.exception.DatasourceNotReachableException;
import eu.europeana.entitymanagement.exception.DatasourceUpstreamServerError;
import eu.europeana.entitymanagement.exception.FunctionalRuntimeException;
import eu.europeana.entitymanagement.exception.HttpBadRequestException;
import eu.europeana.entitymanagement.web.MetisDereferenceUtils;
import eu.europeana.entitymanagement.web.xml.model.XmlBaseEntityImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientRequestException;
import reactor.core.Exceptions;
import reactor.netty.http.client.HttpClient;

@Service(value="metisDerefService")
public class MetisDereferenceService
implements InitializingBean,
Dereferencer {
    private static final Logger logger = LogManager.getLogger(MetisDereferenceService.class);
    private WebClient metisWebClient;
    private final JAXBContext jaxbContext;
    private final EntityManagementConfiguration config;
    private ThreadLocal<Unmarshaller> unmarshaller;

    @Autowired
    public MetisDereferenceService(EntityManagementConfiguration configuration, JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
        this.config = configuration;
    }

    public void afterPropertiesSet() throws MalformedURLException {
        this.configureMetisWebClient();
        this.configureJaxb();
    }

    public Optional<Entity> dereferenceEntityById(String id) throws Exception {
        String metisResponseBody = this.fetchMetisResponse(id);
        XmlBaseEntityImpl<?> metisResponse = MetisDereferenceUtils.parseMetisResponse(this.unmarshaller.get(), id, metisResponseBody);
        if (metisResponse == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(metisResponse.toEntityModel());
    }

    String fetchMetisResponse(String externalId) throws Exception {
        String metisResponseBody;
        Instant start = Instant.now();
        logger.debug("De-referencing externalId={} from Metis", (Object)externalId);
        try {
            metisResponseBody = (String)this.metisWebClient.get().uri(uriBuilder -> uriBuilder.path("/dereference").queryParam("uri", new Object[]{externalId}).build(new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_XML}).retrieve().onStatus(arg_0 -> HttpStatus.NOT_FOUND.equals(arg_0), response -> response.bodyToMono(String.class).map(DatasourceNotReachableException::new)).onStatus(HttpStatus::is4xxClientError, response -> response.bodyToMono(String.class).map(HttpBadRequestException::new)).onStatus(HttpStatus::isError, response -> response.bodyToMono(String.class).map(DatasourceUpstreamServerError::new)).bodyToMono(String.class).block();
        }
        catch (WebClientRequestException we) {
            throw new DatasourceNotReachableException(we.getMessage());
        }
        catch (Exception e) {
            Throwable t = Exceptions.unwrap((Throwable)e);
            if (t instanceof DatasourceNotReachableException) {
                throw new DatasourceNotReachableException(t.getMessage());
            }
            if (t instanceof HttpBadRequestException) {
                throw new HttpBadRequestException(t.getMessage());
            }
            if (t instanceof DatasourceUpstreamServerError) {
                throw new DatasourceUpstreamServerError(t.getMessage());
            }
            throw new Exception(t);
        }
        if (logger.isDebugEnabled()) {
            long duration = Duration.between(start, Instant.now()).toMillis();
            logger.debug("Metis response for externalId={} fetched in {}ms: {}", (Object)externalId, (Object)duration, (Object)metisResponseBody);
        }
        return metisResponseBody;
    }

    private void configureJaxb() {
        this.unmarshaller = ThreadLocal.withInitial(() -> {
            try {
                return this.jaxbContext.createUnmarshaller();
            }
            catch (JAXBException e) {
                throw new FunctionalRuntimeException("Error creating JAXB unmarshaller ", e);
            }
        });
    }

    private void configureMetisWebClient() throws MalformedURLException {
        WebClient.Builder webClientBuilder = WebClient.builder();
        HttpClient httpClient = HttpClient.create().followRedirect(true);
        webClientBuilder.clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient));
        if (this.config.useMetisProxy()) {
            this.setMetisProxy(webClientBuilder);
        } else {
            webClientBuilder.baseUrl(this.ensureNoTrailingSlash(this.config.getMetisBaseUrl()));
        }
        logger.info("Metis baseUrl={}", (Object)this.config.getMetisBaseUrl());
        this.metisWebClient = webClientBuilder.build();
    }

    void setMetisProxy(WebClient.Builder webClientBuilder) throws MalformedURLException {
        String defaultHostHeader = new URL(this.config.getMetisBaseUrl()).getHost();
        String proxyUrl = this.ensureNoTrailingSlash(this.config.getMetisProxyUrl());
        webClientBuilder.defaultHeader("Host", new String[]{defaultHostHeader}).baseUrl(proxyUrl);
        logger.debug("Using proxy for Metis dereferencing. defaultHostHeader={}; proxy={}", (Object)defaultHostHeader, (Object)proxyUrl);
    }

    private String ensureNoTrailingSlash(String url) {
        return url.endsWith("/") ? StringUtils.substring((String)url, (int)0, (int)(url.length() - 1)) : url;
    }
}

