/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.service;

import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.definitions.model.ConceptScheme;
import eu.europeana.entitymanagement.exception.EntityNotFoundException;
import eu.europeana.entitymanagement.exception.EntityRemovedException;
import eu.europeana.entitymanagement.exception.ingestion.EntityUpdateException;
import eu.europeana.entitymanagement.mongo.repository.ConceptSchemeRepository;
import eu.europeana.entitymanagement.solr.service.SolrService;
import eu.europeana.entitymanagement.utils.EntityUtils;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="emConceptSchemeService")
public class ConceptSchemeService {
    private final ConceptSchemeRepository emConceptSchemeRepo;
    private final SolrService solrService;
    final EntityManagementConfiguration emConfiguration;
    private static final Logger logger = LogManager.getLogger(ConceptSchemeService.class);

    @Autowired
    public ConceptSchemeService(ConceptSchemeRepository emConceptSchemeRepo, EntityManagementConfiguration emConfiguration, SolrService solrService) {
        this.emConceptSchemeRepo = emConceptSchemeRepo;
        this.emConfiguration = emConfiguration;
        this.solrService = solrService;
    }

    public void setMandatoryFields(ConceptScheme scheme) {
        if (scheme.getItems() != null) {
            scheme.setTotal(scheme.getItems().size());
        }
        Date now = new Date();
        scheme.setCreated(now);
        scheme.setModified(now);
    }

    public ConceptScheme createConceptScheme(ConceptScheme scheme) {
        Long id = this.generateConceptSchemeIdentifier();
        scheme.setIdentifier(id);
        this.setMandatoryFields(scheme);
        ConceptScheme dbScheme = this.emConceptSchemeRepo.saveConceptScheme(scheme);
        this.setConceptSchemeId(dbScheme);
        return dbScheme;
    }

    public ConceptScheme storeConceptScheme(ConceptScheme scheme) {
        this.emConceptSchemeRepo.saveConceptScheme(scheme);
        return scheme;
    }

    public ConceptScheme retrieveConceptScheme(long identifier) throws EuropeanaApiException {
        return this.retrieveConceptScheme(identifier, false);
    }

    public ConceptScheme retrieveConceptScheme(long identifier, boolean retrieveDisabled) throws EuropeanaApiException {
        ConceptScheme dbScheme = this.emConceptSchemeRepo.findConceptScheme(identifier);
        if (dbScheme == null) {
            throw new EntityNotFoundException("identifier:" + identifier);
        }
        if (!retrieveDisabled && dbScheme.isDisabled()) {
            throw new EntityRemovedException(String.format("Entity '%s' has been removed", identifier));
        }
        this.setConceptSchemeId(dbScheme);
        return dbScheme;
    }

    void setConceptSchemeId(ConceptScheme scheme) {
        scheme.setConceptSchemeId(EntityUtils.buildConceptSchemeId((String)this.emConfiguration.getSchemeDataEndpoint(), (Long)scheme.getIdentifier()));
    }

    public void disableConceptScheme(ConceptScheme scheme, boolean forceSolrCommit) throws EntityUpdateException {
        scheme.setDisabled(new Date());
        this.emConceptSchemeRepo.saveConceptScheme(scheme);
    }

    private Long generateConceptSchemeIdentifier() {
        return this.emConceptSchemeRepo.generateAutoIncrement(EntityTypes.ConceptScheme.getEntityType());
    }

    public void dropRepository() {
        this.emConceptSchemeRepo.dropCollection();
    }
}

