/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web;

import eu.europeana.api.commons.definitions.exception.DateParsingException;
import eu.europeana.api.commons.definitions.utils.DateUtils;
import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.entitymanagement.batch.service.EntityUpdateService;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledRemovalType;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import eu.europeana.entitymanagement.definitions.exceptions.EntityModelCreationException;
import eu.europeana.entitymanagement.definitions.exceptions.UnsupportedEntityTypeException;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.exception.EntityCreationException;
import eu.europeana.entitymanagement.exception.EntityNotFoundException;
import eu.europeana.entitymanagement.exception.HttpBadRequestException;
import eu.europeana.entitymanagement.utils.EntityRecordUtils;
import eu.europeana.entitymanagement.vocabulary.EntityProfile;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import eu.europeana.entitymanagement.vocabulary.FormatTypes;
import eu.europeana.entitymanagement.vocabulary.ValidationObject;
import eu.europeana.entitymanagement.web.BaseRest;
import eu.europeana.entitymanagement.web.model.ZohoSyncReport;
import eu.europeana.entitymanagement.web.service.EntityRecordService;
import eu.europeana.entitymanagement.web.service.ZohoSyncService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@RequestMapping(value={"/entity"})
@ConditionalOnWebApplication
public class EntityAdminController
extends BaseRest {
    private static final Logger LOG = LogManager.getLogger(EntityAdminController.class);
    private final EntityRecordService entityRecordService;
    private final ZohoSyncService zohoSyncService;
    private final EntityUpdateService entityUpdateService;

    @Autowired
    public EntityAdminController(EntityRecordService entityRecordService, EntityUpdateService entityUpdateService, ZohoSyncService zohoSyncService) {
        this.entityRecordService = entityRecordService;
        this.entityUpdateService = entityUpdateService;
        this.zohoSyncService = zohoSyncService;
    }

    @ApiOperation(value="Permanent Deletion of Entity", nickname="deleteEntity")
    @DeleteMapping(value={"/{type}/{identifier}/management"}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> deleteEntity(@RequestParam(value="wskey", required=false) String wskey, @PathVariable(value="type") String type, @PathVariable(value="identifier") String identifier, @RequestParam(value="profile", required=false) String profile, HttpServletRequest request) throws HttpException, EuropeanaApiException {
        this.verifyWriteAccess("delete", request);
        String entityUri = null;
        try {
            entityUri = EntityRecordUtils.buildEntityIdUri((EntityTypes)EntityTypes.getByEntityType((String)type), (String)identifier);
        }
        catch (UnsupportedEntityTypeException e) {
            throw new EntityNotFoundException("/" + type + "/" + identifier, e);
        }
        if (!this.entityRecordService.existsByEntityId(entityUri)) {
            throw new EntityNotFoundException(entityUri);
        }
        boolean isSynchronous = this.containsSyncProfile(profile);
        LOG.debug("Permanently deleting entityId={}, isSynchronous={}", (Object)entityUri, (Object)isSynchronous);
        if (isSynchronous) {
            this.entityRecordService.delete(entityUri);
        } else {
            this.entityUpdateService.scheduleTasks(Collections.singletonList(entityUri), (ScheduledTaskType)ScheduledRemovalType.PERMANENT_DELETION);
        }
        return this.noContentResponse(request);
    }

    @ApiOperation(value="Migrate existing Entity", nickname="migrateExistingEntity", response=Void.class)
    @PostMapping(value={"/{type}/{identifier}/management"}, produces={"application/json", "application/ld+json"})
    public ResponseEntity<String> migrateExistingEntity(@RequestParam(value="wskey", required=false) String wskey, @PathVariable(value="type") String type, @PathVariable(value="identifier") String identifier, @RequestBody Entity europeanaProxyEntity, HttpServletRequest request) throws HttpException, EuropeanaApiException {
        this.verifyWriteAccess("create", request);
        this.validateBodyEntity((ValidationObject)europeanaProxyEntity, false);
        try {
            type = EntityTypes.getByEntityType((String)type).toString();
            EntityRecord savedEntityRecord = this.entityRecordService.createEntityFromMigrationRequest(europeanaProxyEntity, type, identifier);
            LOG.debug("Created Entity record for {}; entityId={}", (Object)europeanaProxyEntity.getEntityId(), (Object)savedEntityRecord.getEntityId());
            return this.generateResponseEntityForEntityRecord(request, List.of(EntityProfile.internal), FormatTypes.jsonld, null, null, savedEntityRecord, HttpStatus.ACCEPTED);
        }
        catch (UnsupportedEntityTypeException e) {
            throw new EntityCreationException("Entity type invalid or not supported: " + type, e);
        }
        catch (EntityModelCreationException e) {
            throw new EntityCreationException("Error while creating entity object for " + type, e);
        }
    }

    @ApiOperation(value="Retrieve a list of entities for which an update failed.", nickname="getEntitiesUpdateFailedJsonLd", response=Void.class)
    @GetMapping(value={"/management/failed"}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> getEntitiesUpdateFailedJsonLd(@RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize, HttpServletRequest request) throws HttpException, EuropeanaApiException {
        this.verifyReadAccess(request);
        if (pageSize > 1000) {
            pageSize = 1000;
        }
        List<String> entityIds = this.failedTaskService.getEntityIdsWithFailures(page * pageSize, pageSize);
        return this.generateResponseFailedUpdates(request, entityIds, wskey);
    }

    @ApiOperation(value="Synchronize Organizations from Zoho", nickname="zohoSync", response=Void.class)
    @PostMapping(value={"/management/zohosync"}, produces={"application/json"})
    public ResponseEntity<String> zohoSync(@ApiParam(name="since", required=true, format="ISO DateTime", example="1970-01-01T00:00:00Z") @RequestParam String since, HttpServletRequest request) throws HttpException, EuropeanaApiException {
        this.verifyWriteAccess("zoho_sync", request);
        OffsetDateTime modifiedSince = this.validateSince(since);
        ZohoSyncReport zohoSyncReport = this.zohoSyncService.synchronizeZohoOrganizations(modifiedSince);
        return this.generateZohoSyncResponse(request, zohoSyncReport);
    }

    private OffsetDateTime validateSince(String since) throws HttpBadRequestException {
        if (since == null) {
            return Instant.EPOCH.atOffset(ZoneOffset.UTC);
        }
        try {
            return DateUtils.parseToOffsetDateTime((String)since);
        }
        catch (DateParsingException e) {
            throw new HttpBadRequestException("Request param 'since' is not an ISO DateTime: " + since, e);
        }
    }
}

